/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.ofd.base.config.SignInfoConfig;
import cfca.sadk.ofd.base.util.AbstractSigner;
import cfca.sadk.ofd.base.util.SignResultInfo;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Base64;
import cfca.svs.api.ClientEnvironment;
import cfca.svs.api.SVSComNUBusiness;
import cfca.svs.api.util.XmlUtil;
import java.security.GeneralSecurityException;

public class SVSSigner
extends AbstractSigner {
    private static Logger businessLog = LoggerFactory.getLogger(SVSSigner.class);
    private static boolean isInit = false;
    private String serviceId = null;

    public SVSSigner() {
    }

    public SVSSigner(String serviceId) {
        this.serviceId = serviceId;
    }

    public static void initEnv(String svsHosts, String port, String connectTimeout) throws Exception {
        String[] svsHost = svsHosts.split(",");
        ClientEnvironment.initClientEnvironmentByParam((String[])svsHost, (String)port, (String)connectTimeout, null);
        isInit = true;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public byte[] p1HashSign(Mechanism mechanism, String serviceId, byte[] hash) throws Exception {
        if (!isInit) {
            throw new Exception("invoke initEnv() first!");
        }
        String response = null;
        byte[] binarySignValue = null;
        SVSComNUBusiness svBusiness = new SVSComNUBusiness();
        response = Mechanisms.isSM2WithSM3((Mechanism)mechanism) ? svBusiness.sm2P1HashDirectSign(serviceId, Base64.encode((byte[])hash)) : svBusiness.rsaP1HashDirectSign(serviceId, Base64.encode((byte[])hash), mechanism.getMechanismType());
        if ("".equals(response)) {
            throw new GeneralSecurityException("SVS ERROR");
        }
        String errorCode = XmlUtil.getNodeText((String)response, (String)"ErrorCode");
        if (!"0".equals(errorCode)) {
            String errorMsg = XmlUtil.getNodeText((String)response, (String)"ErrorDesc");
            throw new GeneralSecurityException(errorCode + ":" + errorMsg);
        }
        binarySignValue = Base64.decode((String)XmlUtil.getNodeText((String)response, (String)"SignatureBase64"));
        return binarySignValue;
    }

    @Override
    public SignResultInfo p1Sign(SignInfoConfig signInfo, byte[] hash) throws PKIException {
        SignResultInfo signResult = new SignResultInfo();
        Mechanism mechanism = signInfo.getSignAlg();
        try {
            byte[] binarySignValue = this.p1HashSign(mechanism, this.serviceId, hash);
            signResult.setSignData(binarySignValue);
            signResult.setSignResult(true);
        }
        catch (Exception e) {
            businessLog.error("SVSSigner.p1Sign() failed", (Throwable)e);
            signResult.setSignResult(false);
            signResult.setFailReason(e.getMessage());
        }
        return signResult;
    }
}

