/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.ASN1TaggedObject;
import cfca.sadk.org.bouncycastle.asn1.BERSequenceGenerator;
import cfca.sadk.org.bouncycastle.asn1.BERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.cms.SignerInfo;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSSignedGenerator;
import cfca.sadk.org.bouncycastle.cms.CMSSignedHelper;
import cfca.sadk.org.bouncycastle.cms.CMSStreamException;
import cfca.sadk.org.bouncycastle.cms.CMSUtils;
import cfca.sadk.org.bouncycastle.cms.SignerInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.SignerInformation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public OutputStream open(OutputStream out) throws IOException {
        return this.open(out, false);
    }

    public OutputStream open(OutputStream out, boolean encapsulate) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate);
    }

    public OutputStream open(OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate, dataOutputStream);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate) throws IOException {
        return this.open(eContentType, out, encapsulate, null);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(this.calculateVersion(eContentType));
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
        }
        for (SignerInfoGenerator signerGen : this.signerGens) {
            digestAlgs.add(signerGen.getDigestAlgorithm());
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(eContentType);
        OutputStream encapStream = encapsulate ? CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream contentStream = CMSUtils.getSafeTeeOutputStream(dataOutputStream, encapStream);
        OutputStream sigStream = CMSUtils.attachSignersToOutputStream(this.signerGens, contentStream);
        return new CmsSignedDataOutputStream(sigStream, eContentType, sGen, sigGen, eiGen);
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier contentOid) {
        boolean otherCert = false;
        boolean otherCrl = false;
        boolean attrCertV1Found = false;
        boolean attrCertV2Found = false;
        if (this.certs != null) {
            for (Object obj : this.certs) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagged = (ASN1TaggedObject)obj;
                if (tagged.getTagNo() == 1) {
                    attrCertV1Found = true;
                    continue;
                }
                if (tagged.getTagNo() == 2) {
                    attrCertV2Found = true;
                    continue;
                }
                if (tagged.getTagNo() != 3) continue;
                otherCert = true;
            }
        }
        if (otherCert) {
            return new ASN1Integer(5L);
        }
        if (this.crls != null) {
            for (Object obj : this.crls) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                otherCrl = true;
            }
        }
        if (otherCrl) {
            return new ASN1Integer(5L);
        }
        if (attrCertV2Found) {
            return new ASN1Integer(4L);
        }
        if (attrCertV1Found) {
            return new ASN1Integer(3L);
        }
        if (this.checkForVersion3(this._signers, this.signerGens)) {
            return new ASN1Integer(3L);
        }
        if (!CMSObjectIdentifiers.data.equals(contentOid)) {
            return new ASN1Integer(3L);
        }
        return new ASN1Integer(1L);
    }

    private boolean checkForVersion3(List signerInfos, List signerInfoGens) {
        Iterator it = signerInfos.iterator();
        while (it.hasNext()) {
            Object s = SignerInfo.getInstance(((SignerInformation)it.next()).toASN1Structure());
            if (((SignerInfo)s).getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        for (Object s : signerInfoGens) {
            if (((SignerInfoGenerator)s).getGeneratedVersion() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream out, ASN1ObjectIdentifier contentOID, BERSequenceGenerator sGen, BERSequenceGenerator sigGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._contentOID = contentOID;
            this._sGen = sGen;
            this._sigGen = sigGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                ASN1Set certSet = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, certSet).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                ASN1Set crlSet = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, crlSet).getEncoded());
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            for (SignerInfoGenerator sigGen : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    signerInfos.add(sigGen.generate(this._contentOID));
                    byte[] calculatedDigest = sigGen.getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(sigGen.getDigestAlgorithm().getAlgorithm().getId(), calculatedDigest);
                }
                catch (CMSException e) {
                    throw new CMSStreamException("exception generating signers: " + e.getMessage(), e);
                }
            }
            for (SignerInformation signer : CMSSignedDataStreamGenerator.this._signers) {
                signerInfos.add(signer.toASN1Structure());
            }
            this._sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }
}

