/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class TLSCredentials {
    public final PrivateKey privateKey;
    public final PublicKey publicKey;
    public final X509Certificate[] certificates;
    public final Set<X500Principal> issuerX500Principals;
    static final X509Certificate[] NOCERTS = new X509Certificate[0];

    public TLSCredentials(List<X509Certificate> certificates) {
        this(null, certificates.toArray(new X509Certificate[0]));
    }

    public TLSCredentials(X509Certificate[] certificates) {
        this(null, certificates);
    }

    public TLSCredentials(PrivateKey privateKey, X509Certificate[] certificates) {
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.issuerX500Principals = new HashSet<X500Principal>();
        if (certificates != null && certificates.length > 0) {
            this.publicKey = certificates[0].getPublicKey();
            for (int i = 0; i < certificates.length; ++i) {
                this.issuerX500Principals.add(certificates[i].getIssuerX500Principal());
            }
        } else {
            this.publicKey = null;
        }
    }

    public final Principal getPrincipal() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[0].getSubjectX500Principal();
    }

    public final byte[] getEncoded() throws CertificateEncodingException {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[0].getEncoded();
    }

    public final String getSigAlgName() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[0].getSigAlgName();
    }

    public final boolean hasCertificates() {
        return this.certificates != null && this.certificates.length > 0;
    }

    public final X509Certificate getCertificate() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[0];
    }

    public static TLSCredentials[] buildDoubleCredentials(X509Certificate[] peers) {
        if (peers == null || peers.length == 0) {
            throw new IllegalArgumentException("null or zero peer certificates");
        }
        TLSCredentials[] credentials = new TLSCredentials[2];
        int i = 0;
        X509Certificate[] signers = new X509Certificate[peers.length];
        int index = 0;
        signers[index++] = peers[i++];
        while (i < peers.length && peers[i].getSubjectDN().equals(peers[i - 1].getIssuerDN())) {
            signers[index++] = peers[i];
            ++i;
        }
        X509Certificate[] certs = new X509Certificate[index];
        System.arraycopy(signers, 0, certs, 0, certs.length);
        credentials[0] = new TLSCredentials(null, certs);
        int j = i;
        if (j < peers.length) {
            X509Certificate[] ciphers = new X509Certificate[peers.length];
            int index2 = 0;
            ciphers[index2++] = peers[j++];
            while (j < peers.length && peers[j].getSubjectDN().equals(peers[j - 1].getIssuerDN())) {
                ciphers[index2++] = peers[j];
                ++j;
            }
            X509Certificate[] certs2 = new X509Certificate[index2];
            System.arraycopy(ciphers, 0, certs2, 0, certs2.length);
            credentials[1] = new TLSCredentials(null, certs2);
        }
        return credentials;
    }

    public static final X509Certificate[] concat(X509Certificate[] signers, X509Certificate[] ciphers) {
        X509Certificate[] certs = null;
        if (signers != null && ciphers != null) {
            certs = new X509Certificate[signers.length + ciphers.length];
            int index = 0;
            System.arraycopy(signers, 0, certs, index, signers.length);
            System.arraycopy(ciphers, 0, certs, index += signers.length, ciphers.length);
        } else {
            certs = signers != null ? (X509Certificate[])signers.clone() : (ciphers != null ? (X509Certificate[])ciphers.clone() : NOCERTS);
        }
        return certs;
    }
}

