/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.opentype.CoverageTable;
import cfca.com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import cfca.com.google.typography.font.sfntly.table.opentype.singlesubst.HeaderFmt1;
import cfca.com.google.typography.font.sfntly.table.opentype.singlesubst.InnerArrayFmt2;

public class SingleSubst
extends SubstSubtable {
    private final HeaderFmt1 fmt1;
    private final InnerArrayFmt2 fmt2;

    SingleSubst(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        switch (this.format) {
            case 1: {
                this.fmt1 = new HeaderFmt1(data, this.headerSize(), dataIsCanonical);
                this.fmt2 = null;
                break;
            }
            case 2: {
                this.fmt1 = null;
                this.fmt2 = new InnerArrayFmt2(data, this.headerSize(), dataIsCanonical);
                break;
            }
            default: {
                throw new IllegalStateException("Subt format value is " + this.format + " (should be 1 or 2).");
            }
        }
    }

    public CoverageTable coverage() {
        switch (this.format) {
            case 1: {
                return this.fmt1.coverage;
            }
            case 2: {
                return this.fmt2.coverage;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public HeaderFmt1 fmt1Table() {
        if (this.format == 1) {
            return this.fmt1;
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public InnerArrayFmt2 fmt2Table() {
        if (this.format == 2) {
            return this.fmt2;
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public static class Builder
    extends SubstSubtable.Builder<SubstSubtable> {
        private final HeaderFmt1.Builder fmt1Builder;
        private final InnerArrayFmt2.Builder fmt2Builder;

        protected Builder() {
            this.fmt1Builder = new HeaderFmt1.Builder();
            this.fmt2Builder = new InnerArrayFmt2.Builder();
        }

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data, dataIsCanonical);
            this.fmt1Builder = new HeaderFmt1.Builder(data, dataIsCanonical);
            this.fmt2Builder = new InnerArrayFmt2.Builder(data, dataIsCanonical);
        }

        protected Builder(SubstSubtable subTable) {
            SingleSubst ligSubst = (SingleSubst)subTable;
            this.fmt1Builder = new HeaderFmt1.Builder(ligSubst.fmt1);
            this.fmt2Builder = new InnerArrayFmt2.Builder(ligSubst.fmt2);
        }

        @Override
        public int subDataSizeToSerialize() {
            return this.fmt1Builder.subDataSizeToSerialize() + this.fmt2Builder.subDataSizeToSerialize();
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            int byteCount = this.fmt1Builder.subSerialize(newData);
            byteCount += this.fmt2Builder.subSerialize(newData.slice(byteCount));
            return byteCount;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.fmt1Builder.subDataSet();
            this.fmt2Builder.subDataSet();
        }

        @Override
        public SingleSubst subBuildTable(ReadableFontData data) {
            return new SingleSubst(data, 0, true);
        }
    }
}

