/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.bean.appearance.GraphicAppearance;
import cfca.sadk.ofd.base.bean.appearance.TextAppearance;
import cfca.sadk.ofd.base.common.ImageUtil;
import cfca.sadk.ofd.base.common.ParamCheckUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.font.FontUtil;
import cfca.sadk.ofd.base.ofd.OFDConstants;
import cfca.sadk.ofd.base.ofd.Rectangle;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import cfca.sadk.ofd.base.seal.cross.SplittedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dom4j.Element;

public class ContentUtil {
    private static Logger businessLog = LoggerFactory.getLogger(ContentUtil.class);

    public static byte[] addImageToOFD(byte[] ofdData, byte[] imageData, List<GraphicAppearance> appearanceList) throws Exception {
        if (null == ofdData) {
            throw new IllegalArgumentException("OFDData is null!");
        }
        return ContentUtil.addImageToOFD(new ByteArrayInputStream(ofdData), imageData, appearanceList);
    }

    public static byte[] addImageToOFD(InputStream inputStream, byte[] imageData, List<GraphicAppearance> appearanceList) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("addImageToOFD start...");
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream is null!");
        }
        if (null == imageData) {
            throw new IllegalArgumentException("imageData is null!");
        }
        try {
            Map<String, byte[]> filesMap = ZipUtil.uncompress(inputStream);
            byte[] byArray = ContentUtil.addImageToOFD(filesMap, imageData, appearanceList, null);
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("addImageToOFD failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addImageToOFD failed", (Throwable)e);
            throw new SealException(e.getMessage(), e);
        }
        finally {
            inputStream.close();
            long end = System.currentTimeMillis();
            businessLog.info("addImageToOFD end...cost= " + (end - start) + " ms");
        }
    }

    public static byte[] addImageToOFD(Map<String, byte[]> filesMap, byte[] imageData, List<GraphicAppearance> appearanceList, String templatePath) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("addImageToOFD start...");
        if (null == imageData) {
            throw new IllegalArgumentException("imageData is null!");
        }
        try {
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            Element root = SealXMLUtil.getDocument(filesMap, baseDir);
            String imageType = ImageUtil.getImageType(imageData);
            String imageFileName = UUID.randomUUID().toString() + "." + imageType;
            String imageFilePath = baseDir + "Res/" + imageFileName;
            filesMap.put(imageFilePath, imageData);
            byte[] docResData = filesMap.get(baseDir + "PublicRes.xml");
            BigInteger maxID = SealXMLUtil.getMaxDataId(root, baseDir);
            if (null == docResData) {
                throw new SealException("PublicRes.xml is not found!");
            }
            SealXMLUtil.updateDocumentRes(filesMap, baseDir + "PublicRes.xml", imageFileName, maxID);
            BigInteger newMaxID = maxID;
            for (int i = 0; i < appearanceList.size(); ++i) {
                GraphicAppearance appearance = appearanceList.get(i);
                int pageNum = appearance.getPageNum();
                newMaxID = maxID.add(new BigInteger(String.valueOf(i * 3)));
                String fileName = baseDir + "Pages/Page_" + (pageNum - 1) + "/" + "Content.xml";
                if (templatePath != null) {
                    fileName = templatePath;
                }
                SealXMLUtil.addImageObject(filesMap, fileName, maxID, newMaxID, appearance);
            }
            SealXMLUtil.updateMaxDataId(root, baseDir, newMaxID);
            ByteArrayOutputStream newOFDStream = ZipUtil.compress(filesMap);
            byte[] byArray = newOFDStream.toByteArray();
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("addImageToOFD failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addImageToOFD failed", (Throwable)e);
            throw new SealException(e.getMessage(), e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("addImageToOFD end...cost= " + (end - start) + " ms");
        }
    }

    public static byte[] addTextToOFD(byte[] ofdData, List<TextAppearance> appearanceList) throws Exception {
        return ContentUtil.addTextToOFD(ofdData, appearanceList, false, null);
    }

    public static byte[] addTextToOFD(byte[] ofdData, List<TextAppearance> appearanceList, boolean sameText, String templatePath) throws Exception {
        if (null == ofdData) {
            throw new IllegalArgumentException("OFDData is null!");
        }
        return ContentUtil.addTextToOFD(new ByteArrayInputStream(ofdData), appearanceList, sameText, templatePath);
    }

    public static byte[] addTextToOFD(InputStream inputStream, List<TextAppearance> appearanceList) throws Exception {
        return ContentUtil.addTextToOFD(inputStream, appearanceList, false, null);
    }

    public static byte[] addTextToOFD(InputStream inputStream, List<TextAppearance> appearanceList, boolean sameText, String templatePath) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("addTextToOFD start...");
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream is null!");
        }
        try {
            Map<String, byte[]> filesMap = ZipUtil.uncompress(inputStream);
            byte[] byArray = ContentUtil.addTextToOFD(filesMap, appearanceList, sameText, templatePath);
            return byArray;
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SealException(e.getMessage(), e);
        }
        finally {
            inputStream.close();
            long end = System.currentTimeMillis();
            businessLog.info("addImageToOFD end...cost= " + (end - start) + " ms");
        }
    }

    public static byte[] addTextToOFD(Map<String, byte[]> filesMap, List<TextAppearance> appearanceList, boolean sameText, String templatePath) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("addTextToOFD start...");
        try {
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            Element root = SealXMLUtil.getDocument(filesMap, baseDir);
            byte[] docResData = filesMap.get(baseDir + "PublicRes.xml");
            BigInteger maxID = SealXMLUtil.getMaxDataId(root, baseDir);
            if (null == docResData) {
                throw new SealException("PublicRes.xml is not found!");
            }
            int pages = SealXMLUtil.getTotalPages(filesMap);
            BigInteger newMaxID = maxID;
            boolean isCreateFont = true;
            BigInteger fontID = new BigInteger("0");
            List<String> glyphs = null;
            for (int i = 0; i < appearanceList.size(); ++i) {
                maxID = maxID.add(OFDConstants.interval);
                TextAppearance appearance = appearanceList.get(i);
                String content = appearance.getContent();
                if (StringUtil.isEmpty(content)) {
                    throw new IllegalArgumentException("content is null");
                }
                String subFontName = "font_" + UUID.randomUUID().toString() + ".ttf";
                float fontSize = appearance.getFontSize();
                if (fontSize <= 0.0f) {
                    throw new IllegalArgumentException("fontSize is " + fontSize);
                }
                if (isCreateFont) {
                    String fontName = appearance.getFontName();
                    if (null == fontName) {
                        throw new IllegalArgumentException("fontName is null!");
                    }
                    SealXMLUtil.updateDocumentResFont(filesMap, baseDir + "PublicRes.xml", subFontName, fontName, maxID);
                    if (sameText) {
                        isCreateFont = false;
                    }
                    fontID = maxID;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    glyphs = FontUtil.getInstance().getSubSetFont(appearance.getFontName(), content, output);
                    byte[] fontFileData = output.toByteArray();
                    String ttfFilePath = baseDir + "Res/" + subFontName;
                    filesMap.put(ttfFilePath, fontFileData);
                }
                int wordCount = glyphs.size();
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < wordCount; ++j) {
                    String glyphid = (String)glyphs.get(j);
                    if (j != wordCount - 1) {
                        sb.append(glyphid + " ");
                        continue;
                    }
                    sb.append(glyphid);
                }
                appearance.setGlyphs(sb.toString());
                appearance.setFontID(fontID.toString());
                appearance.setFontFileWordCount(wordCount);
                Rectangle boundary = appearance.getBoundary();
                boundary.setWidth(fontSize * (float)wordCount);
                boundary.setHeight(fontSize);
                appearance.setStartY(String.valueOf((double)fontSize - (double)(fontSize / 5.0f) * 0.7));
                int pageNum = appearance.getPageNum();
                if (pageNum < 1 || pageNum > pages) {
                    throw new IllegalArgumentException("pageNum is wrong,pageNum = " + pageNum);
                }
                newMaxID = maxID.add(new BigInteger(String.valueOf((i + 1) * 3)));
                String fileName = baseDir + "Pages/Page_" + (pageNum - 1) + "/" + "Content.xml";
                if (templatePath != null) {
                    fileName = templatePath;
                }
                SealXMLUtil.addTextObject(filesMap, fileName, maxID, newMaxID, appearance);
            }
            SealXMLUtil.updateMaxDataId(root, baseDir, newMaxID);
            ByteArrayOutputStream newOFDStream = ZipUtil.compress(filesMap);
            byte[] byArray = newOFDStream.toByteArray();
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("addImageToOFD failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addImageToOFD failed", (Throwable)e);
            throw new SealException(e.getMessage(), e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("addImageToOFD end...cost= " + (end - start) + " ms");
        }
    }

    public static byte[] addCrossImageToOFD(byte[] ofdData, byte[] imageData, int alpha, int startPageNo, int endPageNo, int crosspageStyle, int pageRangeOption) throws Exception {
        if (null == ofdData) {
            throw new IllegalArgumentException("OFDData is null!");
        }
        return ContentUtil.addCrossImageToOFD(new ByteArrayInputStream(ofdData), imageData, alpha, startPageNo, endPageNo, crosspageStyle, pageRangeOption);
    }

    public static byte[] addCrossImageToOFD(InputStream inputStream, byte[] imageData, int alpha, int startPageNo, int endPageNo, int crosspageStyle, int pageRangeOption) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("addCrossImageToOFD start...");
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream is null!");
        }
        if (null == imageData) {
            throw new IllegalArgumentException("imageData is null!");
        }
        try {
            Map<String, byte[]> filesMap = ZipUtil.uncompress(inputStream);
            int totalPages = SealXMLUtil.getTotalPages(filesMap);
            if (endPageNo == -1) {
                endPageNo = totalPages;
            }
            if (startPageNo >= endPageNo) {
                throw new IllegalArgumentException("startPageNo cannot be larger than endPageNo!");
            }
            ParamCheckUtil.checkPageNum(startPageNo, totalPages);
            ParamCheckUtil.checkPageNum(endPageNo, totalPages);
            ArrayList<SplittedImage> subs = ImageUtil.splitImage(imageData, startPageNo, endPageNo, crosspageStyle, pageRangeOption);
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            Element root = SealXMLUtil.getDocument(filesMap, baseDir);
            String imageType = ImageUtil.getImageType(imageData);
            BigInteger maxID = SealXMLUtil.getMaxDataId(root, baseDir);
            BigInteger imageID = maxID.add(new BigInteger(String.valueOf(subs.size() * 3)));
            for (int i = 0; i < subs.size(); ++i) {
                SplittedImage subImage = subs.get(i);
                String imageFileName = UUID.randomUUID().toString() + "." + imageType;
                String imageFilePath = baseDir + "Res/" + imageFileName;
                filesMap.put(imageFilePath, subImage.getImageBytes());
                byte[] docResData = filesMap.get(baseDir + "PublicRes.xml");
                if (null == docResData) {
                    throw new SealException(baseDir + "PublicRes.xml" + " is not found!");
                }
                SealXMLUtil.updateDocumentRes(filesMap, baseDir + "PublicRes.xml", imageFileName, imageID);
                int pageNum = subImage.getPageNo();
                float tmpAbsoluteX = 0.0f;
                float tmpAbsoluteY = 0.0f;
                Rectangle pageSize = SealXMLUtil.getPageSize(filesMap, pageNum, baseDir);
                float pageWidth = pageSize.getWidth();
                float pageHeight = pageSize.getHeight();
                Rectangle imageRect = subImage.getImageRect();
                float fitWidth = imageRect.getWidth();
                if (crosspageStyle == 2) {
                    tmpAbsoluteX = pageWidth - fitWidth;
                    tmpAbsoluteY = pageHeight / 2.0f - imageRect.getHeight() / 2.0f;
                } else if (crosspageStyle == 1) {
                    tmpAbsoluteX = 0.0f;
                    tmpAbsoluteY = pageHeight / 2.0f - imageRect.getHeight() / 2.0f;
                } else if (crosspageStyle == 3) {
                    tmpAbsoluteX = pageWidth / 2.0f - imageRect.getWidth() / 2.0f;
                    tmpAbsoluteY = 0.0f;
                } else if (crosspageStyle == 4) {
                    tmpAbsoluteX = pageWidth / 2.0f - imageRect.getWidth() / 2.0f;
                    tmpAbsoluteY = pageHeight - imageRect.getHeight();
                }
                imageRect.setX(tmpAbsoluteX);
                imageRect.setY(tmpAbsoluteY);
                BigInteger newMaxID = maxID.add(new BigInteger(String.valueOf(i * 3)));
                GraphicAppearance appearance = new GraphicAppearance(pageNum, imageRect, alpha);
                SealXMLUtil.addImageObject(filesMap, baseDir + "Pages/Page_" + (pageNum - 1) + "/" + "Content.xml", imageID, newMaxID, appearance);
                imageID = imageID.add(OFDConstants.interval);
            }
            SealXMLUtil.updateMaxDataId(root, baseDir, imageID);
            ByteArrayOutputStream newOFDStream = ZipUtil.compress(filesMap);
            byte[] byArray = newOFDStream.toByteArray();
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("addCrossImageToOFD failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addCrossImageToOFD failed", (Throwable)e);
            throw new SealException(e.getMessage(), e);
        }
        finally {
            inputStream.close();
            long end = System.currentTimeMillis();
            businessLog.info("addCrossImageToOFD end...cost= " + (end - start) + " ms");
        }
    }

    static {
        VersionInfo.environments();
    }
}

