/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.collection;

import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfBoolean;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDate;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;

public class PdfCollectionField
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 4766153544105870238L;
    public static final int TEXT = 0;
    public static final int DATE = 1;
    public static final int NUMBER = 2;
    public static final int FILENAME = 3;
    public static final int DESC = 4;
    public static final int MODDATE = 5;
    public static final int CREATIONDATE = 6;
    public static final int SIZE = 7;
    protected int subType;

    protected PdfCollectionField(PdfDictionary pdfObject) {
        super(pdfObject);
        String subType = pdfObject.getAsName(PdfName.Subtype).getValue();
        this.subType = "D".equals(subType) ? 1 : ("N".equals(subType) ? 2 : ("F".equals(subType) ? 3 : ("Desc".equals(subType) ? 4 : ("ModDate".equals(subType) ? 5 : ("CreationDate".equals(subType) ? 6 : ("Size".equals(subType) ? 7 : 0))))));
    }

    public PdfCollectionField(String name, int subType) {
        super(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.N, new PdfString(name));
        this.subType = subType;
        switch (subType) {
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.S);
                break;
            }
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.D);
                break;
            }
            case 2: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.N);
                break;
            }
            case 3: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.F);
                break;
            }
            case 4: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Desc);
                break;
            }
            case 5: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.ModDate);
                break;
            }
            case 6: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.CreationDate);
                break;
            }
            case 7: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Size);
            }
        }
    }

    public PdfCollectionField setOrder(int order) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.O, new PdfNumber(order));
        return this;
    }

    public PdfNumber getOrder() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.O);
    }

    public PdfCollectionField setVisibility(boolean visible) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, PdfBoolean.valueOf(visible));
        return this;
    }

    public PdfBoolean getVisibility() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.V);
    }

    public PdfCollectionField setEditable(boolean editable) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.E, PdfBoolean.valueOf(editable));
        return this;
    }

    public PdfBoolean getEditable() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.E);
    }

    public PdfObject getValue(String value) {
        switch (this.subType) {
            case 0: {
                return new PdfString(value);
            }
            case 1: {
                return new PdfDate(PdfDate.decode(value)).getPdfObject();
            }
            case 2: {
                return new PdfNumber(Double.parseDouble(value.trim()));
            }
        }
        throw new PdfException("{0} is not an acceptable value for the field {1}.").setMessageParams(value, ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.N).getValue());
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

