/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.refit;

import cfca.com.itextpdf.text.pdf.DocumentFont;
import cfca.com.itextpdf.text.pdf.parser.ImageRenderInfo;
import cfca.com.itextpdf.text.pdf.parser.LineSegment;
import cfca.com.itextpdf.text.pdf.parser.Matrix;
import cfca.com.itextpdf.text.pdf.parser.TextRenderInfo;
import cfca.com.itextpdf.text.pdf.parser.Vector;
import cfca.seal.sadk.refit.RefitLocationInfo;
import cfca.seal.sadk.refit.TextRefitStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationTextRefitStrategy
implements TextRefitStrategy {
    private String refitWord;
    private int rotation;
    private int page;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    static boolean DUMP_STATE = false;

    public LocationTextRefitStrategy(String refitWord, int page, int rotation) {
        this.refitWord = refitWord;
        this.page = page;
        this.rotation = rotation;
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
            System.out.println();
        }
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        LineSegment ascendLine;
        LineSegment segment = renderInfo.getBaseline();
        if (renderInfo.getRise() != 0.0f) {
            Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
            segment = segment.transformBy(riseOffsetTransform);
        }
        float bi2 = 0.0f;
        float ai2 = 0.0f;
        float di2 = 0.0f;
        if (this.rotation == 0) {
            bi2 = segment.getStartPoint().get(1);
            ascendLine = renderInfo.getAscentLine();
            ai2 = ascendLine.getStartPoint().get(1);
            LineSegment descendLine = renderInfo.getDescentLine();
            di2 = descendLine.getStartPoint().get(1);
        } else if (this.rotation == 90) {
            bi2 = segment.getStartPoint().get(0);
            ascendLine = renderInfo.getAscentLine();
            ai2 = ascendLine.getStartPoint().get(0);
            LineSegment descendLine = renderInfo.getDescentLine();
            di2 = descendLine.getStartPoint().get(0);
        }
        TextChunk location = new TextChunk(renderInfo.getText(), segment.getStartPoint(), segment.getEndPoint(), renderInfo.getSingleSpaceWidth(), bi2, ai2, di2, renderInfo.getFont(), ai2 - di2);
        this.locationalResult.add(location);
    }

    @Override
    public void endTextBlock() {
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
    }

    @Override
    public RefitLocationInfo getResultantRefitWord() {
        return this.getResultantRefitWord(null);
    }

    private List<TextChunk> filterTextChunks(List<TextChunk> textChunks, TextChunkFilter filter) {
        if (filter == null) {
            return textChunks;
        }
        ArrayList<TextChunk> filtered = new ArrayList<TextChunk>();
        for (TextChunk textChunk : textChunks) {
            if (!filter.accept(textChunk)) continue;
            filtered.add(textChunk);
        }
        return filtered;
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        float dist = chunk.distanceFromEndOf(previousChunk);
        return dist < -chunk.getCharSpaceWidth() || dist > chunk.getCharSpaceWidth() / 2.0f;
    }

    private boolean startsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == ' ';
    }

    public RefitLocationInfo getResultantRefitWord(TextChunkFilter chunkFilter) {
        if (DUMP_STATE) {
            this.dumpState();
        }
        List<TextChunk> filteredTextChunks = this.filterTextChunks(this.locationalResult, chunkFilter);
        Collections.sort(filteredTextChunks);
        StringBuilder forwardStringBuilder = new StringBuilder();
        StringBuilder backwardStringBuilder = new StringBuilder();
        TextChunk lastChunk = null;
        RefitLocationInfo locInfo = new RefitLocationInfo();
        int index = -1;
        ArrayList<TextChunk> forwardChunkList = new ArrayList<TextChunk>();
        ArrayList<TextChunk> backwardChunkList = new ArrayList<TextChunk>();
        for (TextChunk chunk : filteredTextChunks) {
            if (lastChunk == null) {
                forwardChunkList.add(chunk);
                forwardStringBuilder.append(chunk.text);
                index = forwardStringBuilder.indexOf(this.refitWord);
                if (index > -1) {
                    this.prepareRefitWordLocInfo(locInfo, forwardChunkList, chunk);
                    forwardChunkList.clear();
                    forwardStringBuilder.setLength(0);
                }
            } else if (chunk.sameLine(lastChunk)) {
                forwardChunkList.add(chunk);
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.text) && !this.endsWithSpace(lastChunk.text)) {
                    forwardStringBuilder.append(' ');
                }
                forwardStringBuilder.append(chunk.text);
                index = forwardStringBuilder.indexOf(this.refitWord);
                if (index > -1) {
                    int fsize = forwardChunkList.size();
                    TextChunk lastBackwardChunk = null;
                    TextChunk backwardChunk = null;
                    for (int i = fsize - 1; i >= 0; --i) {
                        backwardChunk = forwardChunkList.get(i);
                        String backwardString = backwardChunk.text;
                        if (lastBackwardChunk == null) {
                            backwardChunkList.add(0, backwardChunk);
                            backwardStringBuilder.insert(0, backwardString);
                            index = backwardStringBuilder.indexOf(this.refitWord);
                            if (index > -1) {
                                this.prepareRefitWordLocInfo(locInfo, backwardChunkList, backwardChunk);
                                backwardChunkList.clear();
                                backwardStringBuilder.setLength(0);
                                forwardChunkList.clear();
                                forwardStringBuilder.setLength(0);
                                break;
                            }
                        } else {
                            if (this.isChunkAtWordBoundary(lastBackwardChunk, backwardChunk) && !this.startsWithSpace(lastBackwardChunk.text) && !this.endsWithSpace(backwardChunk.text)) {
                                backwardStringBuilder.insert(0, ' ');
                            }
                            backwardChunkList.add(0, backwardChunk);
                            backwardString = backwardChunk.text;
                            backwardStringBuilder.insert(0, backwardString);
                            index = backwardStringBuilder.indexOf(this.refitWord);
                            if (index > -1) {
                                this.prepareRefitWordLocInfo(locInfo, backwardChunkList, backwardChunk);
                                forwardChunkList.clear();
                                forwardStringBuilder.setLength(0);
                                backwardChunkList.clear();
                                backwardStringBuilder.setLength(0);
                                break;
                            }
                        }
                        lastBackwardChunk = backwardChunk;
                    }
                }
            } else {
                if (index <= -1) {
                    forwardChunkList.clear();
                    forwardStringBuilder.setLength(0);
                }
                forwardChunkList.add(chunk);
                forwardStringBuilder.append(chunk.text);
                index = forwardStringBuilder.indexOf(this.refitWord);
                if (index > -1) {
                    this.prepareRefitWordLocInfo(locInfo, forwardChunkList, chunk);
                    forwardChunkList.clear();
                    forwardStringBuilder.setLength(0);
                }
            }
            lastChunk = chunk;
        }
        return locInfo;
    }

    private void prepareRefitWordLocInfo(RefitLocationInfo locInfo, ArrayList<TextChunk> textChunkList, TextChunk textChunk) {
        int[] indexes = this.prepareRefitWordIndexes(textChunk.text);
        float[] positions = this.prepareRefitWordPositions(textChunkList, indexes);
        RefitLocationInfo tmpLocInfo = this.prepareRefitWordLocation(textChunkList, positions);
        locInfo.addRefitLocationInfo(tmpLocInfo);
    }

    private RefitLocationInfo prepareRefitWordLocation(ArrayList<TextChunk> textChunkList, float[] positions) {
        RefitLocationInfo refitLocInfo = new RefitLocationInfo();
        int len = positions.length;
        int n = (len - 3) / 2;
        float baseline = positions[len - 3];
        float ascend = positions[len - 2];
        float descent = positions[len - 1];
        float height = ascend - descent;
        for (int i = 0; i < n; ++i) {
            float startPos = positions[i];
            float endPos = positions[i + 1];
            float x = startPos;
            float y = descent;
            float width = endPos - startPos;
            RefitLocationInfo.RefitFloat refitFloat = new RefitLocationInfo.RefitFloat(x, y, width, height, baseline, ascend, descent);
            refitLocInfo.add((Integer)this.page, refitFloat);
        }
        return refitLocInfo;
    }

    private int[] prepareRefitWordIndexes(String ContainingRefittingWordsString) {
        LinkedBlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>();
        int beginIndex = 0;
        int tmpIndex = -1;
        do {
            if ((tmpIndex = ContainingRefittingWordsString.indexOf(this.refitWord, beginIndex)) <= -1) continue;
            queue.add(tmpIndex++);
            beginIndex += tmpIndex;
        } while (tmpIndex > -1);
        int indexSize = queue.size();
        int[] refittingWordIndexes = new int[indexSize];
        Integer tmpKeywordIndex = null;
        int i = 0;
        while ((tmpKeywordIndex = (Integer)queue.poll()) != null) {
            refittingWordIndexes[i++] = tmpKeywordIndex;
        }
        return refittingWordIndexes;
    }

    private float[] prepareRefitWordPositions(ArrayList<TextChunk> chunkList, int[] indices) {
        int indiceslen = indices.length;
        int positionslen = indiceslen * 2 + 3;
        float[] positions = new float[positionslen];
        int size = chunkList.size();
        int refitWordLen = this.refitWord.length();
        if (size == 1) {
            float endXY;
            float startXY;
            TextChunk textChunk = chunkList.get(0);
            DocumentFont documentFont = textChunk.getDocumentFont();
            float fontSize = textChunk.getFontSize();
            String text = textChunk.text;
            Vector startLocation = textChunk.getStartLocation();
            Vector endLocation = textChunk.getEndLocation();
            if (this.rotation == 0) {
                startXY = startLocation.get(0);
                endXY = endLocation.get(0);
            } else {
                startXY = startLocation.get(1);
                endXY = endLocation.get(1);
            }
            float startPosition = startXY;
            float endPosition = 0.0f;
            int lastIndex = 0;
            for (int i = 0; i < indiceslen; ++i) {
                int curIndex = indices[i];
                for (int j = lastIndex; j < curIndex; ++j) {
                    startPosition += documentFont.getWidthPoint(text.charAt(j), fontSize);
                }
                positions[i] = startPosition;
                endPosition = startPosition;
                int endIndex = refitWordLen + curIndex;
                for (int j = curIndex; j < endIndex; ++j) {
                    endPosition += documentFont.getWidthPoint(text.charAt(j), fontSize);
                }
                positions[i + 1] = endPosition;
                if (indiceslen <= 1) continue;
                lastIndex = curIndex + refitWordLen;
                startPosition = endPosition;
            }
        } else {
            String tmpLastText;
            String tmpRefittingWord;
            float endXY;
            float startXY;
            TextChunk firstChunk = chunkList.get(0);
            Vector startLocation = firstChunk.getStartLocation();
            Vector endLocation = firstChunk.getEndLocation();
            String firstText = firstChunk.text;
            DocumentFont documentFont = firstChunk.getDocumentFont();
            float fontSize = firstChunk.getFontSize();
            if (this.rotation == 0) {
                startXY = startLocation.get(0);
                endXY = endLocation.get(0);
            } else {
                startXY = startLocation.get(1);
                endXY = endLocation.get(1);
            }
            int index = indices[0];
            float startPosition = startXY;
            float endPosition = 0.0f;
            for (int i = 0; i < index; ++i) {
                startPosition += documentFont.getWidthPoint(firstText.charAt(i), fontSize);
            }
            positions[0] = startPosition;
            TextChunk lastChunk = chunkList.get(size - 1);
            String lastText = lastChunk.text;
            startLocation = lastChunk.getStartLocation();
            endLocation = lastChunk.getEndLocation();
            documentFont = lastChunk.getDocumentFont();
            fontSize = lastChunk.getFontSize();
            if (this.rotation == 0) {
                startXY = startLocation.get(0);
                endXY = endLocation.get(0);
            } else {
                startXY = startLocation.get(1);
                endXY = endLocation.get(1);
            }
            int step = 0;
            while (!(tmpRefittingWord = this.refitWord.substring(refitWordLen - step - 1)).equals(tmpLastText = lastText.substring(0, step + 1))) {
                ++step;
            }
            int tmpIndex = ++step;
            endPosition = startXY;
            for (int i = 0; i < tmpIndex; ++i) {
                endPosition += documentFont.getWidthPoint(lastText.charAt(i), fontSize);
            }
            positions[1] = endPosition;
        }
        float ascend = chunkList.get(0).ascend;
        float descent = chunkList.get(0).descent;
        positions[positionslen - 3] = chunkList.get(0).baseline;
        positions[positionslen - 2] = ascend;
        positions[positionslen - 1] = descent;
        return positions;
    }

    public static interface TextChunkFilter {
        public boolean accept(TextChunk var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextChunk
    implements Comparable<TextChunk> {
        private final String text;
        private final Vector startLocation;
        private final Vector endLocation;
        private final Vector orientationVector;
        private final int orientationMagnitude;
        private final int distPerpendicular;
        private final float distParallelStart;
        private final float distParallelEnd;
        private final float charSpaceWidth;
        private float ascend;
        private float descent;
        private float baseline;
        private DocumentFont documentFont;
        private float fontSize;

        public TextChunk(String string, Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this.text = string;
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.charSpaceWidth = charSpaceWidth;
            Vector oVector = endLocation.subtract(startLocation);
            if (oVector.length() == 0.0f) {
                oVector = new Vector(1.0f, 0.0f, 0.0f);
            }
            this.orientationVector = oVector.normalize();
            this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallelStart = this.orientationVector.dot(startLocation);
            this.distParallelEnd = this.orientationVector.dot(endLocation);
        }

        public DocumentFont getDocumentFont() {
            return this.documentFont;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public TextChunk(String string, Vector startLocation, Vector endLocation, float charSpaceWidth, float baseline, float ascend, float descent, DocumentFont documentFont, float fontSize) {
            this(string, startLocation, endLocation, charSpaceWidth);
            this.baseline = baseline;
            this.ascend = ascend;
            this.descent = descent;
            this.documentFont = documentFont;
            this.fontSize = Math.abs(fontSize);
        }

        public Vector getStartLocation() {
            return this.startLocation;
        }

        public Vector getEndLocation() {
            return this.endLocation;
        }

        public String getText() {
            return this.text;
        }

        public float getCharSpaceWidth() {
            return this.charSpaceWidth;
        }

        private void printDiagnostics() {
            System.out.println("Text (@" + this.startLocation + " -> " + this.endLocation + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.orientationMagnitude);
            System.out.println("distPerpendicular: " + this.distPerpendicular);
            System.out.println("distParallel: " + this.distParallelStart);
        }

        public boolean sameLine(TextChunk as) {
            if (this.orientationMagnitude != as.orientationMagnitude) {
                return false;
            }
            return this.distPerpendicular == as.distPerpendicular;
        }

        public float distanceFromEndOf(TextChunk other) {
            float distance = this.distParallelStart - other.distParallelEnd;
            return distance;
        }

        @Override
        public int compareTo(TextChunk rhs) {
            if (this == rhs) {
                return 0;
            }
            int rslt = TextChunk.compareInts(this.orientationMagnitude, rhs.orientationMagnitude);
            if (rslt != 0) {
                return rslt;
            }
            rslt = TextChunk.compareInts(this.distPerpendicular, rhs.distPerpendicular);
            if (rslt != 0) {
                return rslt;
            }
            return Float.compare(this.distParallelStart, rhs.distParallelStart);
        }

        private static int compareInts(int int1, int int2) {
            return int1 == int2 ? 0 : (int1 < int2 ? -1 : 1);
        }
    }
}

