/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.ConnectionKeys;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.ssl.sec.MacAlg;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public final class MAC
extends Authenticator {
    public static final MAC NULL = new MAC();
    private static final byte[] nullMAC = new byte[0];
    private final MacAlg macAlg;
    private final Mac mac;

    MAC() {
        this.macAlg = MacAlg.NULL;
        this.mac = null;
    }

    MAC(MacAlg macAlg, ProtocolVersion protocolVersion, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        super(protocolVersion);
        String algorithm;
        this.macAlg = macAlg;
        if (macAlg == MacAlg.SM3) {
            algorithm = "HmacSM3";
        } else if (macAlg == MacAlg.SHA) {
            algorithm = "HmacSHA1";
        } else {
            throw new RuntimeException("Unknown Mac " + (Object)((Object)macAlg));
        }
        this.mac = JSSEJCE.getMac(algorithm);
        this.mac.init(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MAC newMac(MacAlg macAlg, ProtocolVersion protocolVersion, ConnectionKeys key) throws NoSuchAlgorithmException, InvalidKeyException {
        try {
            MAC mAC = new MAC(macAlg, protocolVersion, key.macSecret);
            return mAC;
        }
        finally {
            key.cleanMacKey();
        }
    }

    public int MAClen() {
        return this.macAlg.size;
    }

    public int hashBlockLen() {
        return this.macAlg.hashBlockSize;
    }

    public int minimalPaddingLen() {
        return this.macAlg.minimalPaddingSize;
    }

    public final byte[] compute(byte type, byte[] buf, int offset, int len, boolean isSimulated) {
        if (this.macAlg.size == 0) {
            return nullMAC;
        }
        if (!isSimulated) {
            byte[] additional = this.acquireAuthenticationBytes(type, len);
            this.mac.update(additional);
        }
        this.mac.update(buf, offset, len);
        return this.mac.doFinal();
    }

    public final byte[] compute(byte type, ByteBuffer bb, boolean isSimulated) {
        if (this.macAlg.size == 0) {
            return nullMAC;
        }
        if (!isSimulated) {
            byte[] additional = this.acquireAuthenticationBytes(type, bb.remaining());
            this.mac.update(additional);
        }
        this.mac.update(bb);
        return this.mac.doFinal();
    }
}

