/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.truetype;

import cfca.com.google.typography.font.sfntly.data.FontData;
import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.truetype.Glyph;
import java.util.LinkedList;
import java.util.List;

public final class CompositeGlyph
extends Glyph {
    public static final int FLAG_ARG_1_AND_2_ARE_WORDS = 1;
    public static final int FLAG_ARGS_ARE_XY_VALUES = 2;
    public static final int FLAG_ROUND_XY_TO_GRID = 4;
    public static final int FLAG_WE_HAVE_A_SCALE = 8;
    public static final int FLAG_RESERVED = 16;
    public static final int FLAG_MORE_COMPONENTS = 32;
    public static final int FLAG_WE_HAVE_AN_X_AND_Y_SCALE = 64;
    public static final int FLAG_WE_HAVE_A_TWO_BY_TWO = 128;
    public static final int FLAG_WE_HAVE_INSTRUCTIONS = 256;
    public static final int FLAG_USE_MY_METRICS = 512;
    public static final int FLAG_OVERLAP_COMPOUND = 1024;
    public static final int FLAG_SCALED_COMPONENT_OFFSET = 2048;
    public static final int FLAG_UNSCALED_COMPONENT_OFFSET = 4096;
    private final List<Integer> contourIndex = new LinkedList<Integer>();
    private int instructionsOffset;
    private int instructionSize;

    protected CompositeGlyph(ReadableFontData data, int offset, int length) {
        super(data, offset, length, Glyph.GlyphType.Composite);
        this.initialize();
    }

    protected CompositeGlyph(ReadableFontData data) {
        super(data, Glyph.GlyphType.Composite);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        if (this.initialized) {
            return;
        }
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            int index = 5 * FontData.DataSize.USHORT.size();
            int flags = 32;
            while ((flags & 0x20) == 32) {
                this.contourIndex.add(index);
                flags = this.data.readUShort(index);
                index += 2 * FontData.DataSize.USHORT.size();
                index = (flags & 1) == 1 ? (index += 2 * FontData.DataSize.SHORT.size()) : (index += 2 * FontData.DataSize.BYTE.size());
                if ((flags & 8) == 8) {
                    index += FontData.DataSize.F2DOT14.size();
                    continue;
                }
                if ((flags & 0x40) == 64) {
                    index += 2 * FontData.DataSize.F2DOT14.size();
                    continue;
                }
                if ((flags & 0x80) != 128) continue;
                index += 4 * FontData.DataSize.F2DOT14.size();
            }
            int nonPaddedDataLength = index;
            if ((flags & 0x100) == 256) {
                this.instructionSize = this.data.readUShort(index);
                this.instructionsOffset = index += FontData.DataSize.USHORT.size();
                nonPaddedDataLength = index + this.instructionSize * FontData.DataSize.BYTE.size();
            }
            this.setPadding(this.dataLength() - nonPaddedDataLength);
        }
    }

    public int flags(int contour) {
        return this.data.readUShort(this.contourIndex.get(contour));
    }

    public int numGlyphs() {
        return this.contourIndex.size();
    }

    public int glyphIndex(int contour) {
        return this.data.readUShort(FontData.DataSize.USHORT.size() + this.contourIndex.get(contour));
    }

    public int argument1(int contour) {
        int index = 2 * FontData.DataSize.USHORT.size() + this.contourIndex.get(contour);
        int flags = this.flags(contour);
        if ((flags & 1) == 1) {
            return this.data.readUShort(index);
        }
        return this.data.readByte(index);
    }

    public int argument2(int contour) {
        int index = 2 * FontData.DataSize.USHORT.size() + this.contourIndex.get(contour);
        int flags = this.flags(contour);
        if ((flags & 1) == 1) {
            return this.data.readUShort(index + FontData.DataSize.USHORT.size());
        }
        return this.data.readByte(index + FontData.DataSize.BYTE.size());
    }

    public int transformationSize(int contour) {
        int flags = this.flags(contour);
        if ((flags & 8) == 8) {
            return FontData.DataSize.F2DOT14.size();
        }
        if ((flags & 0x40) == 64) {
            return 2 * FontData.DataSize.F2DOT14.size();
        }
        if ((flags & 0x80) == 128) {
            return 4 * FontData.DataSize.F2DOT14.size();
        }
        return 0;
    }

    public byte[] transformation(int contour) {
        int flags = this.flags(contour);
        int index = this.contourIndex.get(contour) + 2 * FontData.DataSize.USHORT.size();
        index = (flags & 1) == 1 ? (index += 2 * FontData.DataSize.SHORT.size()) : (index += 2 * FontData.DataSize.BYTE.size());
        int tsize = this.transformationSize(contour);
        byte[] transformation = new byte[tsize];
        this.data.readBytes(index, transformation, 0, tsize);
        return transformation;
    }

    @Override
    public int instructionSize() {
        return this.instructionSize;
    }

    @Override
    public ReadableFontData instructions() {
        return this.data.slice(this.instructionsOffset, this.instructionSize());
    }

    @Override
    public String toString() {
        int contour;
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\ncontourOffset.length = ");
        sb.append(this.contourIndex.size());
        sb.append("\ninstructionSize = ");
        sb.append(this.instructionSize);
        sb.append("\n\tcontour index = [");
        for (contour = 0; contour < this.contourIndex.size(); ++contour) {
            if (contour != 0) {
                sb.append(", ");
            }
            sb.append(this.contourIndex.get(contour));
        }
        sb.append("]\n");
        for (contour = 0; contour < this.contourIndex.size(); ++contour) {
            sb.append("\t" + contour + " = [gid = " + this.glyphIndex(contour) + ", arg1 = " + this.argument1(contour) + ", arg2 = " + this.argument2(contour) + "]\n");
        }
        return sb.toString();
    }

    public static class CompositeGlyphBuilder
    extends Glyph.Builder<CompositeGlyph> {
        protected CompositeGlyphBuilder(WritableFontData data, int offset, int length) {
            super(data.slice(offset, length));
        }

        protected CompositeGlyphBuilder(ReadableFontData data, int offset, int length) {
            super(data.slice(offset, length));
        }

        @Override
        protected CompositeGlyph subBuildTable(ReadableFontData data) {
            return new CompositeGlyph(data);
        }
    }
}

