/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.tx.transaction;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.paperless.base.util.JsonUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.paperless.client.connector.HttpConnector;
import cfca.paperless.client.tx.transaction.AbstractTransaction;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.RequestDto;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.SealInfoBean;
import cfca.paperless.dto.request.requestbody.tx60.DownloadProofFileRequestBody;
import cfca.paperless.dto.request.requestbody.tx60.QueryProofInfoListRequestBody;
import cfca.paperless.dto.request.tx60.DownloadProofFileRequest;
import cfca.paperless.dto.request.tx60.GetSealInfoRequest;
import cfca.paperless.dto.request.tx60.QueryProofInfoListRequest;
import cfca.paperless.dto.response.responsebody.tx60.DownloadProofFileResponseBody;
import cfca.paperless.dto.response.tx60.DownloadProofFileResponse;
import cfca.paperless.dto.response.tx60.GetSealInfoResponse;
import cfca.paperless.dto.response.tx60.QueryProofInfoListResponse;
import java.util.ArrayList;
import java.util.List;

public class Tx60Transaction
extends AbstractTransaction {
    public static final Logger logger = LoggerFactory.getLogger(Tx60Transaction.class);

    public QueryProofInfoListResponse doTx6001(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx6001 start.");
        QueryProofInfoListRequest requestBean = (QueryProofInfoListRequest)requestDto;
        QueryProofInfoListRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx6001(requestBody);
        logger.info("Tx10Transaction.doTx6001 doCheckTx6001 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx6001 handleRequest finish.");
        QueryProofInfoListResponse responseBean = this.parseTx6001Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx6001 parseTx6001Result finish.");
        logger.info("Tx10Transaction.doTx6001 end.");
        return responseBean;
    }

    public DownloadProofFileResponse doTx6002(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx6002 start.");
        DownloadProofFileRequest requestBean = (DownloadProofFileRequest)requestDto;
        DownloadProofFileRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx6002(requestBody);
        logger.info("Tx10Transaction.doTx6002 doCheckTx6002 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx6002 handleRequest finish.");
        DownloadProofFileResponse responseBean = this.parseTx6002Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx6002 parseTx6002Result finish.");
        logger.info("Tx10Transaction.doTx6002 end.");
        return responseBean;
    }

    public GetSealInfoResponse doTx6003(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx6003 start.");
        GetSealInfoRequest requestBean = (GetSealInfoRequest)requestDto;
        SealInfoBean requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx6003(requestBody);
        logger.info("Tx10Transaction.doTx6003 doCheckTx6003 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx6003 handleRequest finish.");
        GetSealInfoResponse responseBean = this.parseTx6003Result(responseJSONString);
        logger.info("Tx10Transaction.doTx6003 parseTx6003Result finish.");
        logger.info("Tx10Transaction.doTx6003 end.");
        return responseBean;
    }

    private QueryProofInfoListResponse parseTx6001Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        QueryProofInfoListResponse responseBean = (QueryProofInfoListResponse)JsonUtil.json2Obj((String)responseJSONString, QueryProofInfoListResponse.class);
        return responseBean;
    }

    private DownloadProofFileResponse parseTx6002Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        DownloadProofFileResponse responseBean = (DownloadProofFileResponse)JsonUtil.json2Obj((String)responseJSONString, DownloadProofFileResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            DownloadProofFileResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] pdf = outputFileDataList.get(0);
                ValidityUtil.checkIsPdfFile((byte[])pdf);
                body.setPdf(pdf);
            }
        }
        return responseBean;
    }

    private GetSealInfoResponse parseTx6003Result(String responseJSONString) throws Exception {
        GetSealInfoResponse responseBean = (GetSealInfoResponse)JsonUtil.json2Obj((String)responseJSONString, GetSealInfoResponse.class);
        return responseBean;
    }
}

