/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.javax.net.ssl.CFCAX509ExtendedTrustManager;
import cfca.sadk.tls.sun.security.ssl.Alerts;
import cfca.sadk.tls.sun.security.ssl.CipherSuiteList;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.Handshaker;
import cfca.sadk.tls.sun.security.ssl.ProtocolList;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.RandomCookie;
import cfca.sadk.tls.sun.security.ssl.SSLContextImpl;
import cfca.sadk.tls.sun.security.ssl.SSLEngineImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSessionContextImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSessionImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSocketImpl;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.sun.security.ssl.extension.RenegotiationInfoExtension;
import cfca.sadk.tls.sun.security.ssl.extension.ServerNameExtension;
import cfca.sadk.tls.sun.security.ssl.extension.SignatureAlgorithmsExtension;
import cfca.sadk.tls.sun.security.ssl.extension.SupportedEllipticCurvesExtension;
import cfca.sadk.tls.sun.security.ssl.message.CertificateMsg;
import cfca.sadk.tls.sun.security.ssl.message.CertificateRequest;
import cfca.sadk.tls.sun.security.ssl.message.CertificateVerify;
import cfca.sadk.tls.sun.security.ssl.message.ClientHello;
import cfca.sadk.tls.sun.security.ssl.message.ClientKeyExchange;
import cfca.sadk.tls.sun.security.ssl.message.Finished;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.message.HelloRequest;
import cfca.sadk.tls.sun.security.ssl.message.ServerHello;
import cfca.sadk.tls.sun.security.ssl.message.ServerHelloDone;
import cfca.sadk.tls.sun.security.ssl.message.ServerKeyExchange;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.ECDHCrypt;
import cfca.sadk.tls.sun.security.ssl.sec.ECNamedCurve;
import cfca.sadk.tls.sun.security.ssl.sec.KeyExchangeAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.TLSCredentials;
import cfca.sadk.tls.util.Utilities;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

final class ServerHandshaker
extends Handshaker {
    private byte doClientAuth;
    private boolean needClientVerify = false;
    private ECDHCrypt ecdh;
    private ProtocolVersion clientRequestedVersion;
    private SupportedEllipticCurvesExtension supportedCurves;
    SignatureAndHashAlgorithm preferableSignatureAlgorithm;

    ServerHandshaker(SSLSocketImpl socket, SSLContextImpl context, ProtocolList enabledProtocols, byte clientAuth, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(socket, context, enabledProtocols, clientAuth != 0, false, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
        this.doClientAuth = clientAuth;
    }

    ServerHandshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, byte clientAuth, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(engine, context, enabledProtocols, clientAuth != 0, false, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
        this.doClientAuth = clientAuth;
    }

    @Override
    final void processMessage(byte type, int message_len) throws IOException {
        if (this.state >= type && this.state != 16 && type != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + this.state + ", type = " + type);
        }
        switch (type) {
            case 1: {
                ClientHello ch = new ClientHello(this.in, message_len);
                this.clientHello(ch);
                break;
            }
            case 11: {
                if (this.doClientAuth == 0) {
                    this.fatalSE((byte)10, "client sent unsolicited cert chain");
                }
                this.clientCertificate(new CertificateMsg(this.in));
                break;
            }
            case 15: {
                this.clientCertificateVerify(new CertificateVerify(this.beingProtocolVersion, this.handshakeHash, this.in, this.localSupportedSignAlgs));
                break;
            }
            case 16: {
                this.calculateWorkKeys(message_len);
                break;
            }
            case 20: {
                this.clientFinished(new Finished(this.beingProtocolVersion, this.in, this.cipherSuite));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + type);
            }
        }
        if (this.state < type) {
            this.state = type == 15 ? type + 2 : (int)type;
        }
    }

    private final void clientHello(ClientHello mesg) throws IOException {
        RenegotiationInfoExtension clientHelloRI;
        Debugger.debug(mesg);
        if (rejectClientInitiatedRenego && !this.isInitialHandshake && this.state != 0) {
            this.fatalSE((byte)40, "Client initiated renegotiation is not allowed");
        }
        ServerNameExtension clientHelloSNIExt = (ServerNameExtension)mesg.extensions.get(ExtensionType.EXT_SERVER_NAME);
        if (!this.sniMatchers.isEmpty() && clientHelloSNIExt != null && !clientHelloSNIExt.isMatched(this.sniMatchers)) {
            this.fatalSE((byte)112, "Unrecognized server name indication");
        }
        boolean renegotiationIndicated = false;
        CipherSuiteList cipherSuites = mesg.getCipherSuites();
        if (cipherSuites.contains(CipherSuite.C_SCSV)) {
            renegotiationIndicated = true;
            if (this.isInitialHandshake) {
                this.secureRenegotiation = true;
            } else if (this.secureRenegotiation) {
                this.fatalSE((byte)40, "The SCSV is present in a secure renegotiation");
            } else {
                this.fatalSE((byte)40, "The SCSV is present in a insecure renegotiation");
            }
        }
        if ((clientHelloRI = (RenegotiationInfoExtension)mesg.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO)) != null) {
            renegotiationIndicated = true;
            if (this.isInitialHandshake) {
                if (!clientHelloRI.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "The renegotiation_info is present in a insecure renegotiation");
                }
                if (!Utilities.equals(this.clientVerifyData, clientHelloRI.getData())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ClientHello renegotiation_info message");
                }
            }
        } else if (!this.isInitialHandshake && this.secureRenegotiation) {
            this.fatalSE((byte)40, "Inconsistent secure renegotiation indication");
        }
        if (!renegotiationIndicated || !this.secureRenegotiation) {
            if (this.isInitialHandshake) {
                if (!allowLegacyHelloMessages) {
                    this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
                }
                Debugger.handshaker.debug("Warning: No renegotiation indication in ClientHello, allow legacy ClientHello");
            } else {
                if (!allowUnsafeRenegotiation) {
                    this.warningSE((byte)100);
                    this.invalidated = true;
                    if (this.in.available() > 0) {
                        this.fatalSE((byte)10, "ClientHello followed by an unexpected  handshake message");
                    }
                    return;
                }
                Debugger.handshaker.debug("Warning: continue with insecure renegotiation");
            }
        }
        this.in.digestNow();
        this.writeServerHello(mesg, clientHelloSNIExt);
        this.out.flush();
        if (this.resumingSession) {
            this.calculateConnectionKeys(this.session.getMasterSecret());
            this.sendChangeCipherAndFinish(false);
            return;
        }
        this.writeCertificate();
        this.out.flush();
        this.writeServerKeyExchange();
        this.out.flush();
        this.writeCertificateRequest();
        this.out.flush();
        this.writeServerHelloDone();
        this.out.flush();
        Debugger.handshaker.debug("ServerHelloDone: Finished");
    }

    private final void writeServerHello(ClientHello mesg, ServerNameExtension clientHelloSNIExt) throws IOException {
        SSLSessionImpl previous;
        this.clientRequestedVersion = mesg.getClientVersion();
        ProtocolVersion selectedVersion = this.selectProtocolVersion(this.clientRequestedVersion);
        if (selectedVersion == null || selectedVersion.version == ProtocolVersion.SSL20Hello.version) {
            this.fatalSE((byte)40, "Client requested protocol " + this.clientRequestedVersion + " not enabled or not supported");
        }
        this.handshakeHash.protocolDetermined(selectedVersion);
        this.setBeingVersion(selectedVersion);
        this.clientRandom = mesg.getClientRandom();
        this.serverRandom = new RandomCookie(this.context.getSecureRandom());
        this.session = null;
        if (mesg.getSessionId().length() != 0 && (previous = ((SSLSessionContextImpl)this.context.engineGetServerSessionContext()).get(mesg.getSessionId().getId())) != null) {
            ProtocolVersion oldVersion;
            this.resumingSession = previous.isRejoinable();
            if (this.resumingSession && (oldVersion = previous.getProtocolVersion()) != this.beingProtocolVersion) {
                this.resumingSession = false;
            }
            if (this.resumingSession) {
                List<CFCASNIServerName> oldServerNames = previous.getRequestedServerNames();
                if (clientHelloSNIExt != null) {
                    if (!clientHelloSNIExt.isIdentical(oldServerNames)) {
                        this.resumingSession = false;
                    }
                } else if (!oldServerNames.isEmpty()) {
                    this.resumingSession = false;
                }
                if (!this.resumingSession) {
                    Debugger.handshaker.debug("The requested server name indication is not identical to the previous one");
                }
            }
            if (this.resumingSession && this.doClientAuth == 2) {
                try {
                    previous.getPeerPrincipal();
                }
                catch (SSLPeerUnverifiedException e) {
                    this.resumingSession = false;
                }
            }
            if (this.resumingSession) {
                CipherSuite suite = previous.getSuite();
                if (!this.isNegotiable(suite) || !mesg.getCipherSuites().contains(suite)) {
                    this.resumingSession = false;
                } else {
                    this.setBeingCipherSuite(suite);
                }
            }
            if (this.resumingSession) {
                this.session = previous;
                Debugger.handshaker.debug("%% Resuming {}", (Object)this.session);
            }
        }
        if (this.session == null) {
            SignatureAlgorithmsExtension signAlgs;
            if (!this.enableNewSession) {
                throw new SSLException("Client did not resume a session");
            }
            HelloExtension ext = mesg.extensions.get(ExtensionType.EXT_ELLIPTIC_CURVES);
            this.supportedCurves = (SupportedEllipticCurvesExtension)ext;
            if (this.beingProtocolVersion.isStandardTLS12() && (signAlgs = (SignatureAlgorithmsExtension)mesg.extensions.get(ExtensionType.EXT_SIGNATURE_ALGORITHMS)) != null) {
                Collection<SignatureAndHashAlgorithm> peerSignAlgs = signAlgs.getSignAlgorithms();
                if (peerSignAlgs == null || peerSignAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No peer supported signature algorithms");
                }
                List<SignatureAndHashAlgorithm> supportedPeerSignAlgs = SignatureAndHashAlgorithm.getSupportedAlgorithms(peerSignAlgs);
                if (supportedPeerSignAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature and hash algorithm in common");
                }
                this.setPeerSupportedSignAlgs(supportedPeerSignAlgs);
            }
            this.session = new SSLSessionImpl(this.beingProtocolVersion, CipherSuite.C_NULL, this.getLocalSupportedSignAlgs(), this.context.getSecureRandom(), this.getHostAddressSE(), this.getPortSE());
            if (this.beingProtocolVersion.isStandardTLS12() && this.peerSupportedSignAlgs != null) {
                this.session.setPeerSupportedSignatureAlgorithms(this.peerSupportedSignAlgs);
            }
            List<CFCASNIServerName> clientHelloSNI = Collections.emptyList();
            if (clientHelloSNIExt != null) {
                clientHelloSNI = clientHelloSNIExt.getServerNames();
            }
            this.session.setRequestedServerNames(clientHelloSNI);
            this.setHandshakeSessionSE(this.session);
            this.chooseCipherSuite(mesg);
            this.session.setSuite(this.cipherSuite);
            this.session.setLocalCredentials(this.signerCredentials, this.cipherCredentials);
        } else {
            this.setHandshakeSessionSE(this.session);
        }
        if (this.beingProtocolVersion.version == 257) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.prfHashAlg);
        }
        if (this.beingProtocolVersion.isStandardTLS12()) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.prfHashAlg);
        }
        ServerHello m1 = new ServerHello(this.beingProtocolVersion, this.serverRandom, this.session.getSessionId(), this.cipherSuite, this.session.getCompression());
        if (this.beingProtocolVersion.version != 257) {
            if (this.secureRenegotiation) {
                RenegotiationInfoExtension serverHelloRI = new RenegotiationInfoExtension(this.clientVerifyData, this.serverVerifyData);
                m1.extensions.add(serverHelloRI);
            }
            if (!this.sniMatchers.isEmpty() && clientHelloSNIExt != null && !this.resumingSession) {
                ServerNameExtension serverHelloSNI = new ServerNameExtension();
                m1.extensions.add(serverHelloSNI);
            }
        }
        Debugger.debug(m1);
        Debugger.handshaker.debug("Cipher suite:  {}", (Object)this.session.getSuite());
        m1.write(this.out);
    }

    private final void writeCertificate() throws IOException {
        if (this.signerCredentials == null) {
            throw new RuntimeException("no signerCredentials for certificates");
        }
        if (this.signerCredentials.certificates == null) {
            throw new RuntimeException("no signerCertificates for certificates");
        }
        if (this.cipherCredentials == null) {
            throw new RuntimeException("no cipherCredentials for certificates");
        }
        if (this.cipherCredentials.certificates == null) {
            throw new RuntimeException("no cipherCertificates for certificates");
        }
        X509Certificate[] certs = TLSCredentials.concat(this.signerCredentials.certificates, this.cipherCredentials.certificates);
        if (certs == null || certs.length == 0) {
            throw new RuntimeException("no certificates");
        }
        CertificateMsg m2 = new CertificateMsg(certs);
        this.session.setLocalCredentials(this.signerCredentials, this.cipherCredentials);
        Debugger.debug(m2);
        m2.write(this.out);
    }

    private final void writeServerKeyExchange() throws SSLException, IOException {
        HandshakeMessage exchange;
        switch (this.cipherSuite.keyExchange) {
            case K_ECDHE_SM2DSA: {
                try {
                    if (this.signerCredentials == null || this.signerCredentials.privateKey == null) {
                        throw new GeneralSecurityException("missing signerCredentials for ECDHE_SM2DSA");
                    }
                    exchange = new ServerKeyExchange.SKESM2DHE(this.ecdh, this.signerCredentials.privateKey, this.clientRandom, this.serverRandom, this.context.getSecureRandom(), this.preferableSignatureAlgorithm, this.beingProtocolVersion);
                }
                catch (GeneralSecurityException e) {
                    ServerHandshaker.throwSSLException("Error generating ECDHE_SM2DSA server key exchange", e);
                    exchange = null;
                }
                break;
            }
            case K_SM2PKEA_SM2DSA: {
                try {
                    if (this.signerCredentials == null) {
                        throw new SecurityException("missing signerCredentials for ServerKeyExchange[SM2PKEA_SM2DSA]");
                    }
                    if (this.cipherCredentials == null || this.cipherCredentials.getCertificate() == null) {
                        throw new SecurityException("missing cipherCredentials for ServerKeyExchange[SM2PKEA_SM2DSA]");
                    }
                    String sigAlg = "SM3WithSM2";
                    exchange = new ServerKeyExchange.SKEPKEA(sigAlg, this.signerCredentials, this.clientRandom, this.serverRandom, this.cipherCredentials.getCertificate());
                }
                catch (GeneralSecurityException e) {
                    ServerHandshaker.throwSSLException("Error generating SM2PKEA_SM2DSA server key exchange", e);
                    exchange = null;
                }
                break;
            }
            case K_RSAPKEA: {
                try {
                    if (this.signerCredentials == null) {
                        throw new SecurityException("missing signerCredentials for ServerKeyExchange[RSAPKEA]");
                    }
                    if (this.cipherCredentials == null || this.cipherCredentials.getCertificate() == null) {
                        throw new SecurityException("missing cipherCredentials for ServerKeyExchange[RSAPKEA]");
                    }
                    exchange = new ServerKeyExchange.SKEPKEA("MD5andSHA1withRSA", this.signerCredentials, this.clientRandom, this.serverRandom, this.cipherCredentials.getCertificate());
                }
                catch (GeneralSecurityException e) {
                    ServerHandshaker.throwSSLException("Error generating RSAPKEA server key exchange", e);
                    exchange = null;
                }
                break;
            }
            default: {
                throw new RuntimeException("internal error: " + (Object)((Object)this.cipherSuite.keyExchange));
            }
        }
        if (exchange != null) {
            Debugger.debug(exchange);
            exchange.write(this.out);
        }
    }

    private final void writeCertificateRequest() throws SSLHandshakeException, IOException {
        if (this.doClientAuth != 0) {
            List<SignatureAndHashAlgorithm> localSignAlgs = null;
            if (this.beingProtocolVersion.isStandardTLS12()) {
                localSignAlgs = this.getLocalSupportedSignAlgs();
                if (localSignAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature algorithm");
                }
                Set<String> localHashAlgs = SignatureAndHashAlgorithm.getHashAlgorithmNames(localSignAlgs);
                if (localHashAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature algorithm");
                }
            }
            X509Certificate[] caCerts = this.context.getX509TrustManager().getAcceptedIssuers();
            CertificateRequest m4 = new CertificateRequest(caCerts, this.cipherSuite.keyExchange, localSignAlgs, this.beingProtocolVersion);
            Debugger.debug(m4);
            m4.write(this.out);
        }
    }

    private final void writeServerHelloDone() throws IOException {
        ServerHelloDone m5 = new ServerHelloDone();
        Debugger.debug(m5);
        m5.write(this.out);
    }

    private void clientCertificate(CertificateMsg mesg) throws IOException {
        TLSCredentials[] credentials;
        block9: {
            Debugger.debug(mesg);
            X509Certificate[] peercerts = mesg.chain();
            if (peercerts.length == 0) {
                if (this.doClientAuth == 1) {
                    return;
                }
                this.fatalSE((byte)42, "empty certificate chain");
            }
            if ((credentials = TLSCredentials.buildDoubleCredentials(peercerts)) == null || credentials.length != 2) {
                this.fatalSE((byte)42, "invalid certificate chain");
            }
            if (credentials[0] == null || credentials[0].certificates == null) {
                this.fatalSE((byte)42, "invalid signer certificate chain");
            }
            X509TrustManager tm = this.context.getX509TrustManager();
            try {
                PublicKey key = peercerts[0].getPublicKey();
                String keyAlgorithm = key.getAlgorithm();
                String authType = keyAlgorithm.equals("RSA") ? "RSA" : (keyAlgorithm.equals("EC") ? "EC" : "UNKNOWN");
                if (tm instanceof CFCAX509ExtendedTrustManager) {
                    CFCAX509ExtendedTrustManager trustManager = (CFCAX509ExtendedTrustManager)tm;
                    for (TLSCredentials credential : credentials) {
                        if (credential == null || credential.certificates == null) continue;
                        if (this.conn != null) {
                            trustManager.checkServerTrusted((X509Certificate[])credential.certificates.clone(), authType, this.conn);
                            continue;
                        }
                        trustManager.checkServerTrusted((X509Certificate[])credential.certificates.clone(), authType, this.engine);
                    }
                    break block9;
                }
                throw new CertificateException("Improper X509TrustManager implementation");
            }
            catch (CertificateException e) {
                this.fatalSE((byte)46, e);
            }
        }
        this.needClientVerify = true;
        this.session.setPeerCredentials(credentials[0], credentials[1]);
    }

    private SecretKey clientKeyExchange(ClientKeyExchange.CKESM2DH mesg) throws IOException {
        Debugger.debug(mesg);
        ECPublicKey serverPublicKey = (ECPublicKey)this.session.getPeerCipherCredentials().publicKey;
        ECPublicKey clientPublicKey = mesg.getPublicKey();
        if (this.cipherCredentials == null) {
            throw new SecurityException("missing cipherCredentials for clientKeyExchange");
        }
        return this.ecdh.getSM2AgreedSecret(this.cipherCredentials, serverPublicKey, clientPublicKey);
    }

    private void clientCertificateVerify(CertificateVerify mesg) throws IOException {
        Debugger.debug(mesg);
        try {
            PublicKey publicKey = this.session.getPeerSignerCredentials().publicKey;
            boolean valid = mesg.verify(publicKey, this.session.getMasterSecret());
            if (!valid) {
                this.fatalSE((byte)42, "certificate verify message signature error");
            }
        }
        catch (GeneralSecurityException e) {
            this.fatalSE((byte)42, "certificate verify format error", e);
        }
        this.needClientVerify = false;
        Debugger.handshaker.debug("clientCertificateVerify Finished");
    }

    private void clientFinished(Finished mesg) throws IOException {
        boolean verified;
        Debugger.debug(mesg);
        if (this.doClientAuth == 2) {
            this.session.getPeerPrincipal();
        }
        if (this.needClientVerify) {
            this.fatalSE((byte)40, "client did not send certificate verify message");
        }
        if (!(verified = mesg.verify(this.handshakeHash, 1, this.session.getMasterSecret()))) {
            this.fatalSE((byte)40, "client 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.clientVerifyData = mesg.getVerifyData();
        }
        if (!this.resumingSession) {
            this.in.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession && this.session.isRejoinable()) {
            ((SSLSessionContextImpl)this.context.engineGetServerSessionContext()).put(this.session);
            Debugger.handshaker.debug("%% Cached server session: {}", (Object)this.session);
        } else if (!this.resumingSession && Debugger.handshaker.isDebugEnabled()) {
            Debugger.handshaker.debug("%% Didn't cache non-resumable server session: {}", (Object)this.session);
        }
    }

    private void sendChangeCipherAndFinish(boolean finishedTag) throws IOException {
        Debugger.handshaker.debug("sendChangeCipherAndFinish");
        this.out.flush();
        Finished mesg = new Finished(this.beingProtocolVersion, this.handshakeHash, 2, this.session.getMasterSecret(), this.cipherSuite);
        this.sendChangeCipherSpec(mesg, finishedTag);
        if (this.secureRenegotiation) {
            this.serverVerifyData = mesg.getVerifyData();
        }
        if (finishedTag) {
            this.state = 20;
        }
        Debugger.handshaker.debug("sendChangeCipherAndFinish Finished");
    }

    void setClientAuth(byte clientAuth) {
        this.doClientAuth = clientAuth;
    }

    private void chooseCipherSuite(ClientHello mesg) throws IOException {
        CipherSuiteList proposed;
        CipherSuiteList prefered;
        Debugger.handshaker.debug("chooseCipherSuite: ...");
        if (this.preferLocalCipherSuites) {
            prefered = this.getActiveCipherSuites();
            proposed = mesg.getCipherSuites();
        } else {
            prefered = mesg.getCipherSuites();
            proposed = this.getActiveCipherSuites();
        }
        boolean suiteNotFindAlert = true;
        for (CipherSuite suite : prefered.collection()) {
            if (!ServerHandshaker.isNegotiable(proposed, suite) || !this.trySetCipherSuite(suite)) continue;
            Debugger.handshaker.debug("chooseCipherSuite: Finished");
            suiteNotFindAlert = false;
            break;
        }
        if (suiteNotFindAlert) {
            this.fatalSE((byte)40, "no cipher suites in common");
        }
    }

    boolean trySetCipherSuite(CipherSuite suite) {
        Debugger.handshaker.debug("trySetCipherSuite: ...");
        if (this.resumingSession) {
            return true;
        }
        if (!suite.isNegotiable()) {
            return false;
        }
        if (this.beingProtocolVersion.version >= suite.obsoleted) {
            return false;
        }
        if (this.beingProtocolVersion.version < suite.supported) {
            return false;
        }
        KeyExchangeAlgorithm keyExchange = suite.keyExchange;
        this.signerCredentials = null;
        this.cipherCredentials = null;
        ArrayList<SignatureAndHashAlgorithm> supportedSignAlgs = null;
        if (this.beingProtocolVersion.isStandardTLS12()) {
            if (this.peerSupportedSignAlgs != null) {
                supportedSignAlgs = this.peerSupportedSignAlgs;
            } else {
                SignatureAndHashAlgorithm algorithm = null;
                switch (keyExchange) {
                    case K_RSAPKEA: {
                        algorithm = SignatureAndHashAlgorithm.valueOf(SignatureAndHashAlgorithm.HashAlgorithm.SHA1.value, SignatureAndHashAlgorithm.SignatureAlgorithm.RSA.value, 0);
                        break;
                    }
                    case K_ECDHE_SM2DSA: 
                    case K_SM2PKEA_SM2DSA: {
                        algorithm = SignatureAndHashAlgorithm.valueOf(SignatureAndHashAlgorithm.HashAlgorithm.SHA1.value, SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA.value, 0);
                        break;
                    }
                }
                if (algorithm == null) {
                    supportedSignAlgs = new ArrayList<SignatureAndHashAlgorithm>(0);
                } else {
                    supportedSignAlgs = new ArrayList(1);
                    supportedSignAlgs.add(algorithm);
                }
                this.session.setPeerSupportedSignatureAlgorithms(supportedSignAlgs);
            }
        }
        switch (keyExchange) {
            case K_RSAPKEA: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                Debugger.handshaker.debug("keyExchange:  >>> K_RSA");
                break;
            }
            case K_ECDHE_SM2DSA: {
                if (this.beingProtocolVersion.isStandardTLS12()) {
                    this.preferableSignatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm((List<SignatureAndHashAlgorithm>)supportedSignAlgs, "SM2");
                    if (this.preferableSignatureAlgorithm == null) {
                        return false;
                    }
                }
                if (!this.setupPrivateKeyAndChain("SM2_SM2")) {
                    return false;
                }
                if (this.setupEphemeralECDHKeys(true)) break;
                return false;
            }
            case K_SM2PKEA_SM2DSA: {
                if (this.setupPrivateKeyAndChain("SM2_SM2")) break;
                return false;
            }
            default: {
                throw new RuntimeException("Unrecognized cipherSuite: " + suite);
            }
        }
        this.setBeingCipherSuite(suite);
        if (this.beingProtocolVersion.isStandardTLS12() && this.peerSupportedSignAlgs == null) {
            this.setPeerSupportedSignAlgs(supportedSignAlgs);
        }
        Debugger.handshaker.debug("trySetCipherSuite: Finished");
        return true;
    }

    private boolean setupEphemeralECDHKeys(boolean smFlag) {
        Debugger.handshaker.debug("setupEphemeralECDHKeys: ...");
        int index = -1;
        if (this.supportedCurves != null) {
            for (int curveId : this.supportedCurves.curveIds()) {
                if (!SupportedEllipticCurvesExtension.isSupported(curveId)) continue;
                index = curveId;
                break;
            }
            if (index < 0) {
                return false;
            }
        } else {
            index = SupportedEllipticCurvesExtension.firstCurveId();
        }
        String oid = SupportedEllipticCurvesExtension.getCurveOid(index);
        Debugger.handshaker.debug("setupEphemeralECDHKeys: >>ECDHCrypt");
        this.ecdh = new ECDHCrypt(smFlag, oid, this.context.getSecureRandom());
        Debugger.handshaker.debug("setupEphemeralECDHKeys: Finished");
        return true;
    }

    private boolean setupPrivateKeyAndChain(String algorithm) {
        X509ExtendedKeyManager km = this.context.getX509KeyManager();
        String[] alias = km.getServerAliases(algorithm, null);
        if (alias == null || alias.length == 0) {
            return false;
        }
        this.signerCredentials = this.getTLSCredentials(km, algorithm, alias[0]);
        if (this.signerCredentials == null) {
            return false;
        }
        if (alias.length > 1) {
            this.cipherCredentials = this.getTLSCredentials(km, algorithm, alias[1]);
        }
        if (this.cipherCredentials == null) {
            this.cipherCredentials = this.signerCredentials;
        }
        Debugger.handshaker.debug("setupPrivateKeyAndChain: Finished");
        return true;
    }

    @Override
    HandshakeMessage getKickstartMessage() {
        Debugger.handshaker.debug("getKickstartMessage");
        return new HelloRequest();
    }

    @Override
    void handshakeAlert(byte description) throws SSLProtocolException {
        String message = Alerts.alertDescription(description);
        Debugger.handshaker.debug("SSL -- handshake alert:  {}", (Object)message);
        if (description == 41 && this.doClientAuth == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert: " + message);
    }

    final TLSCredentials getTLSCredentials(X509ExtendedKeyManager km, String algorithm, String alias) {
        PrivateKey tempPrivateKey = km.getPrivateKey(alias);
        if (tempPrivateKey == null) {
            return null;
        }
        X509Certificate[] certificates = km.getCertificateChain(alias);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        String keyAlgorithm = algorithm.split("_")[0];
        PublicKey publicKey = certificates[0].getPublicKey();
        String prikType = tempPrivateKey.getAlgorithm();
        String pubkType = publicKey.getAlgorithm();
        if ("ECDSA".equals(prikType)) {
            prikType = "EC";
        }
        if (!prikType.equals(keyAlgorithm) || !pubkType.equals(keyAlgorithm)) {
            return null;
        }
        if (keyAlgorithm.equals("EC")) {
            if (publicKey instanceof ECPublicKey) {
                ECParameterSpec params = ((ECPublicKey)publicKey).getParameters();
                if (!ECNamedCurve.isSM2NamedCurve(params)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return new TLSCredentials(tempPrivateKey, certificates);
    }

    private final void calculateWorkKeys(int message_len) throws SSLProtocolException, IOException {
        SecretKey preMasterSecret;
        switch (this.cipherSuite.keyExchange) {
            case K_ECDHE_SM2DSA: {
                preMasterSecret = this.clientKeyExchange(new ClientKeyExchange.CKESM2DH(this.ecdh, this.in));
                break;
            }
            case K_SM2PKEA_SM2DSA: 
            case K_RSAPKEA: {
                if (this.cipherCredentials == null) {
                    throw new SSLProtocolException("missing signerCredentials for calculateWorkKeys[RSAPKEA]");
                }
                if (this.cipherCredentials.privateKey == null) {
                    throw new SSLProtocolException("missing signerprivateKey for calculateWorkKeys[RSAPKEA]");
                }
                ClientKeyExchange.CKEPKEA pkea = new ClientKeyExchange.CKEPKEA(this.beingProtocolVersion, this.clientRequestedVersion, this.context.getSecureRandom(), this.in, message_len, this.cipherCredentials.privateKey);
                preMasterSecret = pkea.preMasterKey;
                break;
            }
            default: {
                throw new SSLProtocolException("Unrecognized key exchange: " + (Object)((Object)this.cipherSuite.keyExchange));
            }
        }
        this.calculateKeys(preMasterSecret, this.clientRequestedVersion);
        preMasterSecret = null;
    }
}

