/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.tls.javax.net.ssl.CFCASNIHostName;
import cfca.sadk.tls.javax.net.ssl.CFCASNIMatcher;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.util.DataHelper;
import cfca.sadk.tls.util.Hexifys;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLProtocolException;

public final class ServerNameExtension
extends HelloExtension {
    static final int NAME_HEADER_LENGTH = 3;
    private Map<Integer, CFCASNIServerName> sniMap;
    private int listLength;

    public ServerNameExtension() throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        this.listLength = 0;
        this.sniMap = Collections.emptyMap();
    }

    public ServerNameExtension(List<CFCASNIServerName> serverNames) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        this.listLength = 0;
        this.sniMap = new LinkedHashMap<Integer, CFCASNIServerName>();
        for (CFCASNIServerName serverName : serverNames) {
            if (this.sniMap.put(serverName.getType(), serverName) != null) {
                throw new RuntimeException("Duplicated server name of type " + serverName.getType());
            }
            this.listLength += serverName.length() + 3;
        }
        if (this.listLength == 0) {
            throw new RuntimeException("The ServerNameList cannot be empty");
        }
    }

    ServerNameExtension(HandshakeInStream in, int len) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        int remains = len;
        if (len >= 2) {
            this.listLength = in.getInt16();
            if (this.listLength == 0 || this.listLength + 2 != len) {
                throw new SSLProtocolException("Invalid " + (Object)((Object)this.type) + " extension");
            }
            remains -= 2;
            this.sniMap = new LinkedHashMap<Integer, CFCASNIServerName>();
            while (remains > 0) {
                CFCASNIServerName serverName;
                int code = in.getInt8();
                byte[] encoded = in.getBytes16();
                switch (code) {
                    case 0: {
                        if (encoded.length == 0) {
                            throw new SSLProtocolException("Empty HostName in server name indication");
                        }
                        try {
                            serverName = new CFCASNIHostName(encoded);
                            break;
                        }
                        catch (IllegalArgumentException iae) {
                            SSLProtocolException spe = new SSLProtocolException("Illegal server name, type=host_name(" + code + "), name=" + new String(encoded, "UTF-8") + ", value=0x" + Hexifys.hexify(encoded));
                            spe.initCause(iae);
                            throw spe;
                        }
                    }
                    default: {
                        try {
                            serverName = new UnknownServerName(code, encoded);
                            break;
                        }
                        catch (IllegalArgumentException iae) {
                            SSLProtocolException spe = new SSLProtocolException("Illegal server name, type=(" + code + "), value=0x" + Hexifys.hexify(encoded));
                            spe.initCause(iae);
                            throw spe;
                        }
                    }
                }
                if (this.sniMap.put(serverName.getType(), serverName) != null) {
                    throw new SSLProtocolException("Duplicated server name of type " + serverName.getType());
                }
                remains -= encoded.length + 3;
            }
        } else if (len == 0) {
            this.listLength = 0;
            this.sniMap = Collections.emptyMap();
        }
        if (remains != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    public List<CFCASNIServerName> getServerNames() {
        if (this.sniMap != null && !this.sniMap.isEmpty()) {
            return Collections.unmodifiableList(new ArrayList<CFCASNIServerName>(this.sniMap.values()));
        }
        return Collections.emptyList();
    }

    public boolean isMatched(Collection<CFCASNIMatcher> matchers) {
        if (this.sniMap != null && !this.sniMap.isEmpty()) {
            for (CFCASNIMatcher matcher : matchers) {
                CFCASNIServerName sniName = this.sniMap.get(matcher.getType());
                if (sniName == null || matcher.matches(sniName)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isIdentical(List<CFCASNIServerName> other) {
        if (other.size() == this.sniMap.size()) {
            for (CFCASNIServerName sniInOther : other) {
                CFCASNIServerName sniName = this.sniMap.get(sniInOther.getType());
                if (sniName != null && sniInOther.equals(sniName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    final int length() {
        return this.listLength == 0 ? 4 : 6 + this.listLength;
    }

    @Override
    final byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        DataHelper.write((short)this.type.id, encoded, 0);
        if (this.listLength == 0) {
            DataHelper.write((short)0, encoded, 2);
        } else {
            DataHelper.write((short)(this.listLength + 2), encoded, 2);
            DataHelper.write((short)this.listLength, encoded, 4);
            byte[] value = null;
            int offset = 6;
            for (CFCASNIServerName sniName : this.sniMap.values()) {
                DataHelper.write((byte)sniName.getType(), encoded, offset++);
                value = sniName.getEncoded();
                if (value == null) {
                    value = new byte[]{};
                }
                DataHelper.write((short)value.length, encoded, offset += 2);
                DataHelper.write(value, encoded, offset += value.length);
            }
        }
        return encoded;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension ").append((Object)this.type);
        builder.append(", server_name: ");
        for (CFCASNIServerName sniName : this.sniMap.values()) {
            builder.append("[" + sniName + "]");
        }
        return builder.toString();
    }

    private static class UnknownServerName
    extends CFCASNIServerName {
        UnknownServerName(int code, byte[] encoded) {
            super(code, encoded);
        }
    }
}

