/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.bean.attachments.AttachmentWithData;
import cfca.sadk.ofd.base.common.Dom4jUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.seal.AttachmentResultInfo;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class AttachmentUtil {
    private static Logger businessLog = LoggerFactory.getLogger(AttachmentUtil.class);

    public static AttachmentResultInfo addAttachment(byte[] ofdDatas, Map<String, byte[]> attachmentFiles) throws Exception {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null");
        }
        if (null == attachmentFiles || attachmentFiles.size() == 0) {
            throw new IllegalArgumentException("attachmentFiles is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
        return AttachmentUtil.doAddAttachment(filesMap, attachmentFiles);
    }

    public static AttachmentResultInfo addAttachment(InputStream ofdInputStream, Map<String, byte[]> attachmentFiles) throws Exception {
        if (null == ofdInputStream) {
            throw new IllegalArgumentException("ofdInputStream is null");
        }
        if (null == attachmentFiles || attachmentFiles.size() == 0) {
            throw new IllegalArgumentException("attachmentFiles is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(ofdInputStream);
        return AttachmentUtil.doAddAttachment(filesMap, attachmentFiles);
    }

    public static AttachmentResultInfo getAttachmentsInfo(byte[] ofdDatas) throws Exception {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
        return AttachmentUtil.doGetAttachmentsInfo(filesMap);
    }

    public static AttachmentResultInfo getAttachmentsInfo(InputStream ofdInputStream) throws Exception {
        if (null == ofdInputStream) {
            throw new IllegalArgumentException("ofdInputStream is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(ofdInputStream);
        return AttachmentUtil.doGetAttachmentsInfo(filesMap);
    }

    private static AttachmentResultInfo doAddAttachment(Map<String, byte[]> filesMap, Map<String, byte[]> attachmentFiles) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("doAddAttachment start...");
        AttachmentResultInfo addAttachmentResult = new AttachmentResultInfo();
        try {
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            String attachmentDir = baseDir + "Attachs/";
            byte[] attachmentXmlFile = filesMap.get(attachmentDir + "Attachments.xml");
            if (null == attachmentXmlFile) {
                SealXMLUtil.generateAttachments(filesMap, attachmentFiles, baseDir);
                SealXMLUtil.addAttahsInDocument(filesMap, baseDir);
            } else {
                SealXMLUtil.updateAttachments(filesMap, attachmentFiles, baseDir);
            }
            for (String fileName : attachmentFiles.keySet()) {
                byte[] attachmentFile = attachmentFiles.get(fileName);
                filesMap.put(attachmentDir + fileName, attachmentFile);
            }
            ByteArrayOutputStream newOFDStream = ZipUtil.compress(filesMap);
            addAttachmentResult.setAddedData(newOFDStream.toByteArray());
            addAttachmentResult.setSucess(true);
            AttachmentResultInfo attachmentResultInfo = addAttachmentResult;
            return attachmentResultInfo;
        }
        catch (SealException e) {
            businessLog.error("doAddAttachment failed:", (Throwable)e);
            addAttachmentResult.setSucess(false);
            addAttachmentResult.setFailReason(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            businessLog.error("doAddAttachment failed:", (Throwable)e);
            addAttachmentResult.setSucess(false);
            addAttachmentResult.setFailReason(e.getMessage());
            throw new SealException("doAddAttachment failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("doAddAttachment end...cost= " + (end - start) + " ms");
        }
    }

    private static AttachmentResultInfo doGetAttachmentsInfo(Map<String, byte[]> filesMap) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("doGetAttachmentsInfo start...");
        AttachmentResultInfo result = new AttachmentResultInfo();
        ArrayList<AttachmentWithData> list = new ArrayList<AttachmentWithData>();
        try {
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            String attachmentDir = baseDir + "Attachs/";
            byte[] attachmentXmlFile = filesMap.get(attachmentDir + "Attachments.xml");
            if (null == attachmentXmlFile) {
                throw new IllegalArgumentException("no attachment exists!");
            }
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get("Doc_0/Attachs/Attachments.xml")));
            Element body = document.getRootElement();
            List elemList = body.elements("Attachment");
            for (int i = 0; i < elemList.size(); ++i) {
                AttachmentWithData attachment = new AttachmentWithData();
                Element attachmentElem = (Element)elemList.get(i);
                attachment.setID(new BigInteger(attachmentElem.attributeValue("ID")));
                attachment.setName(attachmentElem.attributeValue("Name"));
                attachment.setFormat(attachmentElem.attributeValue("Format"));
                attachment.setCreationDate(attachmentElem.attributeValue("CreationDate"));
                double size = Double.parseDouble(attachmentElem.attributeValue("Size"));
                attachment.setSize(new BigDecimal(size * 1000.0));
                String fileName = attachmentElem.element("FileLoc").getStringValue();
                attachment.setFileLoc(fileName);
                byte[] fileData = filesMap.get(attachmentDir + fileName);
                attachment.setAttachmentData(fileData);
                list.add(attachment);
            }
            result.setSucess(true);
            result.setAttachmentList(list);
            AttachmentResultInfo attachmentResultInfo = result;
            return attachmentResultInfo;
        }
        catch (Exception e) {
            businessLog.error("doGetAttachmentsInfo failed:", (Throwable)e);
            result.setSucess(false);
            result.setFailReason(e.getMessage());
            throw new SealException("doGetAttachmentsInfo failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("doGetAttachmentsInfo end...cost= " + (end - start) + " ms");
        }
    }

    static {
        VersionInfo.environments();
    }
}

