/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.bean;

import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.timestamp.client.utils.TscStrings;
import java.util.Arrays;
import org.apache.http.util.Args;

public final class MessageImprint {
    private final HashAlgorithm hashAlgorithm;
    private final byte[] hashedMessage;

    public MessageImprint(HashAlgorithm hashAlgorithm, byte[] hashedMessage) {
        this.hashAlgorithm = (HashAlgorithm)((Object)Args.notNull((Object)((Object)hashAlgorithm), (String)"hashAlgorithm"));
        this.hashedMessage = (byte[])Args.notNull((Object)hashedMessage, (String)"hashedMessage");
        if (hashedMessage.length != hashAlgorithm.hashLength) {
            throw new IllegalArgumentException("hashedMessageLength not match hashAlgorithm");
        }
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getHashedMessage() {
        return this.hashedMessage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashAlgorithm == null ? 0 : this.hashAlgorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.hashedMessage);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageImprint other = (MessageImprint)obj;
        if (this.hashAlgorithm != other.hashAlgorithm) {
            return false;
        }
        return Arrays.equals(this.hashedMessage, other.hashedMessage);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageImprint [hashAlgorithm=");
        builder.append((Object)this.hashAlgorithm);
        builder.append(", hashedMessage=");
        if (this.hashedMessage == null) {
            builder.append("none");
        } else {
            builder.append("");
            builder.append(TscStrings.toHexString(this.hashedMessage));
        }
        builder.append("]");
        return builder.toString();
    }
}

