/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static Logger businessLog = LoggerFactory.getLogger(ZipUtil.class);

    public static Map<String, byte[]> uncompress(InputStream inputStream) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("uncompress start...");
        try {
            ZipInputStream zis = new ZipInputStream(inputStream, Charset.forName("GBK"));
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[10240];
                int length = -1;
                while ((length = zis.read(buffer, 0, buffer.length)) > -1) {
                    byteArrayOutputStream.write(buffer, 0, length);
                }
                if (name.endsWith("/")) continue;
                map.put(name, byteArrayOutputStream.toByteArray());
            }
            zis.close();
            HashMap<String, byte[]> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            businessLog.error("uncompress failed:", (Throwable)e);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("uncompress end...cost=" + (end - start) + " ms");
        }
    }

    public static ByteArrayOutputStream compress(Map<String, byte[]> map) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("compress start...");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(byteArrayOutputStream);
            Set<Map.Entry<String, byte[]>> entries = map.entrySet();
            for (Map.Entry<String, byte[]> entry : entries) {
                zipOut.putNextEntry(new ZipEntry(entry.getKey()));
                zipOut.write(entry.getValue());
            }
            zipOut.close();
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            return byteArrayOutputStream2;
        }
        catch (Exception e) {
            businessLog.error("compress failed:", (Throwable)e);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("compress end...cost=" + (end - start) + " ms");
        }
    }
}

