/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

final class RSACardBigIntegers {
    private RSACardBigIntegers() {
    }

    static int parseModulusBitLength(BigInteger modulus) throws CryptoException {
        if (modulus == null) {
            throw new CryptoParameterException("parseModulusBitLength failure with missing param#modulus");
        }
        int bitLength = 7 + modulus.bitLength() >> 3 << 3;
        if (bitLength < 1024 || bitLength > 4096) {
            throw new CryptoParameterException("parseModulusBitLength failure with invalid bitLength: " + bitLength);
        }
        return bitLength;
    }

    static int parseBitLength(byte[] rsaKeyData) throws CryptoException {
        if (rsaKeyData == null || rsaKeyData.length < 4) {
            throw new CryptoParameterException("parseBitLength failure with rsaKeyData is null/not enough space");
        }
        if (rsaKeyData[0] != 0 || rsaKeyData[1] != 0) {
            throw new CryptoParameterException("parseBitLength failure with rsaKeyData[0/1] invalid");
        }
        int bitLength = (rsaKeyData[2] & 0xFF) << 8 | rsaKeyData[3] & 0xFF;
        if (bitLength < 1024 || bitLength > 4096) {
            throw new CryptoParameterException("parseBitLength failure with rsaKeyData[2/3] invalid");
        }
        return bitLength;
    }

    static BigInteger parseBigInteger(byte[] rsaKeyData, int offset, int length, int limitedBitlength) throws CryptoException {
        if (rsaKeyData == null) {
            throw new CryptoParameterException("parseBigInteger failure with rsaKeyData is null");
        }
        if (rsaKeyData.length < offset + length) {
            throw new CryptoParameterException("parseBigInteger failure with rsaKeyData not enough length");
        }
        byte[] bytes = new byte[length];
        System.arraycopy(rsaKeyData, offset, bytes, 0, bytes.length);
        BigInteger value = new BigInteger(1, bytes);
        if (value.bitLength() > limitedBitlength) {
            throw new CryptoParameterException(String.format("parseBigInteger failure with invalid bitLength=%d limited %d", value.bitLength(), limitedBitlength));
        }
        return value;
    }

    static void copyBigInteger(String paramName, BigInteger m, int limitedByteLength, byte[] output, int offset) throws CryptoException {
        if (m == null || m.bitLength() == 0) {
            throw new CryptoParameterException(String.format("copyBigInteger[%s] failure with invalid m null or bitsLength ==0", paramName));
        }
        int limitedBitsLength = limitedByteLength << 3;
        if (m.bitLength() > limitedBitsLength) {
            throw new CryptoParameterException(String.format("copyBigInteger[%s] failure with invalid m bitsLength=%d limited=%d", paramName, m.bitLength(), limitedBitsLength));
        }
        if (output == null || output.length < limitedByteLength + offset) {
            throw new CryptoParameterException(String.format("copyBigInteger[%s] failure with output is null/not enough space", paramName));
        }
        byte[] data = BigIntegers.asUnsignedByteArray(limitedByteLength, m);
        System.arraycopy(data, 0, output, offset, data.length);
    }

    static int copyBitLength(int bitLength, byte[] output, int offset) throws CryptoException {
        if (output == null || output.length < offset + 4) {
            throw new CryptoException("copyBitLength failure with output is null/not enough space");
        }
        int starter = offset;
        output[starter++] = 0;
        output[starter++] = 0;
        output[starter++] = (byte)(bitLength >> 8 & 0xFF);
        output[starter++] = (byte)(bitLength & 0xFF);
        return 4;
    }
}

