/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.provider.certpath;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.java.security.CFCACryptoPrimitive;
import cfca.sadk.tls.sun.security.provider.certpath.CFCAPKIX;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyUsage;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.util.CFCADisabledAlgorithmConstraints;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public final class CFCAAlgorithmChecker
extends PKIXCertPathChecker {
    public static final Logger LOG = LoggerFactory.getLogger(CFCAAlgorithmChecker.class);
    private final CFCAAlgorithmConstraints constraints;
    private final PublicKey trustedPubKey;
    private PublicKey prevPubKey;
    private static final Set<CFCACryptoPrimitive> SIGNATURE_PRIMITIVE_SET = EnumSet.of(CFCACryptoPrimitive.SIGNATURE);
    private static final CFCADisabledAlgorithmConstraints certPathDefaultConstraints = new CFCADisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");

    public CFCAAlgorithmChecker(TrustAnchor anchor) {
        this(anchor, certPathDefaultConstraints);
    }

    public CFCAAlgorithmChecker(CFCAAlgorithmConstraints constraints) {
        this.prevPubKey = null;
        this.trustedPubKey = null;
        this.constraints = constraints;
    }

    public CFCAAlgorithmChecker(TrustAnchor anchor, CFCAAlgorithmConstraints constraints) {
        if (anchor == null) {
            throw new IllegalArgumentException("The trust anchor cannot be null");
        }
        this.trustedPubKey = anchor.getTrustedCert() != null ? anchor.getTrustedCert().getPublicKey() : anchor.getCAPublicKey();
        this.prevPubKey = this.trustedPubKey;
        this.constraints = constraints;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (!forward) {
            this.prevPubKey = this.trustedPubKey != null ? this.trustedPubKey : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        AlgorithmParameters currSigAlgParams;
        if (this.constraints == null || !(cert instanceof X509Certificate)) {
            return;
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        PublicKey currPubKey = x509Cert.getPublicKey();
        String currSigAlg = x509Cert.getSigAlgName();
        try {
            currSigAlgParams = JSSEJCE.getAlgorithmParameters(currSigAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertPathValidatorException(e);
        }
        catch (Exception e) {
            throw new CertPathValidatorException(e);
        }
        if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, currSigAlg, currSigAlgParams)) {
            throw new CertPathValidatorException("Algorithm constraints check failed: " + currSigAlg, null, null, -1);
        }
        boolean[] keyUsage = x509Cert.getKeyUsage();
        if (keyUsage != null && keyUsage.length < 9) {
            throw new CertPathValidatorException("incorrect KeyUsage extension", null, null, -1);
        }
        if (keyUsage != null) {
            EnumSet<CFCACryptoPrimitive> primitives = EnumSet.noneOf(CFCACryptoPrimitive.class);
            if (keyUsage[CertKeyUsage.digitalSignature.bitsIndex] || keyUsage[CertKeyUsage.nonRepudiation.bitsIndex] || keyUsage[CertKeyUsage.keyCertSign.bitsIndex] || keyUsage[CertKeyUsage.cRLSign.bitsIndex]) {
                primitives.add(CFCACryptoPrimitive.SIGNATURE);
            }
            if (keyUsage[CertKeyUsage.keyEncipherment.bitsIndex]) {
                primitives.add(CFCACryptoPrimitive.KEY_ENCAPSULATION);
            }
            if (keyUsage[CertKeyUsage.dataEncipherment.bitsIndex]) {
                primitives.add(CFCACryptoPrimitive.PUBLIC_KEY_ENCRYPTION);
            }
            if (keyUsage[CertKeyUsage.keyAgreement.bitsIndex]) {
                primitives.add(CFCACryptoPrimitive.KEY_AGREEMENT);
            }
            if (!primitives.isEmpty() && !this.constraints.permits(primitives, currPubKey)) {
                throw new CertPathValidatorException("algorithm constraints check failed", null, null, -1);
            }
        }
        if (this.prevPubKey != null) {
            if (currSigAlg != null && !this.constraints.permits(SIGNATURE_PRIMITIVE_SET, currSigAlg, this.prevPubKey, currSigAlgParams)) {
                throw new CertPathValidatorException("Algorithm constraints check failed: " + currSigAlg, null, null, -1);
            }
            if (CFCAPKIX.isDSAPublicKeyWithoutParams(currPubKey)) {
                if (!(this.prevPubKey instanceof DSAPublicKey)) {
                    throw new CertPathValidatorException("Input key is not of a appropriate type for inheriting parameters");
                }
                DSAParams params = ((DSAPublicKey)this.prevPubKey).getParams();
                if (params == null) {
                    throw new CertPathValidatorException("Key parameters missing");
                }
                try {
                    BigInteger y = ((DSAPublicKey)currPubKey).getY();
                    KeyFactory kf = JSSEJCE.getKeyFactory("DSA");
                    DSAPublicKeySpec ks = new DSAPublicKeySpec(y, params.getP(), params.getQ(), params.getG());
                    currPubKey = kf.generatePublic(ks);
                }
                catch (GeneralSecurityException e) {
                    throw new CertPathValidatorException("Unable to generate key with inherited parameters: " + e.getMessage(), e);
                }
            }
        }
        this.prevPubKey = currPubKey;
    }

    void trySetTrustAnchor(TrustAnchor anchor) {
        if (this.prevPubKey == null) {
            if (anchor == null) {
                throw new IllegalArgumentException("The trust anchor cannot be null");
            }
            this.prevPubKey = anchor.getTrustedCert() != null ? anchor.getTrustedCert().getPublicKey() : anchor.getCAPublicKey();
        }
    }

    static void check(PublicKey key, X509CRL crl) throws CertPathValidatorException {
    }
}

