/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.EllipticPointFormat;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.util.DataHelper;
import java.io.IOException;
import javax.net.ssl.SSLProtocolException;

final class SupportedEllipticPointFormatsExtension
extends HelloExtension {
    static final HelloExtension DEFAULT = new SupportedEllipticPointFormatsExtension(new byte[]{(byte)EllipticPointFormat.FMT_UNCOMPRESSED.id});
    private final byte[] formats;

    private SupportedEllipticPointFormatsExtension(byte[] formats) {
        super(ExtensionType.EXT_EC_POINT_FORMATS);
        this.formats = formats;
    }

    SupportedEllipticPointFormatsExtension(HandshakeInStream in, int len) throws IOException {
        super(ExtensionType.EXT_EC_POINT_FORMATS);
        this.formats = in.getBytes8();
        boolean uncompressed = false;
        for (byte format : this.formats) {
            if (format != EllipticPointFormat.FMT_UNCOMPRESSED.id) continue;
            uncompressed = true;
            break;
        }
        if (!uncompressed) {
            throw new SSLProtocolException("Peer does not support uncompressed points");
        }
    }

    @Override
    final int length() {
        return 5 + (this.formats == null ? 0 : this.formats.length);
    }

    @Override
    final byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        int dataLength = encoded.length - 5;
        DataHelper.write((short)this.type.id, encoded, 0);
        DataHelper.write((short)(dataLength + 1), encoded, 2);
        DataHelper.write((byte)dataLength, encoded, 4);
        DataHelper.write(this.formats, encoded, 5);
        return encoded;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension ").append((Object)this.type);
        builder.append(", formats: ");
        boolean opened = false;
        EllipticPointFormat format = null;
        for (byte id : this.formats) {
            if (opened) {
                builder.append(", ");
            } else {
                opened = true;
            }
            format = EllipticPointFormat.valueOf(id);
            if (format == null) {
                builder.append("unknown-").append((Object)format);
                continue;
            }
            builder.append((Object)format);
        }
        return builder.toString();
    }
}

