/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.util.Utilities;

final class TlsKeyMaterialsTools {
    private TlsKeyMaterialsTools() {
    }

    static byte[][] genConst() {
        int n = 10;
        byte[][] arr = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] b = new byte[i + 1];
            Utilities.fill(b, (byte)(65 + i));
            arr[i] = b;
        }
        return arr;
    }

    static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Utilities.fill(padding, b);
        return padding;
    }

    static byte[] concat(byte[] b1, byte[] b2) {
        if (b1 == null) {
            throw new NullPointerException("concat failure with b1=null");
        }
        if (b2 == null) {
            throw new NullPointerException("concat failure with b2=null");
        }
        int n1 = b1.length;
        int n2 = b2.length;
        byte[] b = new byte[n1 + n2];
        System.arraycopy(b1, 0, b, 0, n1);
        System.arraycopy(b2, 0, b, n1, n2);
        return b;
    }

    static byte[] copyBytes(byte[] original, int from, int copyLength) {
        if (original == null) {
            throw new IllegalArgumentException("original must not be null");
        }
        if (from < 0) {
            throw new IllegalArgumentException(String.format("from(%d) < 0", from));
        }
        if (copyLength < 0) {
            throw new IllegalArgumentException(String.format("copyLength(%d) < 0", copyLength));
        }
        if (original.length - from < copyLength) {
            String warning = String.format("original data shortage: original.length(%d) - from(%d) < copyLength(%d)", original.length, from, copyLength);
            throw new IllegalArgumentException(warning);
        }
        byte[] copy = new byte[copyLength];
        System.arraycopy(original, from, copy, 0, copyLength);
        return copy;
    }

    static final void checkParameters(HashPRF hashPRF, byte[] clientRandom, byte[] serverRandom) {
        if (hashPRF == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "prfHashParameters"));
        }
        if (clientRandom == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "clientRandom"));
        }
        if (serverRandom == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "serverRandom"));
        }
    }
}

