/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.model.cell;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public enum FontFamily {
    TIMES_NEW_ROMAN(0, "Times New Roman"),
    ARIAL(1, "Arial"),
    TAHOMA(2, "Tahoma"),
    VERDANA(3, "Verdana"),
    MS_YA_HEI(4, "\u5fae\u8f6f\u96c5\u9ed1"),
    SONG(5, "\u5b8b\u4f53"),
    ST_HEI_TI(6, "\u9ed1\u4f53"),
    ST_KAI_TI(7, "\u6977\u4f53"),
    ST_FANG_SONG(8, "\u4eff\u5b8b"),
    ST_SONG(9, "\u65b0\u5b8b\u4f53"),
    HUA_WEN_XIN_WEI(10, "\u534e\u6587\u65b0\u9b4f"),
    HUA_WEN_XING_KAI(11, "\u534e\u6587\u884c\u6977"),
    HUA_WEN_LI_SHU(12, "\u534e\u6587\u96b6\u4e66");

    @JsonValue
    private final Integer lsValue;
    private final String poiValue;
    private static final Map<String, FontFamily> NAMES_OR_IDS;

    @JsonCreator
    public static FontFamily of(Object nameOrId) {
        if (nameOrId == null) {
            return ARIAL;
        }
        String key = nameOrId instanceof Number ? String.valueOf(((Number)nameOrId).intValue()) : nameOrId.toString();
        FontFamily fontFamily = NAMES_OR_IDS.get(key);
        if (Objects.isNull((Object)fontFamily)) {
            return ARIAL;
        }
        return fontFamily;
    }

    @Generated
    public Integer getLsValue() {
        return this.lsValue;
    }

    @Generated
    public String getPoiValue() {
        return this.poiValue;
    }

    @Generated
    private FontFamily(Integer lsValue, String poiValue) {
        this.lsValue = lsValue;
        this.poiValue = poiValue;
    }

    static {
        NAMES_OR_IDS = Arrays.stream(FontFamily.values()).collect(Collectors.toMap(FontFamily::getPoiValue, Function.identity()));
        NAMES_OR_IDS.putAll(Arrays.stream(FontFamily.values()).collect(Collectors.toMap(e -> String.valueOf(e.getLsValue()), Function.identity())));
    }
}

