/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.sample.sfview;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.sample.sfview.OtTableTagger;
import cfca.sadk.com.google.typography.font.sfntly.sample.sfview.ViewableTaggedData;
import cfca.sadk.com.google.typography.font.sfntly.table.core.PostScriptTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.GSubTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.Scrollable;

class SFFontView
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private final ViewableTaggedData viewer;

    SFFontView(Font font) {
        this.setBackground(Color.WHITE);
        PostScriptTable post = (PostScriptTable)font.getTable(Tag.post);
        ViewableTaggedData.TaggedDataImpl tdata = new ViewableTaggedData.TaggedDataImpl(post);
        OtTableTagger tagger = new OtTableTagger(tdata);
        GSubTable gsub = (GSubTable)font.getTable(Tag.GSUB);
        tagger.tag(gsub);
        this.viewer = new ViewableTaggedData(tdata.getMarkers());
        Dimension dimensions = this.viewer.measure(true);
        Dimension minimumSize = new Dimension(400, 400);
        this.setMinimumSize(minimumSize);
        this.setPreferredSize(dimensions);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int width = Math.min(500, this.viewer.totalWidth());
        int height = 25 * this.viewer.lineHeight();
        return new Dimension(width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.viewer.draw(g, 0, 0);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return 50;
        }
        return this.viewer.lineHeight();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return this.viewer.totalWidth();
        }
        int lines = visibleRect.height / this.viewer.lineHeight() - 2;
        if (lines < 1) {
            lines = 1;
        }
        return lines * this.viewer.lineHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

