/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.action;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;

public class PdfTargetDictionary
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -5814265943827690509L;

    public PdfTargetDictionary(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfTargetDictionary(PdfName r) {
        this(new PdfDictionary());
        this.put(PdfName.R, r);
    }

    public PdfTargetDictionary(PdfName r, PdfString n, PdfObject p, PdfObject a, PdfTargetDictionary t) {
        this(new PdfDictionary());
        this.put(PdfName.R, r).put(PdfName.N, n).put(PdfName.P, p).put(PdfName.A, a).put(PdfName.T, (PdfObject)t.getPdfObject());
    }

    public static PdfTargetDictionary createParentTarget() {
        return new PdfTargetDictionary(PdfName.P);
    }

    public static PdfTargetDictionary createChildTarget(String embeddedFileName) {
        return new PdfTargetDictionary(PdfName.C).put(PdfName.N, new PdfString(embeddedFileName));
    }

    public static PdfTargetDictionary createChildTarget(String namedDestination, String annotationIdentifier) {
        return new PdfTargetDictionary(PdfName.C).put(PdfName.P, new PdfString(namedDestination)).put(PdfName.A, new PdfString(annotationIdentifier));
    }

    public static PdfTargetDictionary createChildTarget(int pageNumber, int annotationIndex) {
        return new PdfTargetDictionary(PdfName.C).put(PdfName.P, new PdfNumber(pageNumber - 1)).put(PdfName.A, new PdfNumber(annotationIndex));
    }

    public PdfTargetDictionary setName(String name) {
        return this.put(PdfName.N, new PdfString(name));
    }

    public PdfString getName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.N);
    }

    public PdfTargetDictionary setPage(int pageNumber) {
        return this.put(PdfName.P, new PdfNumber(pageNumber - 1));
    }

    public PdfTargetDictionary setPage(String namedDestination) {
        return this.put(PdfName.P, new PdfString(namedDestination));
    }

    public PdfObject getPage() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.P);
    }

    public PdfTargetDictionary setAnnotation(int annotationIndex) {
        return this.put(PdfName.A, new PdfNumber(annotationIndex));
    }

    public PdfTargetDictionary setAnnotation(String annotationName) {
        return this.put(PdfName.A, new PdfString(annotationName));
    }

    public PdfObject getAnnotation() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.A);
    }

    public PdfTargetDictionary setTarget(PdfTargetDictionary target) {
        return this.put(PdfName.T, (PdfObject)target.getPdfObject());
    }

    public PdfTargetDictionary getTarget() {
        PdfDictionary targetDictObject = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.T);
        return targetDictObject != null ? new PdfTargetDictionary(targetDictObject) : null;
    }

    public PdfTargetDictionary put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

