/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.transaction.bean;

import cfca.paperless.base.transaction.bean.JSONFormatBean;
import cfca.paperless.base.transaction.bean.ResponseHeadBean;
import cfca.paperless.base.transaction.bean.TransactionResponse;
import cfca.paperless.base.util.JsonUtil;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessResult {
    private static final Logger logger = LoggerFactory.getLogger(ProcessResult.class);
    private byte[] jsonStrData;
    private List<byte[]> fileDataList;

    public ProcessResult() {
    }

    public ProcessResult(byte[] jsonStrData, List<byte[]> fileDataList) {
        this.jsonStrData = jsonStrData;
        this.fileDataList = fileDataList;
    }

    public ProcessResult(String transactionNo, String bodyJsonStr) throws Exception {
        Object bodyBean = JsonUtil.json2Obj(bodyJsonStr, Object.class);
        JSONFormatBean responseBean = new JSONFormatBean(new ResponseHeadBean(transactionNo), bodyBean);
        String jsonStrDataString = JsonUtil.obj2Json(responseBean);
        this.jsonStrData = jsonStrDataString.getBytes("UTF-8");
    }

    public ProcessResult(String transactionNo, String bodyJsonStr, List<byte[]> fileDataList) throws Exception {
        Object bodyBean = JsonUtil.json2Obj(bodyJsonStr, Object.class);
        JSONFormatBean responseBean = new JSONFormatBean(new ResponseHeadBean(transactionNo), bodyBean);
        String jsonStrDataString = JsonUtil.obj2Json(responseBean);
        this.jsonStrData = jsonStrDataString.getBytes("UTF-8");
        this.fileDataList = fileDataList;
        if (fileDataList != null && fileDataList.size() > 0) {
            int i = 1;
            for (byte[] pdfData : fileDataList) {
                logger.debug("response pdfData" + i++ + ":" + JsonUtil.obj2Json(pdfData));
            }
        }
    }

    public ProcessResult(String transactionNo) throws Exception {
        this(transactionNo, "");
    }

    public byte[] getJsonStrData() {
        return this.jsonStrData;
    }

    public void setJsonStrData(byte[] jsonStrData) {
        this.jsonStrData = jsonStrData;
    }

    public List<byte[]> getFileDataList() {
        return this.fileDataList;
    }

    public void setFileDataList(List<byte[]> fileDataList) {
        this.fileDataList = fileDataList;
    }

    public TransactionResponse toTransactionResponse() {
        TransactionResponse transactionResponse = new TransactionResponse();
        byte[] resultData = this.jsonStrData;
        int jsonLength = this.jsonStrData.length;
        String fileDataLengthGroup = "";
        if (this.fileDataList != null && this.fileDataList.size() > 0) {
            for (int i = 0; i < this.fileDataList.size(); ++i) {
                byte[] fileData = this.fileDataList.get(i);
                if (fileData == null) continue;
                fileDataLengthGroup = i == 0 ? "" + fileData.length : fileDataLengthGroup + "||" + fileData.length;
                resultData = ArrayUtils.addAll((byte[])resultData, (byte[])fileData);
            }
        }
        transactionResponse.setResult(resultData);
        transactionResponse.setJsonLength(String.valueOf(jsonLength));
        transactionResponse.setFileDataLength(fileDataLengthGroup);
        return transactionResponse;
    }
}

