/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.StringUtil;
import cfca.paperless.client.util.CheckPdfUtil;
import cfca.paperless.client.util.PdfVerifyUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.CertBean;
import cfca.paperless.dto.request.requestbody.tx40.VerifyPdfSealRequestBody;
import cfca.paperless.dto.request.tx40.VerifyPdfSealRequest;
import cfca.paperless.dto.response.responsebody.tx40.VerifyPdfSealResponseBody;
import cfca.paperless.dto.response.tx40.VerifyPdfSealResponse;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.base.bean.sign.VerifyInfo;
import cfca.sadk.seal.base.util.DateFormatUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.util.VerifyUtil;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPdfSealProcess {
    private static final Logger logger = LoggerFactory.getLogger(VerifyPdfSealProcess.class);
    public static final BouncyCastleProvider provider = new BouncyCastleProvider();

    public VerifyPdfSealResponse process(VerifyPdfSealRequest requestBean) throws Exception {
        long start = System.currentTimeMillis();
        Security.addProvider((Provider)provider);
        logger.info("VerifyPdfSealProcess.process start.");
        VerifyPdfSealRequestBody requestBody = requestBean.getBody();
        byte[] pdfData = new byte[]{};
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            throw new Exception("invalid inputType");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception("inputSource is null");
            }
            pdfData = FileUtils.readFileToByteArray((File)new File(requestBody.getInputSource()));
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                throw new Exception("pdfData is null");
            }
            pdfData = requestBody.getPdfData();
        }
        CheckPdfUtil.checkPdfData(pdfData, false);
        int pageCount = PDFUtil.getPageNums((byte[])pdfData);
        logger.info("PDF\u6587\u4ef6\u9875\u6570\uff1a" + pageCount);
        int sealVerifyType = Integer.parseInt(requestBody.getSealVerifyType());
        SealVerifyResult verifyResult = VerifyUtil.verify((byte[])pdfData);
        ArrayList<String> sigNames = new ArrayList<String>();
        ArrayList<X509Certificate> x509CertList = new ArrayList<X509Certificate>();
        if (verifyResult.getVerifyResult()) {
            HashMap verifyInfos = verifyResult.getVerifyInfos();
            for (String key : verifyInfos.keySet()) {
                VerifyInfo verifyInfo = (VerifyInfo)verifyInfos.get(key);
                sigNames.add(verifyInfo.getSignatureName());
                x509CertList.add(verifyInfo.getX509Certificate());
            }
        } else {
            throw new Exception("pdf verify error");
        }
        if (sigNames.size() == 0) {
            throw new Exception("no seal error");
        }
        logger.info("PDF\u6587\u6863\u5305\u542b\u8bc1\u4e66\u6570\u91cf" + x509CertList.size());
        PdfVerifyUtil.verifyPdfSeal(pdfData, sealVerifyType);
        ArrayList<CertBean> certBeans = new ArrayList<CertBean>();
        for (X509Certificate x509Cert : x509CertList) {
            String serialNo = x509Cert.getSerialNumber().toString();
            String dn = x509Cert.getSubjectDN().toString();
            String issuerDn = x509Cert.getIssuerDN().toString();
            CertBean certBean = new CertBean();
            certBean.setDn(dn);
            certBean.setIssuerDn(issuerDn);
            certBean.setSerialNo(serialNo);
            DateFormatUtil format = new DateFormatUtil();
            certBean.setNotBefore(format.getDateString(x509Cert.getNotBefore()));
            certBean.setNotAfter(format.getDateString(x509Cert.getNotAfter()));
            certBeans.add(certBean);
        }
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        VerifyPdfSealResponseBody body = new VerifyPdfSealResponseBody();
        body.setCertBeans(certBeans);
        VerifyPdfSealResponse responseBean = new VerifyPdfSealResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("VerifyPdfSealProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

