/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.subsetter;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat12;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat4;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.com.google.typography.font.tools.subsetter.CMapTableBuilder;
import cfca.com.google.typography.font.tools.subsetter.Subsetter;
import cfca.com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RenumberingCMapTableSubsetter
extends TableSubsetterImpl {
    public RenumberingCMapTableSubsetter() {
        super(Tag.cmap);
    }

    private static CMapFormat4 getCMapFormat4(Font font) {
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        for (CMap cmap : cmapTable) {
            if (cmap.format() != CMap.CMapFormat.Format4.value()) continue;
            return (CMapFormat4)cmap;
        }
        return null;
    }

    private static CMapFormat12 getCMapFormat12(Font font) {
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        for (CMap cmap : cmapTable) {
            if (cmap.format() != CMap.CMapFormat.Format12.value()) continue;
            return (CMapFormat12)cmap;
        }
        return null;
    }

    static Map<Integer, Integer> computeMapping(Subsetter subsetter, Font font) {
        int glyph;
        CMapFormat4 cmap4 = RenumberingCMapTableSubsetter.getCMapFormat4(font);
        CMapFormat12 cmap12 = RenumberingCMapTableSubsetter.getCMapFormat12(font);
        if (cmap4 == null && cmap12 == null) {
            throw new RuntimeException("CMap format 4 and 12 tables in source font both not found");
        }
        Map<Integer, Integer> inverseMapping = subsetter.getInverseMapping();
        HashMap<Integer, Integer> finishedMapping = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        if (cmap4 != null) {
            for (Integer unicode : cmap4) {
                glyph = cmap4.glyphId(unicode);
                if (!inverseMapping.containsKey(glyph)) continue;
                mapping.put(unicode, inverseMapping.get(glyph));
                finishedMapping.put(inverseMapping.get(glyph), unicode);
            }
        }
        if (cmap12 != null && inverseMapping.size() != finishedMapping.size()) {
            for (Integer unicode : cmap12) {
                glyph = cmap12.glyphId(unicode);
                if (!inverseMapping.containsKey(glyph)) continue;
                mapping.put(unicode, inverseMapping.get(glyph));
                finishedMapping.put(inverseMapping.get(glyph), unicode);
            }
        }
        return mapping;
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder fontBuilder) throws IOException {
        CMapTableBuilder cmapBuilder = new CMapTableBuilder(fontBuilder, RenumberingCMapTableSubsetter.computeMapping(subsetter, font));
        cmapBuilder.build();
        return true;
    }
}

