/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.awt.geom;

import cfca.com.itextpdf.awt.geom.misc.HashCode;

public abstract class Point2D
implements Cloneable {
    protected Point2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    public void setLocation(Point2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    public static double distanceSq(double x1, double y1, double x2, double y2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2;
    }

    public double distanceSq(double px, double py) {
        return Point2D.distanceSq(this.getX(), this.getY(), px, py);
    }

    public double distanceSq(Point2D p) {
        return Point2D.distanceSq(this.getX(), this.getY(), p.getX(), p.getY());
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Point2D.distanceSq(x1, y1, x2, y2));
    }

    public double distance(double px, double py) {
        return Math.sqrt(this.distanceSq(px, py));
    }

    public double distance(Point2D p) {
        return Math.sqrt(this.distanceSq(p));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.getX());
        hash.append(this.getY());
        return hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point2D) {
            Point2D p = (Point2D)obj;
            return this.getX() == p.getX() && this.getY() == p.getY();
        }
        return false;
    }

    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
        }

        public Double(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
        }
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public void setLocation(double x, double y) {
            this.x = (float)x;
            this.y = (float)y;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
        }
    }
}

