/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.truetype;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.SubTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.SimpleGlyph;

public abstract class Glyph
extends SubTable {
    protected volatile boolean initialized = false;
    protected final Object initializationLock = new Object();
    private final GlyphType glyphType;
    private final int numberOfContours;

    protected Glyph(ReadableFontData data, GlyphType glyphType) {
        super(data);
        this.glyphType = glyphType;
        this.numberOfContours = this.data.length() == 0 ? 0 : this.data.readShort(GlyphTable.Offset.numberOfContours.offset);
    }

    protected Glyph(ReadableFontData data, int offset, int length, GlyphType glyphType) {
        super(data, offset, length);
        this.glyphType = glyphType;
        this.numberOfContours = this.data.length() == 0 ? 0 : this.data.readShort(GlyphTable.Offset.numberOfContours.offset);
    }

    private static GlyphType glyphType(ReadableFontData data, int offset, int length) {
        if (offset > data.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return GlyphType.Simple;
        }
        int numberOfContours = data.readShort(offset);
        if (numberOfContours >= 0) {
            return GlyphType.Simple;
        }
        return GlyphType.Composite;
    }

    static Glyph getGlyph(GlyphTable table, ReadableFontData data, int offset, int length) {
        GlyphType type = Glyph.glyphType(data, offset, length);
        if (type == GlyphType.Simple) {
            return new SimpleGlyph(data, offset, length);
        }
        return new CompositeGlyph(data, offset, length);
    }

    protected abstract void initialize();

    @Override
    public int padding() {
        this.initialize();
        return super.padding();
    }

    public GlyphType glyphType() {
        return this.glyphType;
    }

    public int numberOfContours() {
        return this.numberOfContours;
    }

    public int xMin() {
        return this.data.readShort(GlyphTable.Offset.xMin.offset);
    }

    public int xMax() {
        return this.data.readShort(GlyphTable.Offset.xMax.offset);
    }

    public int yMin() {
        return this.data.readShort(GlyphTable.Offset.yMin.offset);
    }

    public int yMax() {
        return this.data.readShort(GlyphTable.Offset.yMax.offset);
    }

    public abstract int instructionSize();

    public abstract ReadableFontData instructions();

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int length) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.glyphType());
        sb.append(", contours=");
        sb.append(this.numberOfContours());
        sb.append(", [xmin=");
        sb.append(this.xMin());
        sb.append(", ymin=");
        sb.append(this.yMin());
        sb.append(", xmax=");
        sb.append(this.xMax());
        sb.append(", ymax=");
        sb.append(this.yMax());
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }

    public static abstract class Builder<T extends Glyph>
    extends SubTable.Builder<T> {
        protected int format;

        protected Builder(WritableFontData data) {
            super(data);
        }

        protected Builder(ReadableFontData data) {
            super(data);
        }

        protected Builder(WritableFontData data, int offset, int length) {
            this(data.slice(offset, length));
        }

        static Builder<? extends Glyph> getBuilder(GlyphTable.Builder tableBuilder, ReadableFontData data) {
            return Builder.getBuilder(tableBuilder, data, 0, data.length());
        }

        static Builder<? extends Glyph> getBuilder(GlyphTable.Builder tableBuilder, ReadableFontData data, int offset, int length) {
            GlyphType type = Glyph.glyphType(data, offset, length);
            if (type == GlyphType.Simple) {
                return new SimpleGlyph.SimpleGlyphBuilder(data, offset, length);
            }
            return new CompositeGlyph.CompositeGlyphBuilder(data, offset, length);
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return this.internalReadData().length();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            return this.internalReadData().copyTo(newData);
        }
    }

    public static abstract class Contour {
        protected Contour() {
        }
    }

    public static enum GlyphType {
        Simple,
        Composite;

    }
}

