/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.ofd.base.asn1.SES_SealInfo;
import cfca.sadk.ofd.base.asn1.SES_SignInfo;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class SESeal
extends ASN1Object
implements PKCSObjectIdentifiers {
    private SES_SealInfo esealInfo;
    private SES_SignInfo signInfo;
    private ASN1ObjectIdentifier signatureAlgorithm;
    private DERBitString signature;
    private ASN1OctetString cert;

    public static SESeal getInstance(Object o) {
        if (null != o) {
            if (o instanceof SESeal) {
                return (SESeal)((Object)o);
            }
            if (o instanceof ASN1Sequence) {
                return new SESeal(ASN1Sequence.getInstance((Object)o));
            }
            if (o instanceof byte[]) {
                return new SESeal(ASN1Sequence.getInstance((Object)o));
            }
        }
        return null;
    }

    public SESeal(SES_SealInfo esealInfo, SES_SignInfo signInfo) {
        this.esealInfo = esealInfo;
        this.signInfo = signInfo;
    }

    public SESeal(ASN1Sequence instance) {
        Enumeration e = instance.getObjects();
        this.esealInfo = SES_SealInfo.getInstance(e.nextElement());
        Object signElement = e.nextElement();
        if (signElement instanceof ASN1Sequence) {
            this.signInfo = SES_SignInfo.getInstance(signElement);
        } else {
            this.cert = ASN1OctetString.getInstance(signElement);
            this.signatureAlgorithm = ASN1ObjectIdentifier.getInstance(e.nextElement());
            this.signature = DERBitString.getInstance(e.nextElement());
        }
    }

    public SES_SealInfo getEsealInfo() {
        return this.esealInfo;
    }

    public void setEsealInfo(SES_SealInfo esealInfo) {
        this.esealInfo = esealInfo;
    }

    public SES_SignInfo getSignInfo() {
        return this.signInfo;
    }

    public void setSignInfo(SES_SignInfo signInfo) {
        this.signInfo = signInfo;
    }

    public ASN1ObjectIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DERBitString getSignature() {
        return this.signature;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public void setCert(ASN1OctetString cert) {
        this.cert = cert;
    }

    public void setSignatureAlgorithm(ASN1ObjectIdentifier signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setSignature(DERBitString signature) {
        this.signature = signature;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.esealInfo);
        if (null == this.signInfo) {
            v.add((ASN1Encodable)this.cert);
            v.add((ASN1Encodable)this.signatureAlgorithm);
            v.add((ASN1Encodable)this.signature);
        } else {
            v.add((ASN1Encodable)this.signInfo);
        }
        return new DERSequence(v);
    }
}

