/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font;

import cfca.sadk.com.itextpdf.io.IOException;
import cfca.sadk.com.itextpdf.io.font.CidFont;
import cfca.sadk.com.itextpdf.io.font.FontCache;
import cfca.sadk.com.itextpdf.io.font.FontCacheKey;
import cfca.sadk.com.itextpdf.io.font.FontConstants;
import cfca.sadk.com.itextpdf.io.font.FontProgram;
import cfca.sadk.com.itextpdf.io.font.FontProgramDescriptor;
import cfca.sadk.com.itextpdf.io.font.FontProgramFactory;
import cfca.sadk.com.itextpdf.io.font.OpenTypeParser;
import cfca.sadk.com.itextpdf.io.font.Type1Font;
import cfca.sadk.com.itextpdf.io.font.WoffConverter;
import cfca.sadk.com.itextpdf.io.font.woff2.Woff2Converter;

public final class FontProgramDescriptorFactory {
    private static boolean FETCH_CACHED_FIRST = true;

    public static FontProgramDescriptor fetchDescriptor(String fontName) {
        if (fontName == null || fontName.length() == 0) {
            return null;
        }
        String baseName = FontProgram.getBaseName(fontName);
        boolean isBuiltinFonts14 = FontConstants.BUILTIN_FONTS_14.contains(fontName);
        boolean isCidFont = !isBuiltinFonts14 && FontCache.isPredefinedCidFont(baseName);
        FontProgramDescriptor fontDescriptor = null;
        if (FETCH_CACHED_FIRST && (fontDescriptor = FontProgramDescriptorFactory.fetchCachedDescriptor(fontName, null)) != null) {
            return fontDescriptor;
        }
        try {
            String fontNameLowerCase = baseName.toLowerCase();
            if (isBuiltinFonts14 || fontNameLowerCase.endsWith(".afm") || fontNameLowerCase.endsWith(".pfm")) {
                fontDescriptor = FontProgramDescriptorFactory.fetchType1FontDescriptor(fontName, null);
            } else if (isCidFont) {
                fontDescriptor = FontProgramDescriptorFactory.fetchCidFontDescriptor(fontName);
            } else if (fontNameLowerCase.endsWith(".ttf") || fontNameLowerCase.endsWith(".otf")) {
                fontDescriptor = FontProgramDescriptorFactory.fetchTrueTypeFontDescriptor(fontName);
            } else if (fontNameLowerCase.endsWith(".woff") || fontNameLowerCase.endsWith(".woff2")) {
                byte[] fontProgram = fontNameLowerCase.endsWith(".woff") ? WoffConverter.convert(FontProgramFactory.readFontBytesFromPath(baseName)) : Woff2Converter.convert(FontProgramFactory.readFontBytesFromPath(baseName));
                fontDescriptor = FontProgramDescriptorFactory.fetchTrueTypeFontDescriptor(fontProgram);
            } else {
                fontDescriptor = FontProgramDescriptorFactory.fetchTTCDescriptor(baseName);
            }
        }
        catch (Exception ignored) {
            fontDescriptor = null;
        }
        return fontDescriptor;
    }

    public static FontProgramDescriptor fetchDescriptor(byte[] fontProgram) {
        if (fontProgram == null || fontProgram.length == 0) {
            return null;
        }
        FontProgramDescriptor fontDescriptor = null;
        if (FETCH_CACHED_FIRST && (fontDescriptor = FontProgramDescriptorFactory.fetchCachedDescriptor(null, fontProgram)) != null) {
            return fontDescriptor;
        }
        try {
            fontDescriptor = FontProgramDescriptorFactory.fetchTrueTypeFontDescriptor(fontProgram);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fontDescriptor == null) {
            try {
                fontDescriptor = FontProgramDescriptorFactory.fetchType1FontDescriptor(null, fontProgram);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fontDescriptor;
    }

    public static FontProgramDescriptor fetchDescriptor(FontProgram fontProgram) {
        return FontProgramDescriptorFactory.fetchDescriptorFromFontProgram(fontProgram);
    }

    private static FontProgramDescriptor fetchCachedDescriptor(String fontName, byte[] fontProgram) {
        FontCacheKey key = fontName != null ? FontCacheKey.create(fontName) : FontCacheKey.create(fontProgram);
        FontProgram fontFound = FontCache.getFont(key);
        return fontFound != null ? FontProgramDescriptorFactory.fetchDescriptorFromFontProgram(fontFound) : null;
    }

    private static FontProgramDescriptor fetchTTCDescriptor(String baseName) throws Exception {
        int ttcSplit = baseName.toLowerCase().indexOf(".ttc,");
        if (ttcSplit > 0) {
            int ttcIndex;
            String ttcName;
            try {
                ttcName = baseName.substring(0, ttcSplit + 4);
                ttcIndex = Integer.parseInt(baseName.substring(ttcSplit + 5));
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe.getMessage(), nfe);
            }
            OpenTypeParser parser = new OpenTypeParser(ttcName, ttcIndex);
            FontProgramDescriptor descriptor = FontProgramDescriptorFactory.fetchOpenTypeFontDescriptor(parser);
            parser.close();
            return descriptor;
        }
        return null;
    }

    private static FontProgramDescriptor fetchTrueTypeFontDescriptor(String fontName) throws Exception {
        OpenTypeParser parser = new OpenTypeParser(fontName);
        return FontProgramDescriptorFactory.fetchOpenTypeFontDescriptor(parser);
    }

    private static FontProgramDescriptor fetchTrueTypeFontDescriptor(byte[] fontProgram) throws java.io.IOException {
        OpenTypeParser parser = new OpenTypeParser(fontProgram);
        return FontProgramDescriptorFactory.fetchOpenTypeFontDescriptor(parser);
    }

    private static FontProgramDescriptor fetchOpenTypeFontDescriptor(OpenTypeParser fontParser) throws java.io.IOException {
        fontParser.loadTables(false);
        return new FontProgramDescriptor(fontParser.getFontNames(), fontParser.getPostTable().italicAngle, fontParser.getPostTable().isFixedPitch);
    }

    private static FontProgramDescriptor fetchType1FontDescriptor(String fontName, byte[] afm) throws Exception {
        Type1Font fp = new Type1Font(fontName, null, afm, null);
        return new FontProgramDescriptor(fp.getFontNames(), fp.getFontMetrics());
    }

    private static FontProgramDescriptor fetchCidFontDescriptor(String fontName) {
        CidFont font = new CidFont(fontName, null);
        return new FontProgramDescriptor(font.getFontNames(), font.getFontMetrics());
    }

    private static FontProgramDescriptor fetchDescriptorFromFontProgram(FontProgram fontProgram) {
        return new FontProgramDescriptor(fontProgram.getFontNames(), fontProgram.getFontMetrics());
    }
}

