/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.sadk.com.itextpdf.kernel.geom.AffineTransform;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfXObject;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.renderers.IBranchSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBranchSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IBranchSvgNodeRenderer {
    private final List<ISvgNodeRenderer> children = new ArrayList<ISvgNodeRenderer>();

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfStream stream = new PdfStream();
            stream.put(PdfName.Type, PdfName.XObject);
            stream.put(PdfName.Subtype, PdfName.Form);
            PdfFormXObject xObject = (PdfFormXObject)PdfXObject.makeXObject(stream);
            PdfCanvas newCanvas = new PdfCanvas(xObject, context.getCurrentCanvas().getDocument());
            this.applyViewBox(context);
            stream.put(PdfName.BBox, new PdfArray(context.getCurrentViewPort()));
            context.pushCanvas(newCanvas);
            this.applyViewport(context);
            for (ISvgNodeRenderer child : this.getChildren()) {
                newCanvas.saveState();
                child.draw(context);
                newCanvas.restoreState();
            }
            this.cleanUp(context);
            context.getCurrentCanvas().addXObject(xObject, 0.0f, 0.0f);
        }
    }

    private void applyViewBox(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("viewbox")) {
            AffineTransform transform;
            float scaleHeight;
            Rectangle currentViewPort;
            float scaleWidth;
            AffineTransform scale;
            String viewBoxValues = (String)this.attributesAndStyles.get("viewbox");
            List<String> valueStrings = SvgCssUtils.splitValueList(viewBoxValues);
            float[] values = new float[valueStrings.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = CssUtils.parseAbsoluteLength(valueStrings.get(i));
            }
            if (((String)this.attributesAndStyles.get("width")).contains("%") || ((String)this.attributesAndStyles.get("height")).contains("%")) {
                this.attributesAndStyles.put("width", valueStrings.get(2));
                this.attributesAndStyles.put("height", valueStrings.get(3));
                this.setAttributesAndStyles(this.attributesAndStyles);
            }
            if (!(scale = AffineTransform.getScaleInstance(scaleWidth = (currentViewPort = context.getCurrentViewPort()).getWidth() / values[2], scaleHeight = currentViewPort.getHeight() / values[3])).isIdentity()) {
                context.getCurrentCanvas().concatMatrix(scale);
                context.getCurrentViewPort().setWidth(currentViewPort.getWidth() / scaleWidth);
                context.getCurrentViewPort().setX(currentViewPort.getX() / scaleWidth);
                context.getCurrentViewPort().setHeight(currentViewPort.getHeight() / scaleHeight);
                context.getCurrentViewPort().setY(currentViewPort.getY() / scaleHeight);
            }
            if (!(transform = this.processAspectRatio(context, values)).isIdentity()) {
                context.getCurrentCanvas().writeLiteral("% applying viewbox aspect ratio correction (not correct) \n");
            }
        }
    }

    private void applyViewport(SvgDrawContext context) {
        if (this.getParent() != null && this.getParent() instanceof AbstractSvgNodeRenderer) {
            AbstractSvgNodeRenderer parent = (AbstractSvgNodeRenderer)this.getParent();
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            currentCanvas.rectangle(context.getCurrentViewPort());
            currentCanvas.clip();
            currentCanvas.endPath();
            if (parent.canConstructViewPort()) {
                currentCanvas.concatMatrix(parent.calculateViewPortTranslation(context));
            }
        }
    }

    private AffineTransform processAspectRatio(SvgDrawContext context, float[] viewBoxValues) {
        AffineTransform transform = new AffineTransform();
        if (this.attributesAndStyles.containsKey("preserveaspectratio")) {
            Rectangle currentViewPort = context.getCurrentViewPort();
            String preserveAspectRatioValue = (String)this.attributesAndStyles.get("preserveaspectratio");
            List<String> values = SvgCssUtils.splitValueList(preserveAspectRatioValue);
            if ("defer".equalsIgnoreCase(values.get(0))) {
                values.remove(0);
            }
            String align = values.get(0);
            float x = 0.0f;
            float y = 0.0f;
            float midXBox = viewBoxValues[0] + viewBoxValues[2] / 2.0f;
            float midYBox = viewBoxValues[1] + viewBoxValues[3] / 2.0f;
            float midXPort = currentViewPort.getX() + currentViewPort.getWidth() / 2.0f;
            float midYPort = currentViewPort.getY() + currentViewPort.getHeight() / 2.0f;
            String alignString = align.toLowerCase();
            if (!"none".equals(alignString)) {
                if ("xminymin".equals(alignString)) {
                    x = -viewBoxValues[0];
                    y = -viewBoxValues[1];
                } else if ("xminymid".equals(alignString)) {
                    x = -viewBoxValues[0];
                    y = midYPort - midYBox;
                } else if ("xminymax".equals(alignString)) {
                    x = -viewBoxValues[0];
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                } else if ("xmidymin".equals(alignString)) {
                    x = midXPort - midXBox;
                    y = -viewBoxValues[1];
                } else if ("xmidymax".equals(alignString)) {
                    x = midXPort - midXBox;
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                } else if ("xmaxymin".equals(alignString)) {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = -viewBoxValues[1];
                } else if ("xmaxymid".equals(alignString)) {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = midYPort - midYBox;
                } else if ("xmaxymax".equals(alignString)) {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                } else if ("xmidymid".equals(alignString)) {
                    x = midXPort - midXBox;
                    y = midYPort - midYBox;
                } else {
                    x = midXPort - midXBox;
                    y = midYPort - midYBox;
                }
            }
            transform.translate(x, y);
        }
        return transform;
    }

    private void cleanUp(SvgDrawContext context) {
        if (this.getParent() != null) {
            context.removeCurrentViewPort();
        }
        context.popCanvas();
    }

    @Override
    public final void addChild(ISvgNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public final List<ISvgNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected final void deepCopyChildren(AbstractBranchSvgNodeRenderer deepCopy) {
        for (ISvgNodeRenderer child : this.children) {
            ISvgNodeRenderer newChild = child.createDeepCopy();
            child.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    @Override
    void postDraw(SvgDrawContext context) {
    }

    @Override
    public abstract ISvgNodeRenderer createDeepCopy();

    @Override
    void setPartOfClipPath(boolean isPart) {
        super.setPartOfClipPath(isPart);
        for (ISvgNodeRenderer child : this.children) {
            if (!(child instanceof AbstractSvgNodeRenderer)) continue;
            ((AbstractSvgNodeRenderer)child).setPartOfClipPath(isPart);
        }
    }
}

