/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.graphics.custom.commbank;

import cfca.integration.uarc.graphics.UArcGraphics;
import cfca.integration.uarc.graphics.UArcRectangle;
import cfca.integration.uarc.graphics.UArcText;
import cfca.integration.uarc.graphics.custom.commbank.ParagraphText;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import sun.font.FontDesignMetrics;

public class UArcClause {
    private OutputStream os;
    ArrayList<ParagraphText> paragraphTextList = new ArrayList();
    ArrayList<Integer> paragraphAfterList = new ArrayList();
    ArrayList<Integer> paragraphBeforeList = new ArrayList();

    public UArcClause(OutputStream os) {
        this.os = os;
    }

    public void addParagraphText(String text, Font font, Color color, int charsPerLine, int lineSpacing, int gap, int leftgap, boolean center) {
        ParagraphText lineText = new ParagraphText(text, font, color, charsPerLine, lineSpacing, gap, leftgap, center);
        this.paragraphTextList.add(lineText);
    }

    public void addParagraphBefore(int paragraphBefore) {
        this.paragraphBeforeList.add(paragraphBefore);
    }

    public void addParagraphAfter(int paragraphAfter) {
        this.paragraphAfterList.add(paragraphAfter);
    }

    public void close() {
        int size = this.paragraphTextList.size();
        block0: for (int i = 0; i < size; ++i) {
            int len;
            ParagraphText paragraphText = this.paragraphTextList.get(i);
            String text = paragraphText.text;
            int charsPerLine = paragraphText.charsPerLine;
            int leftlen = len = text.length();
            int lines = text.length() / charsPerLine + 1;
            String[] texts = new String[lines];
            for (int j = 0; j < lines; ++j) {
                texts[j] = text.substring(j * charsPerLine, j * charsPerLine + charsPerLine);
                if ((leftlen -= charsPerLine) >= charsPerLine) continue;
                texts[j + 1] = text.substring((j + 1) * charsPerLine);
                continue block0;
            }
        }
    }

    void lineTextOnRectangeForCommBank(String text, int charsPerLine, Font font, Color color, int gap, int leftgap, boolean center, OutputStream os) throws IOException {
        int len;
        int leftlen = len = text.length();
        int lines = text.length() / charsPerLine + 1;
        String[] texts = new String[lines];
        for (int i = 0; i < lines; ++i) {
            texts[i] = text.substring(i * charsPerLine, i * charsPerLine + charsPerLine);
            if ((leftlen -= charsPerLine) >= charsPerLine) continue;
            texts[i + 1] = text.substring((i + 1) * charsPerLine);
            break;
        }
        this.lineTextOnRectangleForCommBank(texts, font, color, gap, leftgap, center, os);
    }

    void lineTextOnRectangleForCommBank(String[] texts, Font font, Color color, int gap, int leftgap, boolean center, OutputStream os) throws IOException {
        FontDesignMetrics fm = FontDesignMetrics.getMetrics(font);
        int height = 0;
        int maxStringWidth = 0;
        int stringHeight = 0;
        int maxGapsWidth = 0;
        int linespacing = font.getSize();
        int len = texts.length;
        stringHeight = fm.getHeight();
        for (int i = 0; i < len; ++i) {
            String text = texts[i];
            int numOfGaps = text.length() - 1;
            maxGapsWidth = Math.max(maxGapsWidth, gap * numOfGaps);
            maxStringWidth = Math.max(maxStringWidth, fm.stringWidth(text));
            height += stringHeight;
            if (len - i <= 1) continue;
        }
        int margin = 10;
        int width = maxStringWidth + maxGapsWidth + leftgap;
        UArcGraphics uag = new UArcGraphics(0, 0, width + margin * 2, height + margin * 2, Color.WHITE, 1.0f);
        uag.begin();
        UArcRectangle uar = new UArcRectangle(margin, margin, width, height, 2.0f, Color.RED, 1.0f);
        uag.draw(uar);
        for (int i = 0; i < len; ++i) {
            String text0 = texts[i];
            int len0 = text0.length();
            String[] textChars0 = new String[len0];
            for (int j = 0; j < len0; ++j) {
                char c = text0.charAt(j);
                textChars0[j] = String.valueOf(c);
            }
            UArcText uarcText0 = new UArcText(uar, textChars0, center, (double)(-(50 + i * linespacing)), 0.0, 1.0f, Color.RED, font, gap, leftgap);
            uag.draw(uarcText0);
        }
        uag.end();
        uag.write("png", os);
    }
}

