/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.seal;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.bean.tpls.Area;
import cfca.sadk.ofd.base.bean.tpls.Content;
import cfca.sadk.ofd.base.bean.tpls.Layer;
import cfca.sadk.ofd.base.bean.tpls.Page;
import cfca.sadk.ofd.base.common.Dom4jUtil;
import cfca.sadk.ofd.base.common.JaxbUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.common.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class TemplateXMLUtil {
    private static Logger businessLog = LoggerFactory.getLogger(TemplateXMLUtil.class);

    public static void generateTemplate(Map<String, byte[]> filesMap, BigInteger id, String filePath) throws Exception {
        try {
            Page page = new Page();
            Area area = new Area();
            area.setPhysicalBox("0.00 0.00 210.01 297.00");
            page.setArea(area);
            Content content = new Content();
            Layer layer = new Layer();
            layer.setID(id);
            layer.setType("Foreground");
            content.setLayer(layer);
            page.setContent(content);
            ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
            JaxbUtil.toXML(page, ofdStream);
            filesMap.put(filePath, ofdStream.toByteArray());
        }
        catch (IOException e) {
            businessLog.error("generateTemplate failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("generateTemplate failed", (Throwable)e);
            throw e;
        }
    }

    public static String addTmpltoDoc(Map<String, byte[]> filesMap, String baseDir, BigInteger tmplID, String baseLoc) throws DocumentException, IOException {
        String tplsName = baseDir + "Tpls/Tpl_0/Content.xml";
        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(baseDir + "Document.xml")));
        Element body = document.getRootElement();
        Element commonData = body.element("CommonData");
        List templateList = commonData.elements("TemplatePage");
        if (templateList != null && !templateList.isEmpty()) {
            int maxID = 0;
            for (int i = 0; i < templateList.size(); ++i) {
                Element oneTpl = (Element)templateList.get(i);
                String oneBaseLoc = oneTpl.attributeValue("BaseLoc");
                String[] items = oneBaseLoc.split("/");
                String count = items[items.length - 2];
                int nextCounter = StringUtil.getSingleNum(count);
                if (maxID >= nextCounter) continue;
                tplsName = oneBaseLoc.replace(nextCounter + "/" + "Content", nextCounter + 1 + "/" + "Content");
                maxID = nextCounter;
            }
        }
        Element attaElement = commonData.addElement("ofd:TemplatePage");
        attaElement.addAttribute("ID", tmplID.toString());
        attaElement.addAttribute("BaseLoc", tplsName.replace(baseDir, ""));
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(baseDir + "Document.xml", ofdStream.toByteArray());
        if (tplsName.startsWith("/")) {
            tplsName = tplsName.substring(1);
        }
        return tplsName;
    }

    public static void addTmpltoPage(Map<String, byte[]> filesMap, String baseDir, BigInteger tmplID, int pageNum) throws DocumentException, IOException {
        String pageRefName = baseDir + "Pages/Page_" + (pageNum - 1) + "/Content.xml";
        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(pageRefName)));
        Element body = document.getRootElement();
        Element tmplRef = body.addElement("ofd:Template");
        tmplRef.addAttribute("TemplateID", tmplID.toString());
        tmplRef.addAttribute("ZOrder", "Foreground");
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(pageRefName, ofdStream.toByteArray());
    }
}

