/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.format;

import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECCFormatKey {
    public static final String ECC_KEY = "ECDSA";

    private ECCFormatKey() {
    }

    public static PublicKey convertToProviderECCPublicKey(Provider provider, PublicKey pubKey) throws Exception {
        PublicKey returnKey = pubKey;
        try {
            if (pubKey != null) {
                LoggerManager.debugLogger.debug("ECCHardPublicKey::::::::X509EncodedKeySpec: Running");
                KeyFactory kf = KeyFactory.getInstance(ECC_KEY, provider);
                X509EncodedKeySpec x509spec = new X509EncodedKeySpec(pubKey.getEncoded());
                returnKey = kf.generatePublic(x509spec);
                LoggerManager.debugLogger.debug("ECCHardPublicKey::::::::X509EncodedKeySpec: Finished");
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCHardPublicKey failure", (Throwable)e);
            throw new Exception("ECCHardPublicKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("ECCHardPublicKey failure", e);
            throw new Exception("ECCHardPublicKey failure", e);
        }
        return returnKey;
    }

    public static PrivateKey convertToProviderECCPrivateKey(Provider provider, PrivateKey privKey) throws Exception {
        PrivateKey returnKey = privKey;
        try {
            if (privKey != null) {
                LoggerManager.debugLogger.debug("ECCHardPrivateKey::::::::PKCS8EncodedKeySpec: Running");
                KeyFactory kf = KeyFactory.getInstance(ECC_KEY, provider);
                PKCS8EncodedKeySpec x509spec = new PKCS8EncodedKeySpec(privKey.getEncoded());
                returnKey = kf.generatePrivate(x509spec);
                LoggerManager.debugLogger.debug("ECCHardPrivateKey::::::::PKCS8EncodedKeySpec: Finished");
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCHardPrivateKey failure", (Throwable)e);
            throw new Exception("ECCHardPrivateKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("ECCHardPrivateKey failure", e);
            throw new Exception("ECCHardPrivateKey failure", e);
        }
        return returnKey;
    }

    public static void checkECCKey(PublicKey pubKey, int keyIndex, ECCCurveId curveId) throws Exception {
        ECPublicKey ecKey;
        int curveFieldLength;
        if (pubKey != null && curveId != null && pubKey instanceof ECPublicKey && (curveFieldLength = (ecKey = (ECPublicKey)pubKey).getParams().getCurve().getField().getFieldSize()) != curveId.getCurveBitLength()) {
            throw new IllegalArgumentException(String.format("ECC keyIndex=%d, theFieldSize=%d not match %s", new Object[]{keyIndex, curveFieldLength, curveId}));
        }
    }
}

