/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype.testing;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.FontFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FontLoader {
    public static List<File> getFontFiles(String fontDir) {
        ArrayList<File> fontFiles = new ArrayList<File>();
        FontLoader.getFontFiles(fontFiles, new File(fontDir), "", true);
        return fontFiles;
    }

    public static Font getFont(File fontFile) throws IOException {
        Font[] fonts = FontLoader.load(fontFile);
        if (fonts == null) {
            throw new IllegalArgumentException("No font found");
        }
        return fonts[0];
    }

    private static void getFontFiles(List<File> fonts, File dir, String startFrom, boolean foundStart) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.getName().endsWith(".ttf") && (foundStart || startFrom.endsWith(file.getName()))) {
                foundStart = true;
                fonts.add(file);
            }
            if (!file.isDirectory()) continue;
            FontLoader.getFontFiles(fonts, file, startFrom, foundStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font[] load(File file) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        fontFactory.fingerprintFont(true);
        FileInputStream is = new FileInputStream(file);
        try {
            Font[] fontArray = fontFactory.loadFonts(is);
            return fontArray;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not load the font : " + file.getName());
            Font[] fontArray = null;
            return fontArray;
        }
        finally {
            is.close();
        }
    }
}

