/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.decoder;

import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.PKCS7SignFileParser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.signature.decoder.AbstractPKCS7Decoder;
import cfca.sadk.signature.decoder.PKCS7ECCDecoder;
import cfca.sadk.signature.decoder.PKCS7RSADecoder;
import cfca.sadk.signature.decoder.PKCS7SM2Decoder;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;

public final class PKCS7DecodeFacade {
    final Session session;
    final SignedData signedData;
    final PKCS7SignFileParser signedFile;
    final String digestAlgorithm;
    final X509Cert signCert;
    final byte[] signValue;
    final AbstractPKCS7Decoder decoder;
    byte[] sourceData = null;

    public PKCS7DecodeFacade(Session session, byte[] signResult) throws PKIException {
        ASN1Sequence seq;
        Session session2 = this.session = session == null ? BCSoftLib.INSTANCE() : session;
        if (signResult == null || signResult.length == 0) {
            throw new PKIException("PKCS7SignedData encoding required not  be null");
        }
        if (signResult.length < 1) {
            throw new PKIException("PKCS7SignedData encoding required length>0");
        }
        byte[] encoding = signResult;
        if (signResult[0] == 77) {
            try {
                encoding = Base64.decode(signResult);
            }
            catch (Exception e) {
                throw new PKIException("PKCS7SignedData encoding with invalid base64", e);
            }
        }
        try {
            seq = ASN1Sequence.getInstance(encoding);
        }
        catch (Exception e) {
            throw new PKIException("PKCS7SignedData encoding with invalid asn1-encoding", e);
        }
        SignedData signedData = null;
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            signedData = SignedData.getInstance(contentInfo.getContent());
        }
        catch (Exception e) {
            throw new PKIException("PKCS7SignedData encoding with invalid signedData-encoding", e);
        }
        X509Cert signCert = this.getFirstSignerCert(signedData, null);
        AbstractPKCS7Decoder decoder = null;
        if (signCert.isSM2Cert()) {
            decoder = new PKCS7SM2Decoder(session, signedData, true);
        } else if (signCert.isRSACert()) {
            decoder = new PKCS7RSADecoder(session, signedData, false);
        } else if (signCert.isECCCert()) {
            decoder = new PKCS7ECCDecoder(session, signedData, false);
        } else {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, "PKCS7SignedData invalid signCertType");
        }
        this.signedData = signedData;
        this.signedFile = null;
        this.decoder = decoder;
        this.signValue = decoder.getSignValue();
        this.digestAlgorithm = decoder.getDigestAlgorithm();
        this.signCert = signCert;
    }

    public PKCS7DecodeFacade(Session session, String signFilePath) throws PKIException {
        PKCS7SignFileParser signedFile;
        Session session2 = this.session = session == null ? BCSoftLib.INSTANCE() : session;
        if (signFilePath == null) {
            throw new PKIException("PKCS7SignedFile signFilePath==null");
        }
        File signFile = new File(signFilePath);
        if (!signFile.exists()) {
            throw new PKIException("PKCS7SignedFile noexists: " + signFile.getAbsolutePath());
        }
        if (!signFile.isFile()) {
            throw new PKIException("PKCS7SignedFile is not file: " + signFile.getAbsolutePath());
        }
        try {
            signedFile = new PKCS7SignFileParser(signFile);
            signedFile.parser();
        }
        catch (Exception e) {
            throw new PKIException("PKCS7SignedFile is invalid", e);
        }
        X509Cert signCert = this.getFirstSignerCert(null, signedFile);
        AbstractPKCS7Decoder decoder = null;
        if (signCert.isSM2Cert()) {
            decoder = new PKCS7SM2Decoder(session, signedFile, true);
        } else if (signCert.isRSACert()) {
            decoder = new PKCS7RSADecoder(session, signedFile, false);
        } else if (signCert.isECCCert()) {
            decoder = new PKCS7ECCDecoder(session, signedFile, false);
        } else {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, "PKCS7SignedData invalid signCertType");
        }
        this.signedFile = signedFile;
        this.signedData = null;
        this.decoder = decoder;
        this.signValue = decoder.getSignValue();
        this.digestAlgorithm = decoder.getDigestAlgorithm();
        this.signCert = signCert;
    }

    public final SignedData getSignedData() {
        return this.signedData;
    }

    public final byte[] getSourceData() throws PKIException {
        if (this.sourceData == null && this.signedData != null) {
            ContentInfo contentInfo = this.signedData.getContentInfo();
            ASN1Encodable contentNode = contentInfo.getContent();
            if (contentNode == null) {
                throw new PKIException("no sourceData to be verify.");
            }
            byte[] sourceData = null;
            if (PKCS7DecodeFacade.isP7DataType(contentInfo.getContentType())) {
                sourceData = ((ASN1OctetString)contentNode).getOctets();
            } else {
                try {
                    sourceData = contentNode.toASN1Primitive().getEncoded();
                }
                catch (IOException e) {
                    throw new PKIException("sourceData obtain failed", e);
                }
            }
            this.sourceData = sourceData;
        }
        return this.sourceData;
    }

    private final X509Cert getFirstSignerCert(SignedData signedData, PKCS7SignFileParser signedFile) throws PKIException {
        ASN1Set signerCerts = null;
        ASN1Set signerInfos = null;
        if (signedData != null) {
            signerCerts = signedData.getCertificates();
            signerInfos = signedData.getSignerInfos();
        } else if (signedFile != null) {
            try {
                signerCerts = ASN1Set.getInstance(DERTaggedObject.getInstance(signedFile.getCertificate_node().getData()), false);
                signerInfos = ASN1Set.getInstance(signedFile.getSingerinfo_node().getData());
            }
            catch (Exception e) {
                throw new PKIException("PKCS7SignedFile decode signedData/signedFile failed");
            }
        } else {
            throw new PKIException("invalid signedData/signedFile");
        }
        if (signerCerts.size() == 0) {
            throw new PKIException("no signerCerts on signedData/signedFile");
        }
        if (signerInfos.size() == 0) {
            throw new PKIException("no signerInfos on signedData/signedFile");
        }
        ASN1Sequence signerInfo = ASN1Sequence.getInstance(signerInfos.getObjectAt(0));
        IssuerAndSerialNumber firstSignerIssuerAndSN = IssuerAndSerialNumber.getInstance(signerInfo.getObjectAt(1));
        X509Cert firstSignerCert = null;
        ArrayList<Certificate> certList = new ArrayList<Certificate>(signerCerts.size());
        int size = signerCerts.size();
        for (int i = 0; i < size; ++i) {
            Certificate cert = Certificate.getInstance(signerCerts.getObjectAt(i));
            IssuerAndSerialNumber certIssuerAndSN = new IssuerAndSerialNumber(cert.getIssuer(), cert.getSerialNumber().getPositiveValue());
            if (certIssuerAndSN.equals(firstSignerIssuerAndSN)) {
                firstSignerCert = new X509Cert(cert);
                break;
            }
            certList.add(cert);
        }
        if (firstSignerCert == null && certList.size() > 0) {
            BigInteger signerSN = firstSignerIssuerAndSN.getCertificateSerialNumber().getPositiveValue();
            for (Certificate cert : certList) {
                if (!signerSN.equals(cert.getSerialNumber().getPositiveValue())) continue;
                firstSignerCert = new X509Cert(cert);
                break;
            }
            if (firstSignerCert == null) {
                firstSignerCert = new X509Cert((Certificate)certList.get(0));
            }
        }
        if (firstSignerCert == null) {
            throw new PKIException("no signing cert on signedData/signedFile");
        }
        return firstSignerCert;
    }

    public final X509Cert getSignerX509Cert() throws PKIException {
        return this.signCert;
    }

    public byte[] getSignature() throws PKIException {
        return this.signValue;
    }

    public String getDigestAlgorithm() throws PKIException {
        return this.decoder.getDigestAlgorithm();
    }

    public final String getSignTime() throws PKIException {
        return this.decoder.getSignTime();
    }

    public final boolean verifyP7SignedDataAttach() throws PKIException {
        byte[] sourceData = this.getSourceData();
        return this.decoder.verifySignerInfo(sourceData, this.signCert);
    }

    public boolean verifyP7SignedData(InputStream sourceFileStream) throws PKIException {
        return this.decoder.verifySignerInfoByFile(sourceFileStream, this.signCert);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        return this.decoder.verifySignerInfo(sourceData, this.signCert);
    }

    public boolean verifyP7SignedDataByHash(byte[] sourceHash) throws PKIException {
        return this.decoder.verifySignerInfoByHash(sourceHash, this.signCert);
    }

    public final boolean verifyP7SignedFileAttach(String saveSrcFilePath) throws PKIException {
        return this.decoder.verifyP7SignedFile(saveSrcFilePath, this.signCert);
    }

    public static boolean isP7DataType(ASN1ObjectIdentifier contentType) {
        return PKCSObjectIdentifiers.data.equals(contentType) || PKCSObjectIdentifiers.sm2Data.equals(contentType) || PKCSObjectIdentifiers.id_ct_TSTInfo.equals(contentType);
    }
}

