/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.css;

import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.css.CssUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidthCalculator {
    private final CssUtils utils = CssUtils.getInstance();

    public float getWidth(Tag tag, List<String> roottags, float pagewidth) {
        float width = 0.0f;
        String widthValue = tag.getCSS().get("width");
        if (widthValue == null) {
            widthValue = tag.getAttributes().get("width");
        }
        if (widthValue != null) {
            if (this.utils.isNumericValue(widthValue) || this.utils.isMetricValue(widthValue)) {
                width = this.utils.parsePxInCmMmPcToPt(widthValue);
            } else if (this.utils.isRelativeValue(widthValue)) {
                Tag ancestor = tag;
                float firstAncestorsWidth = 0.0f;
                while (firstAncestorsWidth == 0.0f && ancestor.getParent() != null) {
                    ancestor = ancestor.getParent();
                    firstAncestorsWidth = this.getWidth(ancestor, roottags, pagewidth);
                }
                width = firstAncestorsWidth == 0.0f ? this.utils.parseRelativeValue(widthValue, pagewidth) : this.utils.parseRelativeValue(widthValue, firstAncestorsWidth);
            }
        } else if (roottags.contains(tag.getName())) {
            width = pagewidth;
        }
        return width;
    }
}

