/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.jni;

import cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;

final class PKCS1Encoding {
    private static int HEADER_LENGTH = 10;

    PKCS1Encoding() {
    }

    static byte[] addPKCS1Padding(byte[] srcData, RSAPublicKey pubKey) {
        int bitLen = pubKey.getModulus().bitLength();
        int blockLen = (bitLen + 7) / 8;
        byte[] block = new byte[blockLen];
        SecureRandom random = new SecureRandom();
        random.nextBytes(block);
        block[0] = 0;
        block[1] = 2;
        int inLen = srcData.length;
        for (int i = 2; i != block.length - inLen - 1; ++i) {
            while (block[i] == 0) {
                block[i] = (byte)random.nextInt();
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(srcData, 0, block, block.length - inLen, inLen);
        return block;
    }

    static byte[] delPKCS1Padding(byte[] paddingData) throws Exception {
        byte pad;
        int start;
        byte type = paddingData[1];
        if (type != 1 && type != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        for (start = 2; start != paddingData.length && (pad = paddingData[start]) != 0; ++start) {
            if (type != 1 || pad == -1) continue;
            throw new InvalidCipherTextException("block padding incorrect");
        }
        if (++start > paddingData.length || start < HEADER_LENGTH) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] result = new byte[paddingData.length - start];
        System.arraycopy(paddingData, start, result, 0, result.length);
        return result;
    }
}

