/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Boolean;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.tsp.TimeStampReq;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.timestamp.client.BusinessTrustCerts;
import cfca.sadk.timestamp.client.TSASignedData;
import cfca.sadk.timestamp.client.TimestampNonce;
import cfca.sadk.timestamp.client.TimestampUUID;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.api.TimestampClient;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.timestamp.client.bean.MessageImprint;
import cfca.sadk.timestamp.client.bean.TSARequestPolicy;
import cfca.sadk.timestamp.client.conf.TscLayeredConf;
import cfca.sadk.timestamp.client.conn.HTTPRequester;
import cfca.sadk.timestamp.client.env.DefaultSessionLib;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.socket.TscSSLContextManager;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.timestamp.exception.TSAHttpStatusInfoException;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import javax.net.ssl.SSLContext;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

final class StandardTimestampClient
implements TimestampClient {
    private static final String HTTP_SCHEMA = "http://";
    private static final int BUFFER_SIZE = 16384;
    private final BusinessTrustCerts trustCerts;
    private TSARequestPolicy timestampMode = TSARequestPolicy.HTTP_AUTH;
    private boolean requiredNonceOptional = true;
    private boolean requiredCertOptional = true;
    private HTTPRequester requester;
    private SSLContext timestampSSL;
    private int httpTimeout;
    private String httpAuthUsername = null;
    private String httpAuthpassword = null;
    private X509Cert signCert = null;
    private Session session;
    private boolean verifyTimestamp = true;
    final TimestampConfig config;

    StandardTimestampClient(TimestampConfig config, boolean testRunner) throws TSAException {
        TscLogging.SYSTEM_LOGGER.info("TimestampClient instance running...");
        if (config == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient missing parameter@timestampConfig");
            throw new TSAException(TSAErrorCode.timestampClientMissingConfig, "required parameter timestampConfig");
        }
        TscLogging.SYSTEM_LOGGER.info("TimestampClient config {}", (Object)config);
        try {
            this.trustCerts = new BusinessTrustCerts(config.getHttpAuthInfoConf());
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@BusinessTrustCerts failure: {}", (Object)config, (Object)e);
            throw e;
        }
        String timestampUrl = config.getCommonConf().getHttpURL();
        if (config.getCommonConf().isHttps()) {
            try {
                TscLayeredConf layeredConf = config.getSslLayeredConf();
                TscSSLContextManager tsc = TscSSLContextManager.buildTscSSLContextManager(layeredConf);
                this.timestampSSL = tsc.sslContextWithNotExpiredCert();
            }
            catch (TSAException e) {
                TscLogging.ERROR_LOGGER.error("TimestampClient@buildTLSContextManager failure: {}", (Object)config, (Object)e);
                throw e;
            }
            catch (Exception e) {
                TscLogging.ERROR_LOGGER.error("TimestampClient@buildTLSContextManager failure: {}", (Object)config, (Object)e);
                throw new TSAException(TSAErrorCode.timestampClientBuildRequestorFailure, "requestor build failure", (Throwable)e);
            }
        } else {
            this.timestampSSL = null;
        }
        this.httpTimeout = config.getHttpTimeout();
        this.setTimestampHttpAuthInfo(config.getHttpAuthInfoConf().getHttpAuthUsername(), config.getHttpAuthInfoConf().getHttpAuthPassword());
        if (config.getCommonConf().isHttpProxyEnable()) {
            this.setProxyIfValid(config, timestampUrl);
        } else {
            this.setTimestampURL(timestampUrl, this.timestampSSL);
        }
        TscLogging.SYSTEM_LOGGER.info("TimestampClient instance finished");
        this.session = DefaultSessionLib.SESSION;
        this.config = config;
    }

    private void setProxyIfValid(TimestampConfig config, String timestampUrl) throws TSAException {
        String httpProxyURL = config.getCommonConf().getHttpProxyURL();
        if (this.isProxyURLValid(httpProxyURL)) {
            Proxy proxy = this.buildProxy(httpProxyURL);
            this.setTimestampURL(timestampUrl, this.timestampSSL, proxy);
        } else {
            this.setTimestampURL(timestampUrl, this.timestampSSL);
        }
    }

    private Proxy buildProxy(String httpProxyURL) throws TSAException {
        int port;
        String hostname;
        TscLogging.SYSTEM_LOGGER.info("TimestampClient@buildProxy httpProxyURL:{}", (Object)httpProxyURL);
        String proxyName = httpProxyURL;
        if (!httpProxyURL.startsWith(HTTP_SCHEMA)) {
            proxyName = HTTP_SCHEMA + proxyName;
        }
        try {
            URL proxyURL = new URL(proxyName);
            hostname = proxyURL.getHost();
            port = proxyURL.getPort();
            if (port <= 0) {
                port = proxyURL.getDefaultPort();
            }
        }
        catch (Exception e) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@buildProxy invalid httpProxyURL: {}", (Object)httpProxyURL, (Object)e);
            throw new TSAException(TSAErrorCode.timestampClientBuildRequestorFailure, "httpProxyURL with invalid port", (Throwable)e);
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
    }

    private boolean isProxyURLValid(String httpProxyURL) {
        return !TextUtils.isBlank((CharSequence)httpProxyURL) && httpProxyURL.length() >= 3;
    }

    @Override
    public void setSignCert(X509Cert signCert) {
        this.signCert = signCert;
    }

    @Override
    public BusinessTrustCerts currentBusinessTrustCerts() {
        return this.trustCerts;
    }

    @Override
    public void setTimestampURL(String timestampURL) throws TSAException {
        this.setTimestampURL(timestampURL, this.timestampSSL);
    }

    @Override
    public void setTimestampURL(String timestampURL, SSLContext timestampSSL) throws TSAException {
        this.setTimestampURL(timestampURL, timestampSSL, null);
    }

    @Override
    public void setTimestampURL(String timestampURL, SSLContext timestampSSL, Proxy proxy) throws TSAException {
        HTTPRequester requester;
        try {
            if (this.startWithHTTPs(timestampURL)) {
                if (timestampSSL == null) {
                    throw new TSAException(TSAErrorCode.serverUrlHTTPSRequireSSLContext, "setTimestampURL required timestampSSL for " + timestampURL);
                }
                requester = HTTPRequester.getHttpsInstance(timestampURL, timestampSSL);
            } else {
                requester = HTTPRequester.getHttpInstance(timestampURL);
            }
            requester.setUsername(this.httpAuthUsername);
            requester.setPassword(this.httpAuthpassword);
        }
        catch (TSAException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampClientBuildRequestorFailure, "requestor build failure", (Throwable)e);
        }
        this.requester = requester;
    }

    @Override
    public void setTimestampHttpAuthInfo(String username, String password) {
        this.httpAuthUsername = username;
        this.httpAuthpassword = password;
        if (this.requester != null) {
            this.requester.setUsername(this.httpAuthUsername);
            this.requester.setPassword(this.httpAuthpassword);
        }
    }

    @Override
    public void setTimestampMode(TSARequestPolicy timestampMode) throws TSAException {
        if (timestampMode == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@setTimestameMode missing parameter@timestampConfig");
            throw new TSAException(TSAErrorCode.timestampClientMissingPolicyMode, "required parameter timestampMode");
        }
        this.timestampMode = timestampMode;
    }

    @Override
    public void setRequiredNonceOptional(boolean requiredNonceOptional) {
        this.requiredNonceOptional = requiredNonceOptional;
    }

    @Override
    public void setRequiredCertOptional(boolean requiredCertOptional) {
        this.requiredCertOptional = requiredCertOptional;
    }

    @Override
    public Timestamp requestTimestamp(HashAlgorithm hashAlgorithm, byte[] sourceMessage) throws TSAException {
        return this.requestTimestamp(this.httpTimeout, hashAlgorithm, sourceMessage);
    }

    @Override
    public Timestamp requestTimestamp(HashAlgorithm hashAlgorithm, InputStream sourceInputStream) throws TSAException {
        return this.requestTimestamp(this.httpTimeout, hashAlgorithm, sourceInputStream);
    }

    @Override
    public Timestamp requestTimestamp(MessageImprint messageImprint) throws TSAException {
        return this.requestTimestamp(this.httpTimeout, messageImprint);
    }

    @Override
    public Timestamp requestTimestamp(int timeout, HashAlgorithm hashAlgorithm, byte[] sourceMessage) throws TSAException {
        MessageImprint messageImprint;
        if (hashAlgorithm == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp missing parameter@hashAlgorithm: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingHashAlgorithm, "required parameter hashAlgorithm");
        }
        if (sourceMessage == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp missing parameter@sourceMessage: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingSourceMessage, "required parameter sourceMessage");
        }
        try {
            messageImprint = this.buildMessageImprint(hashAlgorithm, sourceMessage, null);
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp buildMessageImprint failure: {}", (Object)hashAlgorithm, (Object)e);
            throw e;
        }
        return this.generateTimestamp(timeout, messageImprint);
    }

    @Override
    public Timestamp requestTimestamp(int timeout, HashAlgorithm hashAlgorithm, InputStream sourceInputStream) throws TSAException {
        MessageImprint messageImprint;
        if (hashAlgorithm == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp missing parameter@hashAlgorithm: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingHashAlgorithm, "required parameter hashAlgorithm");
        }
        if (sourceInputStream == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp missing parameter@sourceInputStream: {}", (Object)hashAlgorithm);
            throw new TSAException(TSAErrorCode.timestampClientMissingSourceStream, "required parameter sourceInputStream");
        }
        try {
            messageImprint = this.buildMessageImprint(hashAlgorithm, null, sourceInputStream);
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp buildMessageImprint failure: {}", (Object)hashAlgorithm, (Object)e);
            throw e;
        }
        return this.generateTimestamp(timeout, messageImprint);
    }

    @Override
    public Timestamp requestTimestamp(int timeout, MessageImprint messageImprint) throws TSAException {
        if (messageImprint == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp missing parameter@messageImprint: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMissingMessageImprint, "required parameter messageImprint");
        }
        if (messageImprint.getHashAlgorithm() == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp messageImprint required hashAlgorithm: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintMissingAlgorithm, "messageImprint required hashAlgorithm");
        }
        if (messageImprint.getHashedMessage() == null) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp messageImprint required hashedMessage: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintMissingHashedMessage, "messageImprint required hashedMessage");
        }
        if (messageImprint.getHashedMessage().length != messageImprint.getHashAlgorithm().hashLength) {
            TscLogging.ERROR_LOGGER.error("TimestampClient@requestTimestamp messageImprint invalid: {}", (Object)messageImprint);
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintInvalid, "messageImprint invalid");
        }
        return this.generateTimestamp(timeout, messageImprint);
    }

    @Override
    public byte[] ping(byte[] data) throws TSAException {
        byte[] pongBytes;
        String tscUUID = TimestampUUID.UUID.randomUUID();
        try {
            pongBytes = this.requester.pingRequest(data, this.config.getCommonConf(), this.config.getSslLayeredConf(), tscUUID);
        }
        catch (TSAHttpStatusInfoException e) {
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} TimestampClient@ping sendRequest failure: pingBytes={}", new Object[]{tscUUID, TscStrings.toHexString(data), e});
            throw e;
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} TimestampClient@ping sendRequest failure: pingBytes={}", new Object[]{tscUUID, TscStrings.toHexString(data), e});
            throw e;
        }
        return pongBytes;
    }

    private final Timestamp generateTimestamp(int timeout, MessageImprint messageImprint) throws TSAException {
        String nonceResponseHex;
        TSASignedData signedData;
        byte[] responseBytes;
        byte[] requestBytes;
        String nonceRequestHex;
        BigInteger nonceRequest;
        Args.notNull((Object)messageImprint, (String)"messageImprint");
        long startTime0 = System.currentTimeMillis();
        String tscUUID = TimestampUUID.UUID.randomUUID();
        TscLogging.DEBUG_LOGGER.debug("CFCA-TSC-UUID={} TimestampClient@generateTimestamp running...{}", (Object)tscUUID, (Object)messageImprint);
        if (this.requester == null) {
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} TimestampClient@generateTimestamp requester not setting", (Object)tscUUID);
            throw new TSAException(TSAErrorCode.timestampClientRequesterNotSetting, "required requester");
        }
        if (this.requiredNonceOptional) {
            nonceRequest = TimestampNonce.randomUUID();
            nonceRequestHex = nonceRequest.toString(16);
        } else {
            nonceRequest = null;
            nonceRequestHex = "none";
        }
        try {
            requestBytes = this.buildTimestampRequest(messageImprint, nonceRequest);
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} TimestampClient@generateTimestamp buildTimestampRequest failure: {}", new Object[]{tscUUID, messageImprint, e});
            throw e;
        }
        if (TscLogging.DEBUG_LOGGER.isDebugEnabled()) {
            String requestDatas = TscStrings.toBase64String(requestBytes);
            TscLogging.DEBUG_LOGGER.debug("CFCA-TSC-UUID={} TimestampClient@generateTimestamp {}, requestBytes: {}", new Object[]{tscUUID, messageImprint, requestDatas});
        }
        try {
            responseBytes = this.requester.sendRequest(requestBytes, this.config.getCommonConf(), this.config.getSslLayeredConf(), tscUUID);
        }
        catch (TSAHttpStatusInfoException e) {
            this.loggingGenerateTimestampFailure(tscUUID, "endRequest failure", messageImprint, requestBytes, null);
            throw e;
        }
        catch (TSAException e) {
            this.loggingGenerateTimestampFailure(tscUUID, "endRequest failure", messageImprint, requestBytes, null);
            throw e;
        }
        if (TscLogging.DEBUG_LOGGER.isDebugEnabled()) {
            String requestDatas = TscStrings.toBase64String(requestBytes);
            TscLogging.DEBUG_LOGGER.debug("CFCA-TSC-UUID={} TimestampClient@generateTimestamp {}, responseBytes={}", new Object[]{tscUUID, messageImprint, requestDatas});
        }
        if (responseBytes == null) {
            this.loggingGenerateTimestampFailure(tscUUID, "invalid response", messageImprint, requestBytes, responseBytes);
            throw new TSAException(TSAErrorCode.timestampClientResponseFailure, "responseBytes is null");
        }
        try {
            signedData = new TSASignedData(requestBytes, responseBytes, this.requiredCertOptional, this.signCert);
        }
        catch (TSAException e) {
            this.loggingGenerateTimestampFailure(tscUUID, "invalid response-signedData", messageImprint, requestBytes, responseBytes);
            throw e;
        }
        BigInteger nonceResponse = signedData.getNonce();
        String string = nonceResponseHex = nonceResponse == null ? null : nonceResponse.toString(16);
        if (nonceRequest != null) {
            if (nonceResponse == null) {
                this.loggingGenerateTimestampFailure(tscUUID, "invalid response without nonce", messageImprint, requestBytes, responseBytes);
                throw new TSAException(TSAErrorCode.timestampClientResponseNonceMissing, "TSASignedData@nonce missing");
            }
            if (!nonceRequest.equals(nonceResponse)) {
                String error = String.format("response with invalid nonce[%s,%s]", nonceRequestHex, nonceResponseHex);
                this.loggingGenerateTimestampFailure(tscUUID, error, messageImprint, requestBytes, responseBytes);
                throw new TSAException(TSAErrorCode.timestampClientResponseNonceInvalid, String.format("TSASignedData@nonce not match with request %s<-->%s", nonceRequestHex, nonceResponseHex));
            }
        }
        String policyID = signedData.getPolicyID();
        switch (this.timestampMode) {
            case SIGN_AUTH: 
            case HTTP_AUTH: 
            case TEST_OID: {
                if (policyID == null) {
                    this.loggingGenerateTimestampFailure(tscUUID, "response without policyId", messageImprint, requestBytes, responseBytes);
                    throw new TSAException(TSAErrorCode.timestampClientResponseNonceMissing, "TSASignedData@policyId missing");
                }
                if (this.timestampMode.OID.equals(policyID)) break;
                String error = String.format("response without policyId[%s,%s]", new Object[]{this.timestampMode, policyID});
                this.loggingGenerateTimestampFailure(tscUUID, error, messageImprint, requestBytes, responseBytes);
                throw new TSAException(TSAErrorCode.timestampClientResponsePolicyIdInvalid, String.format("TSASignedData@policyID not match with request %s<-->%s", new Object[]{this.timestampMode, policyID}));
            }
        }
        MessageImprint messageImprintResponse = signedData.getMessageImprint();
        if (messageImprintResponse == null) {
            this.loggingGenerateTimestampFailure(tscUUID, "response without messageImprint", messageImprint, requestBytes, responseBytes);
            throw new TSAException(TSAErrorCode.timestampClientResponseMessageImprintMissing, "TSASignedData@messageImprint missing");
        }
        if (!messageImprintResponse.equals(messageImprint)) {
            String error = String.format("response with invalid messageImprint{%s,%s}", messageImprint, messageImprintResponse);
            this.loggingGenerateTimestampFailure(tscUUID, error, messageImprint, requestBytes, responseBytes);
            throw new TSAException(TSAErrorCode.timestampClientResponseMessageImprintInvalid, "TSASignedData@messageImprint invalid");
        }
        boolean needVerifyTrust = this.verifyTimestamp && (this.requiredCertOptional || this.signCert != null);
        long warningThresholdTime = this.config.getWarningThresholdTime();
        if (needVerifyTrust) {
            boolean verifySignature;
            long startTime = System.currentTimeMillis();
            try {
                verifySignature = signedData.verifySignedData(this.trustCerts, this.session);
            }
            catch (TSAException e) {
                this.loggingGenerateTimestampFailure(tscUUID, "check signedData/signedCert failure", messageImprint, requestBytes, responseBytes);
                throw e;
            }
            long execTime = System.currentTimeMillis() - startTime;
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} TimestampClient@generateTimestamp verifyTimestamp: result={},verifyTime={} ms", new Object[]{tscUUID, verifySignature, execTime});
            if (execTime > warningThresholdTime) {
                TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} TimestampClient@generateTimestamp verifyTimestamp: result={},verifyTime={} ms", new Object[]{tscUUID, verifySignature, execTime});
            }
            if (!verifySignature) {
                this.loggingGenerateTimestampFailure(tscUUID, "response with invalid signedDataOrSignedCert", messageImprint, requestBytes, responseBytes);
                throw new TSAException(TSAErrorCode.timestampClientResponseSignedDataOrSignedCertInvalid, "TSASignedData@signedData/signedCert invalid");
            }
        }
        Timestamp timestamp = signedData.getTimeStamp();
        long execTime = System.currentTimeMillis() - startTime0;
        TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} TimestampClient@requestTimestamp totalTime={} ms", (Object)tscUUID, (Object)execTime);
        if (execTime > warningThresholdTime) {
            TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} TimestampClient@requestTimestamp totalTime={} ms", (Object)tscUUID, (Object)execTime);
        }
        return timestamp;
    }

    private final void loggingGenerateTimestampFailure(String tscUUID, String errorHint, MessageImprint messageImprint, byte[] requestBytes, byte[] responseBytes) {
        String requestDatas = TscStrings.toBase64String(requestBytes);
        if (responseBytes == null) {
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} TimestampClient@generateTimestamp {}: {},requestBytes={}", new Object[]{tscUUID, errorHint, messageImprint, requestDatas});
        } else {
            String responseDatas = TscStrings.toBase64String(responseBytes);
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} TimestampClient@generateTimestamp {}: {}, requestBytes={}, responseBytes={}", new Object[]{tscUUID, errorHint, messageImprint, requestDatas, responseDatas});
        }
    }

    private final byte[] buildTimestampRequest(MessageImprint messageImprint, BigInteger nonce) throws TSAException {
        byte[] timestampReqBytes = null;
        try {
            ASN1ObjectIdentifier asn1ReqTSAPolicyId;
            ASN1Integer nonceValue = nonce == null ? null : new ASN1Integer(nonce);
            ASN1Boolean asn1CertReq = ASN1Boolean.getInstance((boolean)this.requiredCertOptional);
            AlgorithmIdentifier oid = new AlgorithmIdentifier(new ASN1ObjectIdentifier(messageImprint.getHashAlgorithm().oid), (ASN1Encodable)DERNull.INSTANCE);
            cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint mssageImprint = new cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint(oid, messageImprint.getHashedMessage());
            Extensions extensions = null;
            switch (this.timestampMode) {
                case SIGN_AUTH: 
                case HTTP_AUTH: 
                case TEST_OID: {
                    asn1ReqTSAPolicyId = new ASN1ObjectIdentifier(this.timestampMode.OID);
                    break;
                }
                default: {
                    asn1ReqTSAPolicyId = null;
                }
            }
            TimeStampReq timestampReq = new TimeStampReq(mssageImprint, asn1ReqTSAPolicyId, nonceValue, asn1CertReq, extensions);
            timestampReqBytes = timestampReq.getEncoded();
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.timestampClientRequestMessageBuildFailure, String.format("nonce=%s %s", nonce, messageImprint), (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampClientRequestMessageBuildFailure, String.format("nonce=%s %s", nonce, messageImprint), (Throwable)e);
        }
        return timestampReqBytes;
    }

    private final MessageImprint buildMessageImprint(HashAlgorithm hashAlgorithm, byte[] sourceMessage, InputStream sourceStream) throws TSAException {
        SM3Digest digest;
        long startTime = System.currentTimeMillis();
        switch (hashAlgorithm) {
            case SM3: {
                digest = new SM3Digest();
                break;
            }
            case SHA1: {
                digest = new SHA1Digest();
                break;
            }
            case SHA256: {
                digest = new SHA256Digest();
                break;
            }
            case SHA512: {
                digest = new SHA512Digest();
                break;
            }
            case MD5TEST: {
                digest = new MD5Digest();
                break;
            }
            default: {
                throw new TSAException(TSAErrorCode.timestampClientMessageImprintInvalidHashAlgorithm, "hashAlgorithm invalid: " + (Object)((Object)hashAlgorithm));
            }
        }
        String algorithmName = digest.getAlgorithmName();
        int hashDataLength = 0;
        if (sourceMessage == null) {
            if (sourceStream == null) {
                throw new TSAException(TSAErrorCode.timestampClientMessageImprintMissingSourceData, "sourceMessage/sourceStream missing");
            }
            try {
                byte[] buffer = new byte[16384];
                int readLength = 0;
                while ((readLength = sourceStream.read(buffer)) > 0) {
                    digest.update(buffer, 0, readLength);
                    hashDataLength += readLength;
                }
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timestampClientMessageImprintBuildFailure, "hash update failure: " + (Object)((Object)hashAlgorithm), (Throwable)e);
            }
        } else {
            digest.update(sourceMessage, 0, sourceMessage.length);
            hashDataLength = sourceMessage.length;
        }
        byte[] hashedMessage = new byte[digest.getDigestSize()];
        try {
            digest.doFinal(hashedMessage, 0);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintBuildFailure, "doFinal failure: " + (Object)((Object)hashAlgorithm), (Throwable)e);
        }
        MessageImprint messageImprint = new MessageImprint(hashAlgorithm, hashedMessage);
        long hashTime = System.currentTimeMillis() - startTime;
        TscLogging.SYSTEM_LOGGER.info("buildMessageImprint: hashTime={} ms, algorithmName={},hashDataLength={}", new Object[]{hashTime, algorithmName, hashDataLength});
        return messageImprint;
    }

    private final boolean startWithHTTPs(String timestampUrl) {
        return timestampUrl != null && timestampUrl.trim().toLowerCase().startsWith("https://");
    }

    @Override
    public void setSession(Session session) {
        this.session = session == null ? DefaultSessionLib.SESSION : session;
    }

    @Override
    public void setTimestampVerify(boolean verify) {
        this.verifyTimestamp = verify;
    }
}

