/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security;

import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.codec.Base64;
import cfca.com.itextpdf.text.pdf.security.BouncyCastleDigest;
import cfca.com.itextpdf.text.pdf.security.DigestAlgorithms;
import cfca.com.itextpdf.text.pdf.security.TSAClient;
import cfca.com.itextpdf.text.pdf.security.TSAInfoBouncyCastle;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIFailureInfo;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TimeStampRequest;
import cfca.sadk.org.bouncycastle.tsp.TimeStampRequestGenerator;
import cfca.sadk.org.bouncycastle.tsp.TimeStampResponse;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;

public class TSAClientBouncyCastle
implements TSAClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSAClientBouncyCastle.class);
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected TSAInfoBouncyCastle tsaInfo;
    public static final int DEFAULTTOKENSIZE = 4096;
    protected int tokenSizeEstimate;
    public static final String DEFAULTHASHALGORITHM = "SHA-256";
    protected static boolean catchException = false;
    protected String digestAlgorithm;
    private int connectTimeout = 3000;
    private int readTimeout = 3000;

    public TSAClientBouncyCastle(String url) {
        this(url, null, null, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password) {
        this(url, username, password, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password, int connectTimeout, int readTimeout, boolean isCatchException) {
        this(url, username, password, 4096, DEFAULTHASHALGORITHM);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        catchException = isCatchException;
    }

    public TSAClientBouncyCastle(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = tokSzEstimate;
        this.digestAlgorithm = digestAlgorithm;
    }

    public TSAClientBouncyCastle(String url, String username, String password, int tokSzEstimate, String digestAlgorithm, int connectTimeout, int readTimeout, boolean isCatchException) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = tokSzEstimate;
        this.digestAlgorithm = digestAlgorithm;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        catchException = isCatchException;
    }

    public void setTSAInfo(TSAInfoBouncyCastle tsaInfo) {
        this.tsaInfo = tsaInfo;
    }

    public int getTokenSizeEstimate() {
        return this.tokenSizeEstimate;
    }

    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return new BouncyCastleDigest().getMessageDigest(this.digestAlgorithm);
    }

    public byte[] getTimeStampToken(byte[] imprint) throws IOException, TSPException {
        int value;
        byte[] respBytes = null;
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = tsqGenerator.generate(new ASN1ObjectIdentifier(DigestAlgorithms.getAllowedDigests(this.digestAlgorithm)), imprint, nonce);
        byte[] requestBytes = request.getEncoded();
        respBytes = this.getTSAResponse(requestBytes);
        TimeStampResponse response = new TimeStampResponse(respBytes);
        response.validate(request);
        PKIFailureInfo failure = response.getFailInfo();
        int n = value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new IOException(MessageLocalization.getComposedMessage("invalid.tsa.1.response.code.2", this.tsaURL, String.valueOf(value)));
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new IOException(MessageLocalization.getComposedMessage("tsa.1.failed.to.return.time.stamp.token.2", this.tsaURL, response.getStatusString()));
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        LOGGER.info("Timestamp generated: " + tsTokenInfo.getGenTime());
        if (this.tsaInfo != null) {
            this.tsaInfo.inspectTimeStampTokenInfo(tsTokenInfo);
        }
        this.tokenSizeEstimate = encoded.length + 32;
        return encoded;
    }

    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        URLConnection tsaConnection;
        URL url = new URL(this.tsaURL);
        try {
            tsaConnection = url.openConnection();
        }
        catch (IOException ioe) {
            throw new IOException(MessageLocalization.getComposedMessage("failed.to.get.tsa.response.from.1", this.tsaURL));
        }
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setConnectTimeout(this.connectTimeout);
        tsaConnection.setReadTimeout(this.readTimeout);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.tsaUsername != null && !this.tsaUsername.equals("")) {
            String userPassword = this.tsaUsername + ":" + this.tsaPassword;
            tsaConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(userPassword.getBytes(), 8));
        }
        OutputStream out = tsaConnection.getOutputStream();
        out.write(requestBytes);
        out.close();
        InputStream inp = tsaConnection.getInputStream();
        ByteBuffer baos = new ByteBuffer();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            respBytes = Base64.decode(new String(respBytes));
        }
        return respBytes;
    }

    public String getTSAURL() {
        return this.tsaURL;
    }

    public String getTSAUserName() {
        return this.tsaUsername;
    }

    public String getTSAPassword() {
        return this.tsaPassword;
    }

    public void setHashAlg(String hashAlg) {
        this.digestAlgorithm = hashAlg;
    }

    public String getHashAlg() {
        return this.digestAlgorithm;
    }

    public static interface HashAlgorithm {
        public static final String SHA1 = "SHA1";
        public static final String SHA256 = "SHA256";
        public static final String SHA512 = "SHA512";
        public static final String SHA_1 = "SHA-1";
        public static final String SHA_256 = "SHA-256";
        public static final String SHA_512 = "SHA-512";
    }
}

