/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.SubTable;
import cfca.com.google.typography.font.sfntly.table.opentype.FeatureListTable;
import cfca.com.google.typography.font.sfntly.table.opentype.LookupListTable;
import cfca.com.google.typography.font.sfntly.table.opentype.LookupTable;
import cfca.com.google.typography.font.sfntly.table.opentype.ScriptListTable;

abstract class LayoutCommonTable<T extends LookupTable>
extends SubTable {
    private static int VERSION_OFFSET = 0;
    private static int SCRIPT_LIST_OFFSET = 4;
    private static int FEATURE_LIST_OFFSET = 6;
    private static int LOOKUP_LIST_OFFSET = 8;
    private static int HEADER_SIZE = 10;
    private static int VERSION_ID = 65536;
    private final boolean dataIsCanonical;

    protected LayoutCommonTable(ReadableFontData data, boolean dataIsCanonical) {
        super(data);
        this.dataIsCanonical = dataIsCanonical;
    }

    private static int readScriptListOffset(ReadableFontData data) {
        return data.readUShort(SCRIPT_LIST_OFFSET);
    }

    private static ReadableFontData scriptListData(ReadableFontData commonData, boolean dataIsCanonical) {
        int start = LayoutCommonTable.readScriptListOffset(commonData);
        if (dataIsCanonical) {
            int limit = LayoutCommonTable.readFeatureListOffset(commonData);
            return commonData.slice(start, limit - start);
        }
        return commonData.slice(start);
    }

    ScriptListTable createScriptList() {
        return new ScriptListTable(LayoutCommonTable.scriptListData(this.data, this.dataIsCanonical), this.dataIsCanonical);
    }

    private static int readFeatureListOffset(ReadableFontData data) {
        return data.readUShort(FEATURE_LIST_OFFSET);
    }

    private static ReadableFontData featureListData(ReadableFontData commonData, boolean dataIsCanonical) {
        int start = LayoutCommonTable.readFeatureListOffset(commonData);
        if (dataIsCanonical) {
            int limit = LayoutCommonTable.readLookupListOffset(commonData);
            return commonData.slice(start, limit - start);
        }
        return commonData.slice(start);
    }

    FeatureListTable createFeatureList() {
        return new FeatureListTable(LayoutCommonTable.featureListData(this.data, this.dataIsCanonical), this.dataIsCanonical);
    }

    private static int readLookupListOffset(ReadableFontData data) {
        return data.readUShort(LOOKUP_LIST_OFFSET);
    }

    private static ReadableFontData lookupListData(ReadableFontData commonData, boolean dataIsCanonical) {
        int start = LayoutCommonTable.readLookupListOffset(commonData);
        if (dataIsCanonical) {
            int limit = commonData.length();
            return commonData.slice(start, limit - start);
        }
        return commonData.slice(start);
    }

    protected LookupListTable createLookupList() {
        return this.handleCreateLookupList(LayoutCommonTable.lookupListData(this.data, this.dataIsCanonical), this.dataIsCanonical);
    }

    protected abstract LookupListTable handleCreateLookupList(ReadableFontData var1, boolean var2);

    static abstract class Builder<T extends LookupTable>
    extends SubTable.Builder<LayoutCommonTable<T>> {
        private int serializedLength;
        private ScriptListTable.Builder serializedScriptListBuilder;
        private FeatureListTable.Builder serializedFeatureListBuilder;
        private LookupListTable.Builder serializedLookupListBuilder;

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data);
        }

        protected Builder() {
            super(null);
        }

        protected abstract LookupListTable handleCreateLookupList(ReadableFontData var1, boolean var2);

        protected abstract LookupListTable.Builder createLookupListBuilder();

        @Override
        protected int subSerialize(WritableFontData newData) {
            if (this.serializedLength == 0) {
                return 0;
            }
            newData.writeULong(VERSION_OFFSET, VERSION_ID);
            int pos = HEADER_SIZE;
            newData.writeUShort(SCRIPT_LIST_OFFSET, pos);
            pos += this.serializedScriptListBuilder.subSerialize(newData.slice(pos));
            newData.writeUShort(FEATURE_LIST_OFFSET, pos);
            pos += this.serializedFeatureListBuilder.subSerialize(newData.slice(pos));
            newData.writeUShort(LOOKUP_LIST_OFFSET, pos);
            pos += this.serializedLookupListBuilder.subSerialize(newData.slice(pos));
            return this.serializedLength;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        protected abstract LayoutCommonTable<T> subBuildTable(ReadableFontData var1);
    }
}

