/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.config;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import org.springblade.core.oss.TencentCosTemplate;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OssConfiguration.class})
@ConditionalOnClass(value={COSClient.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="tencentcos")
public class TencentCosConfiguration {
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Bean
    @ConditionalOnMissingBean(value={COSClient.class})
    public COSClient ossClient() {
        BasicCOSCredentials credentials = new BasicCOSCredentials(this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey());
        Region region = new Region(this.ossProperties.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setMaxConnectionsCount(1024);
        clientConfig.setSocketTimeout(50000);
        clientConfig.setConnectionTimeout(50000);
        clientConfig.setConnectionRequestTimeout(1000);
        return new COSClient((COSCredentials)credentials, clientConfig);
    }

    @Bean
    @ConditionalOnBean(value={COSClient.class})
    @ConditionalOnMissingBean(value={TencentCosTemplate.class})
    public TencentCosTemplate tencentCosTemplate(COSClient cosClient) {
        return new TencentCosTemplate(cosClient, this.ossProperties, this.ossRule);
    }

    public TencentCosConfiguration(OssProperties ossProperties, OssRule ossRule) {
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

