/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.ofd;

import cfca.sadk.ofd.base.common.StringUtil;
import java.io.Serializable;

public class Rectangle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8025677415569233446L;
    private static float EPS = 1.0E-4f;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected int pageNum;
    protected String pageFilePath;

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public Rectangle(String boundary) {
        block5: {
            this.pageNum = -1;
            this.pageFilePath = "";
            String[] positions = boundary.split(" ");
            try {
                this.x = Float.valueOf(positions[0]).floatValue();
                this.y = Float.valueOf(positions[1]).floatValue();
                this.width = Float.valueOf(positions[2]).floatValue();
                this.height = Float.valueOf(positions[3]).floatValue();
            }
            catch (NumberFormatException e) {
                if (StringUtil.isNumber(positions[0])) {
                    this.x = Float.valueOf(positions[0]).floatValue();
                }
                if (StringUtil.isNumber(positions[1])) {
                    this.y = Float.valueOf(positions[1]).floatValue();
                }
                if (StringUtil.isNumber(positions[2])) {
                    this.width = Float.valueOf(positions[2]).floatValue();
                }
                if (!StringUtil.isNumber(positions[3])) break block5;
                this.height = Float.valueOf(positions[3]).floatValue();
            }
        }
    }

    public Rectangle(float x, float y, float width, float height) {
        this.pageNum = -1;
        this.pageFilePath = "";
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(float width, float height) {
        this(0.0f, 0.0f, width, height);
    }

    public Rectangle(Rectangle rect) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle getCommonRectangle(Rectangle ... rectangles) {
        float ury = -3.4028235E38f;
        float llx = Float.MAX_VALUE;
        float lly = Float.MAX_VALUE;
        float urx = -3.4028235E38f;
        for (Rectangle rectangle : rectangles) {
            if (rectangle == null) continue;
            Rectangle rec = rectangle.clone();
            if (rec.getY() < lly) {
                lly = rec.getY();
            }
            if (rec.getX() < llx) {
                llx = rec.getX();
            }
            if (rec.getY() + rec.getHeight() > ury) {
                ury = rec.getY() + rec.getHeight();
            }
            if (!(rec.getX() + rec.getWidth() > urx)) continue;
            urx = rec.getX() + rec.getWidth();
        }
        return new Rectangle(llx, lly, urx - llx, ury - lly);
    }

    public Rectangle setBbox(float llx, float lly, float urx, float ury) {
        float temp;
        if (llx > urx) {
            temp = llx;
            llx = urx;
            urx = temp;
        }
        if (lly > ury) {
            temp = lly;
            lly = ury;
            ury = temp;
        }
        this.x = llx;
        this.y = lly;
        this.width = urx - llx;
        this.height = ury - lly;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public Rectangle setX(float x) {
        this.x = x;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Rectangle setY(float y) {
        this.y = y;
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public Rectangle setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public Rectangle setHeight(float height) {
        this.height = height;
        return this;
    }

    public Rectangle increaseHeight(float extra) {
        this.height += extra;
        return this;
    }

    public Rectangle decreaseHeight(float extra) {
        this.height -= extra;
        return this;
    }

    public float getLeft() {
        return this.x;
    }

    public float getRight() {
        return this.x + this.width;
    }

    public float getTop() {
        return this.y + this.height;
    }

    public float getBottom() {
        return this.y;
    }

    public Rectangle moveDown(float move) {
        this.y -= move;
        return this;
    }

    public Rectangle moveUp(float move) {
        this.y += move;
        return this;
    }

    public Rectangle moveRight(float move) {
        this.x += move;
        return this;
    }

    public Rectangle moveLeft(float move) {
        this.x -= move;
        return this;
    }

    public <T extends Rectangle> T applyMargins(float topIndent, float rightIndent, float bottomIndent, float leftIndent, boolean reverse) {
        this.x += leftIndent * (float)(reverse ? -1 : 1);
        this.width -= (leftIndent + rightIndent) * (float)(reverse ? -1 : 1);
        this.y += bottomIndent * (float)(reverse ? -1 : 1);
        this.height -= (topIndent + bottomIndent) * (float)(reverse ? -1 : 1);
        return (T)this;
    }

    public boolean intersectsLine(float x1, float y1, float x2, float y2) {
        double rx1 = this.getX();
        double ry1 = this.getY();
        double rx2 = rx1 + (double)this.getWidth();
        double ry2 = ry1 + (double)this.getHeight();
        return rx1 <= (double)x1 && (double)x1 <= rx2 && ry1 <= (double)y1 && (double)y1 <= ry2 || rx1 <= (double)x2 && (double)x2 <= rx2 && ry1 <= (double)y2 && (double)y2 <= ry2 || Rectangle.linesIntersect(rx1, ry1, rx2, ry2, x1, y1, x2, y2) || Rectangle.linesIntersect(rx2, ry1, rx1, ry2, x1, y1, x2, y2);
    }

    public String toString() {
        return "Rectangle:" + this.getWidth() + 'x' + this.getHeight() + " x=" + this.x + " y=" + this.y;
    }

    public Rectangle clone() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean equalsWithEpsilon(Rectangle that) {
        return this.equalsWithEpsilon(that, EPS);
    }

    public boolean equalsWithEpsilon(Rectangle that, float eps) {
        float dx = Math.abs(this.x - that.x);
        float dy = Math.abs(this.y - that.y);
        float dw = Math.abs(this.width - that.width);
        float dh = Math.abs(this.height - that.height);
        return dx < eps && dy < eps && dw < eps && dh < eps;
    }

    private static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double AvB = (x2 -= x1) * (y3 -= y1) - (x3 -= x1) * (y2 -= y1);
        double AvC = x2 * (y4 -= y1) - (x4 -= x1) * y2;
        if (AvB == 0.0 && AvC == 0.0) {
            if (x2 != 0.0) {
                return x4 * x3 <= 0.0 || x3 * x2 >= 0.0 && (x2 > 0.0 ? x3 <= x2 || x4 <= x2 : x3 >= x2 || x4 >= x2);
            }
            if (y2 != 0.0) {
                return y4 * y3 <= 0.0 || y3 * y2 >= 0.0 && (y2 > 0.0 ? y3 <= y2 || y4 <= y2 : y3 >= y2 || y4 >= y2);
            }
            return false;
        }
        double BvC = x3 * y4 - x4 * y3;
        return AvB * AvC <= 0.0 && BvC * (AvB + BvC - AvC) <= 0.0;
    }

    public String getPageFilePath() {
        return this.pageFilePath;
    }

    public void setPageFilePath(String pageFilePath) {
        this.pageFilePath = pageFilePath;
    }

    public String toBoundery() {
        return this.getX() + " " + this.getY() + " " + this.getWidth() + " " + this.getHeight();
    }
}

