/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.decoder;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.asn1.parser.PKCS7SignFileParser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.signature.decoder.AbstractPKCS7Decoder;
import cfca.sadk.signature.decoder.SM3DualHash;
import cfca.sadk.signature.sm2.SM2SignerInfo;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.security.PublicKey;

final class PKCS7SM2Decoder
extends AbstractPKCS7Decoder {
    public PKCS7SM2Decoder(Session session, SignedData signedData, boolean isSM2Type) throws PKIException {
        super(session, signedData, isSM2Type);
    }

    public PKCS7SM2Decoder(Session session, PKCS7SignFileParser signedFile, boolean isSM2Type) throws PKIException {
        super(session, signedFile, isSM2Type);
    }

    final boolean isSM2Type() {
        return true;
    }

    final byte[] getSignValue() throws PKIException {
        try {
            SM2SignerInfo signer = SM2SignerInfo.getInstance(this.signerInfo);
            byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signer.getEncryptedDigestR().getPositiveValue());
            byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signer.getEncryptedDigestS().getPositiveValue());
            byte[] signature = new byte[64];
            System.arraycopy(r, 0, signature, 0, 32);
            System.arraycopy(s, 0, signature, 32, 32);
            return signature;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, "signValue decode failed");
        }
    }

    byte[] hashData(String hashAlg, byte[] sourceData, PublicKey pubKey) throws PKIException {
        try {
            return HashUtil.SM3HashData(sourceData, (SM2PublicKey)pubKey, this.session, pubKey != null);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    byte[] hashData(String hashAlg, InputStream sourceData, PublicKey pubKey) throws PKIException {
        try {
            if (pubKey != null) {
                return HashUtil.SM3HashFileWithZValue(sourceData, (SM2PublicKey)pubKey, this.session);
            }
            return HashUtil.SM3HashFileWithoutZValue(sourceData, this.session);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    byte[] hashData(String hashAlg, ASN1Node sourceNode, PublicKey pubKey, String sourceFileOutputPath) throws PKIException {
        return SM3DualHash.sm2HashFile(sourceNode, sourceFileOutputPath, this.session);
    }

    AbstractPKCS7Decoder.SignHashAlgorithm getSignHashAlgorithm() throws PKIException {
        return new AbstractPKCS7Decoder.SignHashAlgorithm(Mechanisms.M_SM3_SM2, "SM3");
    }
}

