/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table;

import cfca.com.google.typography.font.sfntly.Tag;
import java.util.Comparator;

public final class Header {
    private final int tag;
    private final int offset;
    private final boolean offsetValid;
    private final int length;
    private final boolean lengthValid;
    private final long checksum;
    private final boolean checksumValid;
    public static final Comparator<Header> COMPARATOR_BY_OFFSET = new Comparator<Header>(){

        @Override
        public int compare(Header h1, Header h2) {
            return h1.offset - h2.offset;
        }
    };
    public static final Comparator<Header> COMPARATOR_BY_TAG = new Comparator<Header>(){

        @Override
        public int compare(Header h1, Header h2) {
            return h1.tag - h2.tag;
        }
    };

    public Header(int tag, long checksum, int offset, int length) {
        this.tag = tag;
        this.checksum = checksum;
        this.checksumValid = true;
        this.offset = offset;
        this.offsetValid = true;
        this.length = length;
        this.lengthValid = true;
    }

    public Header(int tag, int length) {
        this.tag = tag;
        this.checksum = 0L;
        this.checksumValid = false;
        this.offset = 0;
        this.offsetValid = false;
        this.length = length;
        this.lengthValid = true;
    }

    public Header(int tag) {
        this.tag = tag;
        this.checksum = 0L;
        this.checksumValid = false;
        this.offset = 0;
        this.offsetValid = false;
        this.length = 0;
        this.lengthValid = true;
    }

    public int tag() {
        return this.tag;
    }

    public int offset() {
        return this.offset;
    }

    public boolean offsetValid() {
        return this.offsetValid;
    }

    public int length() {
        return this.length;
    }

    public boolean lengthValid() {
        return this.lengthValid;
    }

    public long checksum() {
        return this.checksum;
    }

    public boolean checksumValid() {
        return this.checksumValid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Header)) {
            return false;
        }
        return ((Header)obj).tag == this.tag;
    }

    public int hashCode() {
        return this.tag;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(Tag.stringValue(this.tag));
        builder.append(", ");
        builder.append(Long.toHexString(this.checksum));
        builder.append(", ");
        builder.append(Integer.toHexString(this.offset));
        builder.append(", ");
        builder.append(Integer.toHexString(this.length));
        builder.append("]");
        return builder.toString();
    }
}

