/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.renderer;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.layout.border.Border;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.layout.LayoutArea;
import cfca.sadk.com.itextpdf.layout.layout.LayoutContext;
import cfca.sadk.com.itextpdf.layout.layout.LayoutResult;
import cfca.sadk.com.itextpdf.layout.layout.LineLayoutResult;
import cfca.sadk.com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import cfca.sadk.com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import cfca.sadk.com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import cfca.sadk.com.itextpdf.layout.property.FloatPropertyValue;
import cfca.sadk.com.itextpdf.layout.property.Leading;
import cfca.sadk.com.itextpdf.layout.property.OverflowPropertyValue;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.renderer.AbstractWidthHandler;
import cfca.sadk.com.itextpdf.layout.renderer.BlockRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.CellRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.DrawContext;
import cfca.sadk.com.itextpdf.layout.renderer.FloatingHelper;
import cfca.sadk.com.itextpdf.layout.renderer.IRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.LineRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.MaxMaxWidthHandler;
import cfca.sadk.com.itextpdf.layout.renderer.RotationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphRenderer
extends BlockRenderer {
    protected float previousDescent = 0.0f;
    protected List<LineRenderer> lines = null;

    public ParagraphRenderer(Paragraph modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        OverflowPropertyValue overflowY;
        this.overrideHeightProperties();
        boolean wasHeightClipped = false;
        boolean wasParentsHeightClipped = layoutContext.isClippedHeight();
        int pageNumber = layoutContext.getArea().getPageNumber();
        boolean anythingPlaced = false;
        boolean firstLineInBox = true;
        LineRenderer currentRenderer = (LineRenderer)new LineRenderer().setParent(this);
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        MarginsCollapseHandler marginsCollapseHandler = null;
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
        }
        boolean notAllKidsAreFloats = false;
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        float clearHeightCorrection = FloatingHelper.calculateClearHeightCorrection(this, floatRendererAreas, parentBBox);
        FloatingHelper.applyClearance(parentBBox, marginsCollapseHandler, clearHeightCorrection, FloatingHelper.isRendererFloating(this));
        Float blockWidth = this.retrieveWidth(parentBBox.getWidth());
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            blockWidth = FloatingHelper.adjustFloatedBlockLayoutBox(this, parentBBox, blockWidth, floatRendererAreas, floatPropertyValue);
            floatRendererAreas = new ArrayList<Rectangle>();
        }
        if (0 == this.childRenderers.size()) {
            anythingPlaced = true;
            currentRenderer = null;
        }
        boolean isPositioned = this.isPositioned();
        Float rotation = this.getPropertyAsFloat(55);
        OverflowPropertyValue overflowX = (OverflowPropertyValue)((Object)this.getProperty(103));
        Float blockMaxHeight = this.retrieveMaxHeight();
        OverflowPropertyValue overflowPropertyValue = overflowY = (null == blockMaxHeight || blockMaxHeight.floatValue() > parentBBox.getHeight()) && !wasParentsHeightClipped ? null : (OverflowPropertyValue)((Object)this.getProperty(104));
        if (rotation != null || this.isFixedLayout()) {
            parentBBox.moveDown(1000000.0f - parentBBox.getHeight()).setHeight(1000000.0f);
        }
        if (rotation != null && !FloatingHelper.isRendererFloating(this)) {
            blockWidth = RotationUtils.retrieveRotatedLayoutWidth(parentBBox.getWidth(), this);
        }
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.startMarginsCollapse(parentBBox);
        }
        Border[] borders = this.getBorders();
        float[] paddings = this.getPaddings();
        float additionalWidth = this.applyBordersPaddingsMargins(parentBBox, borders, paddings);
        this.applyWidth(parentBBox, blockWidth, overflowX);
        wasHeightClipped = this.applyMaxHeight(parentBBox, blockMaxHeight, marginsCollapseHandler, false, wasParentsHeightClipped, overflowY);
        MinMaxWidth minMaxWidth = new MinMaxWidth(additionalWidth, layoutContext.getArea().getBBox().getWidth());
        MaxMaxWidthHandler widthHandler = new MaxMaxWidthHandler(minMaxWidth);
        List<Rectangle> areas = isPositioned ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        this.shrinkOccupiedAreaForAbsolutePosition();
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        this.lines = new ArrayList<LineRenderer>();
        for (IRenderer child : this.childRenderers) {
            notAllKidsAreFloats = notAllKidsAreFloats || !FloatingHelper.isRendererFloating(child);
            currentRenderer.addChild(child);
        }
        float lastYLine = layoutBox.getY() + layoutBox.getHeight();
        Leading leading = (Leading)this.getProperty(33);
        float lastLineBottomLeadingIndent = 0.0f;
        if (marginsCollapsingEnabled && this.childRenderers.size() > 0) {
            marginsCollapseHandler.startChildMarginsHandling(null, layoutBox);
        }
        while (currentRenderer != null) {
            Float lineShiftUnderFloats;
            currentRenderer.setProperty(67, this.getPropertyAsFloat(67));
            currentRenderer.setProperty(69, this.getProperty(69));
            float lineIndent = anythingPlaced ? 0.0f : this.getPropertyAsFloat(18).floatValue();
            float childBBoxWidth = layoutBox.getWidth() - lineIndent;
            Rectangle childLayoutBox = new Rectangle(layoutBox.getX() + lineIndent, layoutBox.getY(), childBBoxWidth, layoutBox.getHeight());
            currentRenderer.setProperty(103, (Object)overflowX);
            currentRenderer.setProperty(104, (Object)overflowY);
            LineLayoutResult result = ((LineRenderer)currentRenderer.setParent(this)).layout(new LayoutContext(new LayoutArea(pageNumber, childLayoutBox), null, floatRendererAreas, wasHeightClipped || wasParentsHeightClipped));
            if (result.getStatus() == 3 && (lineShiftUnderFloats = FloatingHelper.calculateLineShiftUnderFloats(floatRendererAreas, layoutBox)) != null) {
                layoutBox.decreaseHeight(lineShiftUnderFloats.floatValue());
                firstLineInBox = true;
                continue;
            }
            float minChildWidth = 0.0f;
            float maxChildWidth = 0.0f;
            if (result instanceof MinMaxWidthLayoutResult) {
                minChildWidth = result.getNotNullMinMaxWidth(childBBoxWidth).getMinWidth();
                maxChildWidth = result.getNotNullMinMaxWidth(childBBoxWidth).getMaxWidth();
            }
            ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth + lineIndent);
            ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(maxChildWidth + lineIndent);
            LineRenderer processedRenderer = null;
            if (result.getStatus() == 1) {
                processedRenderer = currentRenderer;
            } else if (result.getStatus() == 2) {
                processedRenderer = (LineRenderer)result.getSplitRenderer();
            }
            TextAlignment textAlignment = this.getProperty(70, TextAlignment.LEFT);
            if (result.getStatus() == 2 && textAlignment == TextAlignment.JUSTIFIED && !result.isSplitForcedByNewline() || textAlignment == TextAlignment.JUSTIFIED_ALL) {
                if (processedRenderer != null) {
                    processedRenderer.justify(layoutBox.getWidth() - lineIndent);
                }
            } else if (textAlignment != TextAlignment.LEFT && processedRenderer != null) {
                float deltaX = childBBoxWidth - processedRenderer.getOccupiedArea().getBBox().getWidth();
                switch (textAlignment) {
                    case RIGHT: {
                        processedRenderer.move(deltaX, 0.0f);
                        break;
                    }
                    case CENTER: {
                        processedRenderer.move(deltaX / 2.0f, 0.0f);
                    }
                }
            }
            boolean lineHasContent = processedRenderer != null && processedRenderer.getOccupiedArea().getBBox().getHeight() > 0.0f;
            boolean doesNotFit = processedRenderer == null;
            float deltaY = 0.0f;
            if (!doesNotFit) {
                if (lineHasContent) {
                    float indentFromLastLine = this.previousDescent - lastLineBottomLeadingIndent - (leading != null ? processedRenderer.getTopLeadingIndent(leading) : 0.0f) - processedRenderer.getMaxAscent();
                    if (processedRenderer != null && processedRenderer.containsImage()) {
                        indentFromLastLine += this.previousDescent;
                    }
                    deltaY = lastYLine + indentFromLastLine - processedRenderer.getYLine();
                    float f = lastLineBottomLeadingIndent = leading != null ? processedRenderer.getBottomLeadingIndent(leading) : 0.0f;
                    if (lastLineBottomLeadingIndent < 0.0f && processedRenderer.containsImage()) {
                        lastLineBottomLeadingIndent = 0.0f;
                    }
                }
                if (firstLineInBox) {
                    deltaY = processedRenderer != null && leading != null ? -processedRenderer.getTopLeadingIndent(leading) : 0.0f;
                }
                boolean bl = doesNotFit = leading != null && processedRenderer.getOccupiedArea().getBBox().getY() + deltaY < layoutBox.getY();
            }
            if (doesNotFit && (null == processedRenderer || null == overflowY || OverflowPropertyValue.FIT.equals((Object)overflowY))) {
                if (currentAreaPos + 1 < areas.size()) {
                    layoutBox = areas.get(++currentAreaPos).clone();
                    lastYLine = layoutBox.getY() + layoutBox.getHeight();
                    firstLineInBox = true;
                    continue;
                }
                boolean keepTogether = this.isKeepTogether();
                if (keepTogether) {
                    return new MinMaxWidthLayoutResult(3, null, null, this, null == result.getCauseOfNothing() ? this : result.getCauseOfNothing());
                }
                if (marginsCollapsingEnabled) {
                    if (anythingPlaced && notAllKidsAreFloats) {
                        marginsCollapseHandler.endChildMarginsHandling(layoutBox);
                    }
                    marginsCollapseHandler.endMarginsCollapse(layoutBox);
                }
                ParagraphRenderer[] split = this.split();
                split[0].lines = this.lines;
                for (LineRenderer line : this.lines) {
                    split[0].childRenderers.addAll(line.getChildRenderers());
                }
                if (processedRenderer != null) {
                    split[1].childRenderers.addAll(processedRenderer.getChildRenderers());
                }
                if (result.getOverflowRenderer() != null) {
                    split[1].childRenderers.addAll(result.getOverflowRenderer().getChildRenderers());
                }
                if (this.hasProperty(84)) {
                    split[1].updateMaxHeight(Float.valueOf(this.retrieveMaxHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if (this.hasProperty(85)) {
                    split[1].updateMinHeight(Float.valueOf(this.retrieveMinHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if (this.hasProperty(27)) {
                    split[1].updateHeight(Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if (wasHeightClipped) {
                    split[0].getOccupiedArea().getBBox().moveDown(blockMaxHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(blockMaxHeight.floatValue());
                    Logger logger = LoggerFactory.getLogger(ParagraphRenderer.class);
                    logger.warn("Element content was clipped because some height properties are set.");
                }
                this.correctPositionedLayout(layoutBox);
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                this.applyAbsolutePositionIfNeeded(layoutContext);
                LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
                if (wasHeightClipped) {
                    return new MinMaxWidthLayoutResult(1, editedArea, split[0], null).setMinMaxWidth(minMaxWidth);
                }
                if (anythingPlaced) {
                    return new MinMaxWidthLayoutResult(2, editedArea, split[0], split[1]).setMinMaxWidth(minMaxWidth);
                }
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle(this.occupiedArea.getBBox(), currentRenderer.getOccupiedArea().getBBox()));
                    if (this.occupiedArea.getBBox().getWidth() > layoutBox.getWidth() && null != overflowX && !OverflowPropertyValue.FIT.equals((Object)overflowX)) {
                        this.occupiedArea.getBBox().setWidth(layoutBox.getWidth());
                    }
                    this.parent.setProperty(25, true);
                    this.lines.add(currentRenderer);
                    if (2 == result.getStatus()) {
                        IRenderer childNotRendered = result.getCauseOfNothing();
                        int firstNotRendered = currentRenderer.childRenderers.indexOf(childNotRendered);
                        currentRenderer.childRenderers.retainAll(currentRenderer.childRenderers.subList(0, firstNotRendered));
                        split[1].childRenderers.removeAll(split[1].childRenderers.subList(0, firstNotRendered));
                        return new MinMaxWidthLayoutResult(2, editedArea, this, split[1], null).setMinMaxWidth(minMaxWidth);
                    }
                    return new MinMaxWidthLayoutResult(1, editedArea, null, null, this).setMinMaxWidth(minMaxWidth);
                }
                return new MinMaxWidthLayoutResult(3, null, null, this, null == result.getCauseOfNothing() ? this : result.getCauseOfNothing());
            }
            if (leading != null) {
                processedRenderer.applyLeading(deltaY);
                if (lineHasContent) {
                    lastYLine = processedRenderer.getYLine();
                }
            }
            if (lineHasContent) {
                this.occupiedArea.setBBox(Rectangle.getCommonRectangle(this.occupiedArea.getBBox(), processedRenderer.getOccupiedArea().getBBox()));
                if (this.occupiedArea.getBBox().getWidth() > layoutBox.getWidth() && null != overflowX && !OverflowPropertyValue.FIT.equals((Object)overflowX)) {
                    this.occupiedArea.getBBox().setWidth(layoutBox.getWidth());
                }
            }
            firstLineInBox = false;
            layoutBox.setHeight(processedRenderer.getOccupiedArea().getBBox().getY() - layoutBox.getY());
            this.lines.add(processedRenderer);
            anythingPlaced = true;
            currentRenderer = (LineRenderer)result.getOverflowRenderer();
            this.previousDescent = processedRenderer.getMaxDescent();
        }
        float moveDown = lastLineBottomLeadingIndent;
        if ((null == overflowY || OverflowPropertyValue.FIT.equals((Object)overflowY)) && moveDown > this.occupiedArea.getBBox().getY() - layoutBox.getY()) {
            moveDown = this.occupiedArea.getBBox().getY() - layoutBox.getY();
        }
        this.occupiedArea.getBBox().moveDown(moveDown);
        this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + moveDown);
        float overflowPartHeight = this.getOverflowPartHeight(overflowY, layoutBox);
        if (marginsCollapsingEnabled) {
            if (this.childRenderers.size() > 0 && notAllKidsAreFloats) {
                marginsCollapseHandler.endChildMarginsHandling(layoutBox);
            }
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            FloatingHelper.includeChildFloatsInOccupiedArea(floatRendererAreas, this);
        }
        ParagraphRenderer overflowRenderer = null;
        Float blockMinHeight = this.retrieveMinHeight();
        if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            float blockBottom = this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight());
            if (blockBottom >= layoutContext.getArea().getBBox().getBottom() || null != overflowY && !OverflowPropertyValue.FIT.equals((Object)overflowY)) {
                this.occupiedArea.getBBox().setY(blockBottom).setHeight(blockMinHeight.floatValue());
            } else {
                this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - layoutContext.getArea().getBBox().getBottom()).setY(layoutContext.getArea().getBBox().getBottom());
                overflowRenderer = this.createOverflowRenderer(this.parent);
                overflowRenderer.updateMinHeight(Float.valueOf(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                if (this.hasProperty(27)) {
                    overflowRenderer.updateHeight(Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
            }
            this.applyVerticalAlignment();
        }
        this.correctPositionedLayout(layoutBox);
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        this.applyAbsolutePositionIfNeeded(layoutContext);
        if (rotation != null) {
            this.applyRotationLayout(layoutContext.getArea().getBBox().clone());
            if (this.isNotFittingLayoutArea(layoutContext.getArea())) {
                if (this.isNotFittingWidth(layoutContext.getArea()) && !this.isNotFittingHeight(layoutContext.getArea())) {
                    LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format("Element does not fit current area. {0}", "It fits by height so it will be forced placed"));
                } else if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    return new MinMaxWidthLayoutResult(3, null, null, this, this);
                }
            }
        }
        if (wasHeightClipped) {
            this.occupiedArea.getBBox().moveUp(overflowPartHeight).decreaseHeight(overflowPartHeight);
        }
        FloatingHelper.removeFloatsAboveRendererBottom(floatRendererAreas, this);
        LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
        if (null == overflowRenderer) {
            return new MinMaxWidthLayoutResult(1, editedArea, null, null, null).setMinMaxWidth(minMaxWidth);
        }
        return new MinMaxWidthLayoutResult(2, editedArea, this, overflowRenderer, null).setMinMaxWidth(minMaxWidth);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ParagraphRenderer((Paragraph)this.modelElement);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        if ((property == 46 || property == 43) && this.parent instanceof CellRenderer) {
            return (T1)Float.valueOf(0.0f);
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lines != null && this.lines.size() > 0) {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(this.lines.get(i).toString());
            }
        } else {
            for (IRenderer renderer : this.childRenderers) {
                sb.append(renderer.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        if (this.lines != null) {
            for (LineRenderer line : this.lines) {
                line.draw(drawContext);
            }
        }
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        if (null != this.lines) {
            for (LineRenderer line : this.lines) {
                line.move(dxRight, dyUp);
            }
        }
    }

    public List<LineRenderer> getLines() {
        return this.lines;
    }

    @Override
    protected Float getFirstYLineRecursively() {
        if (this.lines == null || this.lines.size() == 0) {
            return null;
        }
        return this.lines.get(0).getFirstYLineRecursively();
    }

    @Override
    protected Float getLastYLineRecursively() {
        if (this.lines == null || this.lines.size() == 0) {
            return null;
        }
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Float yLine = this.lines.get(i).getLastYLineRecursively();
            if (yLine == null) continue;
            return yLine;
        }
        return null;
    }

    @Deprecated
    protected ParagraphRenderer createOverflowRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    @Deprecated
    protected ParagraphRenderer createSplitRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    protected ParagraphRenderer createOverflowRenderer(IRenderer parent) {
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = parent;
        this.fixOverflowRenderer(overflowRenderer);
        return overflowRenderer;
    }

    protected ParagraphRenderer createSplitRenderer(IRenderer parent) {
        ParagraphRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.parent = parent;
        splitRenderer.properties = new HashMap(this.properties);
        return splitRenderer;
    }

    @Override
    protected MinMaxWidth getMinMaxWidth(float availableWidth) {
        MinMaxWidth minMaxWidth = new MinMaxWidth(0.0f, availableWidth);
        Float rotation = this.getPropertyAsFloat(55);
        if (!this.setMinMaxWidthBasedOnFixedWidth(minMaxWidth)) {
            Float maxWidth;
            Float minWidth = this.hasAbsoluteUnitValue(108) ? this.retrieveMinWidth(0.0f) : null;
            Float f = maxWidth = this.hasAbsoluteUnitValue(107) ? this.retrieveMaxWidth(0.0f) : null;
            if (minWidth == null || maxWidth == null) {
                boolean restoreRotation = this.hasOwnProperty(55);
                this.setProperty(55, null);
                MinMaxWidthLayoutResult result = (MinMaxWidthLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(availableWidth, 1000000.0f))));
                if (restoreRotation) {
                    this.setProperty(55, rotation);
                } else {
                    this.deleteOwnProperty(55);
                }
                minMaxWidth = result.getNotNullMinMaxWidth(availableWidth);
            }
            if (minWidth != null) {
                minMaxWidth.setChildrenMinWidth(minWidth.floatValue());
            }
            if (maxWidth != null) {
                minMaxWidth.setChildrenMaxWidth(maxWidth.floatValue());
            }
            if (minMaxWidth.getChildrenMinWidth() > minMaxWidth.getChildrenMaxWidth()) {
                minMaxWidth.setChildrenMaxWidth(minMaxWidth.getChildrenMaxWidth());
            }
        } else {
            minMaxWidth.setAdditionalWidth(ParagraphRenderer.calculateAdditionalWidth(this));
        }
        return rotation != null ? RotationUtils.countRotationMinMaxWidth(minMaxWidth, this) : minMaxWidth;
    }

    protected ParagraphRenderer[] split() {
        ParagraphRenderer splitRenderer = this.createSplitRenderer(this.parent);
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer(this.parent);
        return new ParagraphRenderer[]{splitRenderer, overflowRenderer};
    }

    private void fixOverflowRenderer(ParagraphRenderer overflowRenderer) {
        float firstLineIndent = overflowRenderer.getPropertyAsFloat(18).floatValue();
        if (firstLineIndent != 0.0f) {
            overflowRenderer.setProperty(18, 0);
        }
    }
}

