/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.css.impl;

import cfca.sadk.com.itextpdf.io.util.ResourceUtil;
import cfca.sadk.com.itextpdf.io.util.StreamUtil;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssDeclaration;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssStatement;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssStyleSheet;
import cfca.sadk.com.itextpdf.styledxmlparser.css.ICssResolver;
import cfca.sadk.com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import cfca.sadk.com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import cfca.sadk.com.itextpdf.styledxmlparser.css.parse.CssRuleSetParser;
import cfca.sadk.com.itextpdf.styledxmlparser.css.parse.CssStyleSheetParser;
import cfca.sadk.com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import cfca.sadk.com.itextpdf.styledxmlparser.node.IAttribute;
import cfca.sadk.com.itextpdf.styledxmlparser.node.IDataNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.IDocumentNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.IElementNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.INode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.IStylesContainer;
import cfca.sadk.com.itextpdf.styledxmlparser.node.ITextNode;
import cfca.sadk.com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import cfca.sadk.com.itextpdf.svg.css.impl.StyleResolverUtil;
import cfca.sadk.com.itextpdf.svg.processors.impl.SvgProcessorContext;
import cfca.sadk.com.itextpdf.svg.utils.SvgCssUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvgStyleResolver
implements ICssResolver {
    private CssStyleSheet css;
    private static final String DEFAULT_CSS_PATH = "cfca/sadk/com/itextpdf/svg/default.css";
    private MediaDeviceDescription deviceDescription;
    private List<CssFontFaceRule> fonts = new ArrayList<CssFontFaceRule>();
    private StyleResolverUtil sru = new StyleResolverUtil();
    private ResourceResolver resourceResolver = new ResourceResolver("");

    public SvgStyleResolver(InputStream defaultCssStream) throws IOException {
        this.css = CssStyleSheetParser.parse(defaultCssStream);
    }

    public SvgStyleResolver() {
        try {
            InputStream defaultCss = ResourceUtil.getResourceStream(DEFAULT_CSS_PATH);
            this.css = CssStyleSheetParser.parse(defaultCss);
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("Error loading the default CSS. Initializing an empty style sheet.", (Throwable)e);
            this.css = new CssStyleSheet();
        }
    }

    public SvgStyleResolver(INode rootNode, SvgProcessorContext context) {
        this.deviceDescription = context.getDeviceDescription();
        this.resourceResolver = context.getResourceResolver();
        this.collectCssDeclarations(rootNode, context.getResourceResolver());
        this.collectFonts();
    }

    @Override
    public Map<String, String> resolveStyles(INode node, AbstractCssContext context) {
        HashMap<String, String> styles = new HashMap<String, String>();
        List<CssDeclaration> styleSheetDeclarations = this.css.getCssDeclarations(node, MediaDeviceDescription.createDefault());
        for (CssDeclaration cssDeclaration : styleSheetDeclarations) {
            styles.put(cssDeclaration.getProperty(), cssDeclaration.getExpression());
        }
        if (node instanceof IElementNode) {
            IElementNode eNode = (IElementNode)node;
            for (IAttribute attr : eNode.getAttributes()) {
                this.processAttribute(attr, styles);
            }
        }
        if (node.parentNode() instanceof IStylesContainer) {
            IStylesContainer parentNode = (IStylesContainer)((Object)node.parentNode());
            Map<String, String> map = parentNode.getStyles();
            if (map == null && !(node.parentNode() instanceof IDocumentNode)) {
                Logger logger = LoggerFactory.getLogger(SvgStyleResolver.class);
                logger.error("Element parent styles are not resolved. Styles for current element might be incorrect.");
            }
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String parentFontSizeString = map.get("font-size");
                    if (parentFontSizeString == null) {
                        parentFontSizeString = "0";
                    }
                    this.sru.mergeParentStyleDeclaration(styles, entry.getKey(), entry.getValue(), parentFontSizeString);
                }
            }
        }
        return styles;
    }

    private void processXLink(IAttribute attr, Map<String, String> attributesMap) {
        String xlinkValue = attr.getValue();
        if (!this.isStartedWithHash(xlinkValue)) {
            try {
                xlinkValue = this.resourceResolver.resolveAgainstBaseUri(attr.getValue()).toExternalForm();
            }
            catch (MalformedURLException mue) {
                Logger logger = LoggerFactory.getLogger(SvgStyleResolver.class);
                logger.error("Unable to resolve image path with given base URI ({0}) and image source path ({1})", (Throwable)mue);
            }
        }
        attributesMap.put(attr.getKey(), xlinkValue);
    }

    private boolean isStartedWithHash(String s) {
        return s != null && s.startsWith("#");
    }

    private void collectCssDeclarations(INode rootNode, ResourceResolver resourceResolver) {
        this.css = new CssStyleSheet();
        LinkedList<INode> q = new LinkedList<INode>();
        if (rootNode != null) {
            q.add(rootNode);
        }
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.pop();
            if (currentNode instanceof IElementNode) {
                IElementNode headChildElement = (IElementNode)currentNode;
                if ("style".equals(headChildElement.name())) {
                    if (!currentNode.childNodes().isEmpty() && (currentNode.childNodes().get(0) instanceof IDataNode || currentNode.childNodes().get(0) instanceof ITextNode)) {
                        String styleData = currentNode.childNodes().get(0) instanceof IDataNode ? ((IDataNode)currentNode.childNodes().get(0)).getWholeData() : ((ITextNode)currentNode.childNodes().get(0)).wholeText();
                        CssStyleSheet styleSheet = CssStyleSheetParser.parse(styleData);
                        this.css.appendCssStyleSheet(styleSheet);
                    }
                } else if (SvgCssUtils.isStyleSheetLink(headChildElement)) {
                    String styleSheetUri = headChildElement.getAttribute("href");
                    try {
                        InputStream stream = resourceResolver.retrieveStyleSheet(styleSheetUri);
                        byte[] bytes = StreamUtil.inputStreamToArray(stream);
                        CssStyleSheet styleSheet = CssStyleSheetParser.parse(new ByteArrayInputStream(bytes), resourceResolver.resolveAgainstBaseUri(styleSheetUri).toExternalForm());
                        this.css.appendCssStyleSheet(styleSheet);
                    }
                    catch (IOException exc) {
                        Logger logger = LoggerFactory.getLogger(SvgStyleResolver.class);
                        logger.error("Unable to process external css file", (Throwable)exc);
                    }
                }
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
    }

    public List<CssFontFaceRule> getFonts() {
        return new ArrayList<CssFontFaceRule>(this.fonts);
    }

    private void collectFonts() {
        for (CssStatement cssStatement : this.css.getStatements()) {
            this.collectFonts(cssStatement);
        }
    }

    private void collectFonts(CssStatement cssStatement) {
        if (cssStatement instanceof CssFontFaceRule) {
            this.fonts.add((CssFontFaceRule)cssStatement);
        } else if (cssStatement instanceof CssMediaRule && ((CssMediaRule)cssStatement).matchMediaDevice(this.deviceDescription)) {
            for (CssStatement cssSubStatement : ((CssMediaRule)cssStatement).getStatements()) {
                this.collectFonts(cssSubStatement);
            }
        }
    }

    private void processAttribute(IAttribute attr, Map<String, String> styles) {
        String attrKey = attr.getKey();
        if ("style".equals(attrKey)) {
            Map<String, String> parsed = this.parseStylesFromStyleAttribute(attr.getValue());
            for (Map.Entry<String, String> style : parsed.entrySet()) {
                styles.put(style.getKey(), style.getValue());
            }
        } else if ("xlink:href".equals(attrKey)) {
            this.processXLink(attr, styles);
        } else {
            styles.put(attr.getKey(), attr.getValue());
        }
    }

    private Map<String, String> parseStylesFromStyleAttribute(String style) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        List<CssDeclaration> declarations = CssRuleSetParser.parsePropertyDeclarations(style);
        for (CssDeclaration declaration : declarations) {
            parsed.put(declaration.getProperty(), declaration.getExpression());
        }
        return parsed;
    }
}

