/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.core;

import cfca.sadk.com.google.typography.font.sfntly.data.FontData;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMap;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class CMapFormat12
extends CMap {
    private final int numberOfGroups;

    protected CMapFormat12(ReadableFontData data, CMapTable.CMapId cmapId) {
        super(data, CMap.CMapFormat.Format12.value, cmapId);
        this.numberOfGroups = this.data.readULongAsInt(CMapTable.Offset.format12nGroups.offset);
    }

    private int groupStartChar(int groupIndex) {
        return this.data.readULongAsInt(CMapTable.Offset.format12Groups.offset + groupIndex * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_startCharCode.offset);
    }

    private int groupEndChar(int groupIndex) {
        return this.data.readULongAsInt(CMapTable.Offset.format12Groups.offset + groupIndex * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_endCharCode.offset);
    }

    private int groupStartGlyph(int groupIndex) {
        return this.data.readULongAsInt(CMapTable.Offset.format12Groups.offset + groupIndex * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_startGlyphId.offset);
    }

    public static int groupCount(ReadableFontData data) {
        int groupCount = data.readULongAsInt(CMapTable.Offset.format12nGroups.offset);
        return groupCount;
    }

    public static int groupStartCode(ReadableFontData data, int groupIndex) {
        int startCode = data.readULongAsInt(CMapTable.Offset.format12Groups.offset + groupIndex * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_startCharCode.offset);
        return startCode;
    }

    public static int groupEndCode(ReadableFontData data, int groupIndex) {
        int endCode = data.readULongAsInt(CMapTable.Offset.format12Groups.offset + groupIndex * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_endCharCode.offset);
        return endCode;
    }

    public static int groupStartGlyph(ReadableFontData data, int groupIndex) {
        int startGlyph = data.readULongAsInt(CMapTable.Offset.format12Groups.offset + groupIndex * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_startGlyphId.offset);
        return startGlyph;
    }

    @Override
    public int glyphId(int character) {
        int group = this.data.searchULong(CMapTable.Offset.format12Groups.offset + CMapTable.Offset.format12_startCharCode.offset, CMapTable.Offset.format12Groups_structLength.offset, CMapTable.Offset.format12Groups.offset + CMapTable.Offset.format12_endCharCode.offset, CMapTable.Offset.format12Groups_structLength.offset, this.numberOfGroups, character);
        if (group == -1) {
            return 0;
        }
        return this.groupStartGlyph(group) + (character - this.groupStartChar(group));
    }

    @Override
    public int language() {
        return this.data.readULongAsInt(CMapTable.Offset.format12Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat12> {
        private List<Group> groups;

        protected Builder(WritableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format12Length.offset)), CMap.CMapFormat.Format12, cmapId);
        }

        protected Builder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format12Length.offset)), CMap.CMapFormat.Format12, cmapId);
        }

        private void initialize(ReadableFontData data) {
            this.groups = new ArrayList<Group>();
            if (data == null || data.length() == 0) {
                return;
            }
            int groupCount = CMapFormat12.groupCount(data);
            for (int index = 0; index < groupCount; ++index) {
                Group group = new Group();
                group.setGroupStartCode(CMapFormat12.groupStartCode(data, index));
                group.setGroupEndCode(CMapFormat12.groupEndCode(data, index));
                group.setGroupStartGlyph(CMapFormat12.groupStartGlyph(data, index));
                this.groups.add(group);
            }
        }

        public List<Group> getGroups() {
            if (this.groups == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.groups;
        }

        public void setGroups(List<Group> groups) {
            this.groups = Group.deepCopy(groups);
            this.setModelChanged();
        }

        @Override
        protected CMapFormat12 subBuildTable(ReadableFontData data) {
            return new CMapFormat12(data, this.cmapId());
        }

        @Override
        protected void subDataSet() {
            this.groups = null;
            super.setModelChanged(false);
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (!this.modelChanged()) {
                return super.subDataSizeToSerialize();
            }
            int size = CMapTable.Offset.format12Groups.offset + this.groups.size() * CMapTable.Offset.format12Groups_structLength.offset;
            return size;
        }

        @Override
        protected boolean subReadyToSerialize() {
            if (!this.modelChanged()) {
                return super.subReadyToSerialize();
            }
            return this.groups != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            if (!this.modelChanged()) {
                return super.subSerialize(newData);
            }
            int index = 0;
            index += newData.writeUShort(index, CMap.CMapFormat.Format12.value());
            index += newData.writeUShort(index, 0);
            index += FontData.DataSize.ULONG.size();
            index += newData.writeULong(index, this.language());
            index += newData.writeULong(index, this.groups.size());
            for (int i = 0; i < this.groups.size(); ++i) {
                index += newData.writeULong(index, this.groups.get(i).getGroupStartCode());
                index += newData.writeULong(index, this.groups.get(i).getGroupEndCode());
                index += newData.writeULong(index, this.groups.get(i).getGroupStartGlyph());
            }
            newData.writeULong(CMapTable.Offset.format12Length.offset, index);
            return index;
        }

        public static class Group {
            private int groupStartCode;
            private int groupEndCode;
            private int groupStartGlyph;

            public static List<Group> deepCopy(List<Group> original) {
                ArrayList<Group> list = new ArrayList<Group>(original.size());
                for (Group group : original) {
                    list.add(new Group(group));
                }
                return list;
            }

            public Group() {
            }

            public Group(Group other) {
                this(other.groupStartCode, other.groupEndCode, other.groupStartGlyph);
            }

            public Group(int groupStartCode, int groupEndCode, int groupStartGlyph) {
                this.groupStartCode = groupStartCode;
                this.groupEndCode = groupEndCode;
                this.groupStartGlyph = groupStartGlyph;
            }

            public int getGroupStartCode() {
                return this.groupStartCode;
            }

            public void setGroupStartCode(int groupStartCode) {
                this.groupStartCode = groupStartCode;
            }

            public int getGroupEndCode() {
                return this.groupEndCode;
            }

            public void setGroupEndCode(int groupEndCode) {
                this.groupEndCode = groupEndCode;
            }

            public int getGroupStartGlyph() {
                return this.groupStartGlyph;
            }

            public void setGroupStartGlyph(int groupStartGlyph) {
                this.groupStartGlyph = groupStartGlyph;
            }

            public String toString() {
                return String.format("[0x%08x - 0x%08x, groupStartGlyph = 0x%08x]", this.groupStartCode, this.groupEndCode, this.groupStartGlyph);
            }
        }
    }

    private final class CharacterIterator
    implements Iterator<Integer> {
        private int groupIndex = 0;
        private int groupEndChar;
        private boolean nextSet = false;
        private int nextChar;

        private CharacterIterator() {
            this.nextChar = CMapFormat12.this.groupStartChar(this.groupIndex);
            this.groupEndChar = CMapFormat12.this.groupEndChar(this.groupIndex);
            this.nextSet = true;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSet) {
                return true;
            }
            if (this.groupIndex >= CMapFormat12.this.numberOfGroups) {
                return false;
            }
            if (this.nextChar < this.groupEndChar) {
                ++this.nextChar;
                this.nextSet = true;
                return true;
            }
            ++this.groupIndex;
            if (this.groupIndex < CMapFormat12.this.numberOfGroups) {
                this.nextSet = true;
                this.nextChar = CMapFormat12.this.groupStartChar(this.groupIndex);
                this.groupEndChar = CMapFormat12.this.groupEndChar(this.groupIndex);
                return true;
            }
            return false;
        }

        @Override
        public Integer next() {
            if (!this.nextSet && !this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            this.nextSet = false;
            return this.nextChar;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

