/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.barcodes;

import cfca.sadk.com.itextpdf.barcodes.Barcode1D;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodePostnet
extends Barcode1D {
    public static int TYPE_POSTNET = 1;
    public static int TYPE_PLANET = 2;
    private static final byte[][] BARS = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet(PdfDocument document) {
        super(document);
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = TYPE_POSTNET;
    }

    public static byte[] getBarsPostnet(String text) {
        int total = 0;
        for (int k = text.length() - 1; k >= 0; --k) {
            int n = text.charAt(k) - 48;
            total += n;
        }
        text = text + (char)((10 - total % 10) % 10 + 48);
        byte[] bars = new byte[text.length() * 5 + 2];
        bars[0] = 1;
        bars[bars.length - 1] = 1;
        for (int k = 0; k < text.length(); ++k) {
            int c = text.charAt(k) - 48;
            System.arraycopy(BARS[c], 0, bars, k * 5 + 1, 5);
        }
        return bars;
    }

    @Override
    public Rectangle getBarcodeSize() {
        float width = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(width, this.barHeight);
    }

    @Override
    public void fitWidth(float width) {
        byte[] bars = BarcodePostnet.getBarsPostnet(this.code);
        float currentWidth = this.getBarcodeSize().getWidth();
        this.x *= width / currentWidth;
        this.n = (width - this.x) / (float)(bars.length - 1);
    }

    @Override
    public Rectangle placeBarcode(PdfCanvas canvas, cfca.sadk.com.itextpdf.kernel.color.Color barColor, cfca.sadk.com.itextpdf.kernel.color.Color textColor) {
        if (barColor != null) {
            canvas.setFillColor(barColor);
        }
        byte[] bars = BarcodePostnet.getBarsPostnet(this.code);
        byte flip = 1;
        if (this.codeType == TYPE_PLANET) {
            flip = 0;
            bars[0] = 0;
            bars[bars.length - 1] = 0;
        }
        float startX = 0.0f;
        for (int k = 0; k < bars.length; ++k) {
            canvas.rectangle(startX, 0.0, this.x - this.inkSpreading, bars[k] == flip ? (double)this.barHeight : (double)this.size);
            startX += this.n;
        }
        canvas.fill();
        return this.getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color foreground, Color background) {
        int k;
        int j;
        int barTall;
        int barShort;
        int barDistance;
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        int barWidth = (int)this.x;
        if (barWidth <= 0) {
            barWidth = 1;
        }
        if ((barDistance = (int)this.n) <= barWidth) {
            barDistance = barWidth + 1;
        }
        if ((barShort = (int)this.size) <= 0) {
            barShort = 1;
        }
        if ((barTall = (int)this.barHeight) <= barShort) {
            barTall = barShort + 1;
        }
        int width = ((this.code.length() + 1) * 5 + 1) * barDistance + barWidth;
        int[] pix = new int[width * barTall];
        byte[] bars = BarcodePostnet.getBarsPostnet(this.code);
        byte flip = 1;
        if (this.codeType == TYPE_PLANET) {
            flip = 0;
            bars[0] = 0;
            bars[bars.length - 1] = 0;
        }
        int idx = 0;
        for (int k2 = 0; k2 < bars.length; ++k2) {
            boolean dot = bars[k2] == flip;
            for (j = 0; j < barDistance; ++j) {
                pix[idx + j] = dot && j < barWidth ? f : g;
            }
            idx += barDistance;
        }
        int limit = width * (barTall - barShort);
        for (k = width; k < limit; k += width) {
            System.arraycopy(pix, 0, pix, k, width);
        }
        idx = limit;
        for (k = 0; k < bars.length; ++k) {
            for (j = 0; j < barDistance; ++j) {
                pix[idx + j] = j < barWidth ? f : g;
            }
            idx += barDistance;
        }
        for (k = limit + width; k < pix.length; k += width) {
            System.arraycopy(pix, limit, pix, k, width);
        }
        Image img = canvas.createImage(new MemoryImageSource(width, barTall, pix, 0, width));
        return img;
    }
}

