/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class FontNames
implements Serializable {
    private static final long serialVersionUID = 1005168842463622025L;
    protected static final int BOLD_FLAG = 1;
    protected static final int ITALIC_FLAG = 2;
    protected static final int UNDERLINE_FLAG = 4;
    protected static final int OUTLINE_FLAG = 8;
    protected static final int SHADOW_FLAG = 16;
    protected static final int CONDENSED_FLAG = 32;
    protected static final int EXTENDED_FLAG = 64;
    protected static final int FW_THIN = 100;
    protected static final int FW_EXTRALIGHT = 200;
    protected static final int FW_LIGHT = 300;
    protected static final int FW_NORMAL = 400;
    protected static final int FW_MEDIUM = 500;
    protected static final int FW_SEMIBOLD = 600;
    protected static final int FW_BOLD = 700;
    protected static final int FW_EXTRABOLD = 800;
    protected static final int FW_BLACK = 900;
    protected static final int FWIDTH_ULTRA_CONDENSED = 1;
    protected static final int FWIDTH_EXTRA_CONDENSED = 2;
    protected static final int FWIDTH_CONDENSED = 3;
    protected static final int FWIDTH_SEMI_CONDENSED = 4;
    protected static final int FWIDTH_NORMAL = 5;
    protected static final int FWIDTH_SEMI_EXPANDED = 6;
    protected static final int FWIDTH_EXPANDED = 7;
    protected static final int FWIDTH_EXTRA_EXPANDED = 8;
    protected static final int FWIDTH_ULTRA_EXPANDED = 9;
    protected Map<Integer, List<String[]>> allNames;
    private String[][] fullName;
    private String[][] familyName;
    private String[][] subfamily;
    private String fontName;
    private String style = "";
    private String cidFontName;
    private int weight = 400;
    private int width = 5;
    private int macStyle;
    private boolean allowEmbedding;

    public String[][] getNames(int id) {
        List<String[]> names = this.allNames.get(id);
        return names != null && names.size() > 0 ? this.listToArray(names) : (String[][])null;
    }

    public String[][] getFullName() {
        return this.fullName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getCidFontName() {
        return this.cidFontName;
    }

    public String[][] getFamilyName() {
        return this.familyName;
    }

    public String getStyle() {
        return this.style;
    }

    public String getSubfamily() {
        return this.subfamily != null ? this.subfamily[0][3] : "";
    }

    public int getFontWeight() {
        return this.weight;
    }

    public void setFontWeight(int weight) {
        this.weight = weight;
    }

    public int getFontWidth() {
        return this.width;
    }

    public void setFontWidth(int width) {
        this.width = width;
    }

    public boolean allowEmbedding() {
        return this.allowEmbedding;
    }

    public boolean isBold() {
        return (this.macStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.macStyle & 2) != 0;
    }

    public boolean isUnderline() {
        return (this.macStyle & 4) != 0;
    }

    public boolean isOutline() {
        return (this.macStyle & 8) != 0;
    }

    public boolean isShadow() {
        return (this.macStyle & 0x10) != 0;
    }

    public boolean isCondensed() {
        return (this.macStyle & 0x20) != 0;
    }

    public boolean isExtended() {
        return (this.macStyle & 0x40) != 0;
    }

    protected void setAllNames(Map<Integer, List<String[]>> allNames) {
        this.allNames = allNames;
    }

    protected void setFullName(String[][] fullName) {
        this.fullName = fullName;
    }

    protected void setFullName(String fullName) {
        this.fullName = new String[][]{{"", "", "", fullName}};
    }

    protected void setFontName(String psFontName) {
        this.fontName = psFontName;
    }

    protected void setCidFontName(String cidFontName) {
        this.cidFontName = cidFontName;
    }

    protected void setFamilyName(String[][] familyName) {
        this.familyName = familyName;
    }

    protected void setFamilyName(String familyName) {
        this.familyName = new String[][]{{"", "", "", familyName}};
    }

    protected void setStyle(String style) {
        this.style = style;
    }

    protected void setSubfamily(String subfamily) {
        this.subfamily = new String[][]{{"", "", "", subfamily}};
    }

    protected void setSubfamily(String[][] subfamily) {
        this.subfamily = subfamily;
    }

    protected void setWeight(int weight) {
        this.weight = weight;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    protected void setMacStyle(int macStyle) {
        this.macStyle = macStyle;
    }

    protected int getMacStyle() {
        return this.macStyle;
    }

    protected void setAllowEmbedding(boolean allowEmbedding) {
        this.allowEmbedding = allowEmbedding;
    }

    protected static int convertFontWeight(String weight) {
        String fontWeight = weight.toLowerCase();
        if ("ultralight".equals(fontWeight)) {
            return 100;
        }
        if ("thin".equals(fontWeight) || "extralight".equals(fontWeight)) {
            return 200;
        }
        if ("light".equals(fontWeight)) {
            return 300;
        }
        if ("book".equals(fontWeight) || "regular".equals(fontWeight) || "normal".equals(fontWeight)) {
            return 400;
        }
        if ("medium".equals(fontWeight)) {
            return 500;
        }
        if ("demibold".equals(fontWeight) || "semibold".equals(fontWeight)) {
            return 600;
        }
        if ("bold".equals(fontWeight)) {
            return 700;
        }
        if ("extrabold".equals(fontWeight) || "ultrabold".equals(fontWeight)) {
            return 800;
        }
        if ("heavy".equals(fontWeight) || "black".equals(fontWeight) || "ultra".equals(fontWeight) || "ultrablack".equals(fontWeight)) {
            return 900;
        }
        if ("fat".equals(fontWeight) || "extrablack".equals(fontWeight)) {
            return 1000;
        }
        return 400;
    }

    private String[][] listToArray(List<String[]> list) {
        String[][] array = new String[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public String toString() {
        String name = this.getFontName();
        return name.length() > 0 ? name : super.toString();
    }
}

