/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf;

import cfca.sadk.com.itextpdf.io.font.PdfEncodings;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import java.util.Arrays;

public class PdfLiteral
extends PdfPrimitiveObject {
    private static final long serialVersionUID = -770215611509192403L;
    private long position;

    public PdfLiteral(byte[] content) {
        super(true);
        this.content = content;
    }

    public PdfLiteral(int size) {
        this(new byte[size]);
        Arrays.fill(this.content, (byte)32);
    }

    public PdfLiteral(String content) {
        this(PdfEncodings.convertToBytes(content, null));
    }

    private PdfLiteral() {
        this((byte[])null);
    }

    @Override
    public byte getType() {
        return 4;
    }

    public String toString() {
        if (this.content != null) {
            return new String(this.content);
        }
        return "";
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int getBytesCount() {
        return this.content.length;
    }

    @Override
    protected void generateContent() {
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.content, ((PdfLiteral)o).content);
    }

    public int hashCode() {
        return this.content == null ? 0 : Arrays.hashCode(this.content);
    }

    @Override
    protected PdfLiteral newInstance() {
        return new PdfLiteral();
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfLiteral literal = (PdfLiteral)from;
        this.content = literal.getInternalContent();
    }
}

